/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.id;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndBranch;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.id.CDOIDMeta;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.id.CDOIDAndBranchImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDAndVersionImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDExternalImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDMetaImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDMetaRangeImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDObjectLongImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDObjectLongWithClassifierImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDObjectStringImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDObjectStringWithClassifierImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDObjectUUIDImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDTempMetaImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDTempObjectExternalImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDTempObjectImpl;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOID;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOIDLong;
import org.eclipse.emf.cdo.spi.common.id.InternalCDOIDObject;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public final class CDOIDUtil {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_MODEL, CDOIDUtil.class);

    private CDOIDUtil() {
    }

    public static boolean isNull(CDOID id) {
        return id == null || id.isNull();
    }

    public static long getLong(CDOID id) {
        if (id == null) {
            return 0L;
        }
        switch (id.getType()) {
            case NULL: {
                return 0L;
            }
            case OBJECT: {
                if (id instanceof AbstractCDOIDLong) {
                    return ((AbstractCDOIDLong)id).getLongValue();
                }
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOIDUtil.0"), id.getClass().getName()));
            }
            case META: {
                return ((CDOIDMeta)id).getLongValue();
            }
            case TEMP_OBJECT: 
            case TEMP_META: {
                throw new IllegalArgumentException(Messages.getString("CDOIDUtil.1"));
            }
            case EXTERNAL_OBJECT: 
            case EXTERNAL_TEMP_OBJECT: {
                throw new IllegalArgumentException(Messages.getString("CDOIDUtil.2"));
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOIDUtil.3"), id.getClass().getName()));
    }

    public static CDOClassifierRef getClassifierRef(CDOID id) {
        if (id instanceof CDOClassifierRef.Provider) {
            return ((CDOClassifierRef.Provider)((Object)id)).getClassifierRef();
        }
        return null;
    }

    public static CDOIDTemp createTempMeta(int value) {
        return new CDOIDTempMetaImpl(value);
    }

    public static CDOIDTemp createTempObject(int value) {
        return new CDOIDTempObjectImpl(value);
    }

    public static CDOIDExternal createTempObjectExternal(String uri) {
        return new CDOIDTempObjectExternalImpl(uri);
    }

    public static CDOID createLong(long value) {
        if (value == 0L) {
            return CDOID.NULL;
        }
        return new CDOIDObjectLongImpl(value);
    }

    public static CDOID createStringWithClassifier(CDOClassifierRef classifierRef, String value) {
        return new CDOIDObjectStringWithClassifierImpl(classifierRef, value);
    }

    public static CDOID createLongWithClassifier(CDOClassifierRef classifierRef, long value) {
        return new CDOIDObjectLongWithClassifierImpl(classifierRef, value);
    }

    public static CDOIDExternal createExternal(String uri) {
        return new CDOIDExternalImpl(uri);
    }

    public static CDOIDMeta createMeta(long value) {
        return new CDOIDMetaImpl(value);
    }

    public static CDOIDMetaRange createMetaRange(CDOID lowerBound, int count) {
        return new CDOIDMetaRangeImpl(lowerBound, count);
    }

    public static CDOIDAndVersion createIDAndVersion(CDOID id, int version) {
        return new CDOIDAndVersionImpl(id, version);
    }

    public static CDOIDAndVersion createIDAndVersion(CDOIDAndVersion source) {
        return CDOIDUtil.createIDAndVersion(source.getID(), source.getVersion());
    }

    public static CDOIDAndBranch createIDAndBranch(CDOID id, CDOBranch branch) {
        return new CDOIDAndBranchImpl(id, branch);
    }

    public static AbstractCDOID createCDOIDObject(CDOID.ObjectType subType) {
        AbstractCDOID id;
        if (subType == null) {
            throw new IllegalArgumentException("SubType may not be null");
        }
        switch (subType) {
            case LONG: {
                id = new CDOIDObjectLongImpl();
                break;
            }
            case STRING: {
                id = new CDOIDObjectStringImpl();
                break;
            }
            case LONG_WITH_CLASSIFIER: {
                id = new CDOIDObjectLongWithClassifierImpl();
                break;
            }
            case STRING_WITH_CLASSIFIER: {
                id = new CDOIDObjectStringWithClassifierImpl();
                break;
            }
            case UUID: {
                id = new CDOIDObjectUUIDImpl();
                break;
            }
            default: {
                throw new IllegalArgumentException("Subtype " + subType.name() + " not supported");
            }
        }
        if (id.getSubType() != subType) {
            throw new IllegalStateException("Subtype of created id " + id + " is unequal (" + id.getSubType().name() + ") to requested subtype " + subType.name());
        }
        return id;
    }

    public static void write(StringBuilder builder, CDOID id) {
        if (id == null) {
            id = CDOID.NULL;
        }
        if (id instanceof InternalCDOIDObject) {
            InternalCDOIDObject internalCDOID = (InternalCDOIDObject)id;
            int subOrdinal = (internalCDOID.getSubType().ordinal() + 1) * -1;
            builder.append(subOrdinal);
        } else {
            CDOID.Type type = id.getType();
            int ordinal = type.ordinal();
            if (TRACER.isEnabled()) {
                TRACER.format("Writing CDOID of type {0} ({1})", new Object[]{ordinal, type});
            }
            builder.append(ordinal);
            switch (type) {
                case NULL: 
                case OBJECT: 
                case EXTERNAL_OBJECT: 
                case TEMP_OBJECT: 
                case META: 
                case TEMP_META: {
                    break;
                }
                default: {
                    throw new ImplementationError();
                }
            }
        }
        builder.append("/");
        builder.append(id.toURIFragment());
    }

    public static CDOID read(String uriFragment) {
        Object type;
        if (uriFragment.startsWith("-")) {
            return CDOIDUtil.readCDOIDObject(uriFragment);
        }
        byte ordinal = Byte.valueOf(uriFragment.substring(0, 1));
        if (TRACER.isEnabled()) {
            try {
                type = CDOID.Type.values()[ordinal].toString();
                TRACER.format("Reading CDOID of type {0} ({1})", new Object[]{ordinal, type});
            }
            catch (RuntimeException ex) {
                TRACER.trace((Throwable)ex);
            }
        }
        type = CDOID.Type.values()[ordinal];
        String fragment = uriFragment.substring(2);
        switch (CDOIDUtil.$SWITCH_TABLE$org$eclipse$emf$cdo$common$id$CDOID$Type()[((Enum)type).ordinal()]) {
            case 1: {
                return CDOID.NULL;
            }
            case 6: {
                return new CDOIDTempObjectImpl(Integer.valueOf(fragment));
            }
            case 8: {
                return new CDOIDTempMetaImpl(Integer.valueOf(fragment));
            }
            case 7: {
                return new CDOIDMetaImpl(Long.valueOf(fragment));
            }
            case 3: {
                return new CDOIDExternalImpl(fragment);
            }
            case 5: {
                return new CDOIDTempObjectExternalImpl(fragment);
            }
            case 2: {
                throw new ImplementationError();
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOIDUtil.5"), uriFragment));
    }

    private static CDOID readCDOIDObject(String uriFragment) {
        byte negOrdinal = Byte.valueOf(uriFragment.substring(0, 2));
        int ordinal = -1 * negOrdinal - 1;
        if (TRACER.isEnabled()) {
            try {
                String type = CDOID.ObjectType.values()[ordinal].toString();
                TRACER.format("Reading CDOID Object of subType {0} ({1})", new Object[]{ordinal, type});
            }
            catch (RuntimeException ex) {
                TRACER.trace((Throwable)ex);
            }
        }
        CDOID.ObjectType subType = CDOID.ObjectType.values()[ordinal];
        AbstractCDOID id = CDOIDUtil.createCDOIDObject(subType);
        String fragment = uriFragment.substring(3);
        id.read(fragment);
        return id;
    }

    public static boolean equals(CDOID id1, CDOID id2) {
        if (id1 == null) {
            id1 = CDOID.NULL;
        }
        if (id2 == null) {
            id2 = CDOID.NULL;
        }
        return ObjectUtil.equals((Object)id1, (Object)id2);
    }
}

