/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.revision;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.internal.common.revision.CDOFeatureMapEntryImpl;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisionImpl;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisionKeyImpl;
import org.eclipse.emf.cdo.spi.common.revision.CDOFeatureMapEntry;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDORevisionUtil {
    public static final Object UNINITIALIZED = new Uninitialized();

    private CDORevisionUtil() {
    }

    public static CDORevisionKey createRevisionKey(CDOID id, CDOBranch branch, int version) {
        return new CDORevisionKeyImpl(id, branch, version);
    }

    public static CDORevisionKey createRevisionKey(CDORevisionKey source) {
        return new CDORevisionKeyImpl(source.getID(), source.getBranch(), source.getVersion());
    }

    public static FeatureMap.Entry createFeatureMapEntry(EStructuralFeature feature, Object value) {
        return new CDOFeatureMapEntryImpl(feature, value);
    }

    public static CDOFeatureMapEntry createCDOFeatureMapEntry() {
        return new CDOFeatureMapEntryImpl();
    }

    public static Object remapID(Object value, Map<CDOID, CDOID> idMappings, boolean allowUnmappedTempIDs) {
        return CDORevisionImpl.remapID(value, idMappings, allowUnmappedTempIDs);
    }

    public static String dumpAllRevisions(Map<CDOBranch, List<CDORevision>> map) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        CDORevisionUtil.dumpAllRevisions(map, out);
        return baos.toString();
    }

    public static void dumpAllRevisions(Map<CDOBranch, List<CDORevision>> map, PrintStream out) {
        int pad = 48;
        ArrayList<CDOBranch> branches = new ArrayList<CDOBranch>(map.keySet());
        Collections.sort(branches);
        for (CDOBranch branch : branches) {
            out.println(CDORevisionUtil.padTimeRange(String.valueOf(branch.getName()) + "[" + branch.getID() + "]", 48, branch.getBase().getTimeStamp(), 0L));
            List<CDORevision> revisions = map.get(branch);
            Collections.sort(revisions, new Comparator<CDORevision>(){

                @Override
                public int compare(CDORevision rev1, CDORevision rev2) {
                    int result = rev1.getID().compareTo(rev2.getID());
                    if (result == 0) {
                        int version2;
                        int version1 = rev1.getVersion();
                        result = version1 < (version2 = rev2.getVersion()) ? -1 : (version1 == version2 ? 0 : 1);
                    }
                    return result;
                }
            });
            for (CDORevision revision : revisions) {
                out.println(CDORevisionUtil.padTimeRange("  " + revision, 48, revision.getTimeStamp(), revision.getRevised()));
            }
            out.println();
        }
    }

    private static String padTimeRange(String s, int pos, long t1, long t2) {
        StringBuffer buffer = new StringBuffer(s);
        while (buffer.length() < pos) {
            buffer.append(' ');
        }
        buffer.append(CDOCommonUtil.formatTimeStamp(t1));
        buffer.append("/");
        buffer.append(CDOCommonUtil.formatTimeStamp(t2));
        return buffer.toString();
    }

    private static final class Uninitialized {
        public String toString() {
            return Messages.getString("CDORevisionUtil.0");
        }
    }
}

