/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.revision.delta;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.internal.common.commit.CDOChangeSetDataImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionDeltaImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDORevisionDeltaUtil {
    private CDORevisionDeltaUtil() {
    }

    public static CDORevisionDelta create(CDORevision revision) {
        return new CDORevisionDeltaImpl(revision);
    }

    public static CDORevisionDelta copy(CDORevisionDelta revisionDelta) {
        return new CDORevisionDeltaImpl(revisionDelta, true);
    }

    public static CDORevisionDelta create(CDORevision sourceRevision, CDORevision targetRevision) {
        return new CDORevisionDeltaImpl(sourceRevision, targetRevision);
    }

    public static CDOChangeSetData createChangeSetData(Set<CDOID> ids, final CDOBranchPoint startPoint, final CDOBranchPoint endPoint, final CDORevisionManager revisionManager) {
        CDORevisionProvider startProvider = new CDORevisionProvider(){

            public CDORevision getRevision(CDOID id) {
                return revisionManager.getRevision(id, startPoint, -1, 0, true);
            }
        };
        CDORevisionProvider endProvider = new CDORevisionProvider(){

            public CDORevision getRevision(CDOID id) {
                return revisionManager.getRevision(id, endPoint, -1, 0, true);
            }
        };
        return CDORevisionDeltaUtil.createChangeSetData(ids, startProvider, endProvider);
    }

    public static CDOChangeSetData createChangeSetData(Set<CDOID> ids, CDORevisionProvider startProvider, CDORevisionProvider endProvider) {
        ArrayList<CDOIDAndVersion> newObjects = new ArrayList<CDOIDAndVersion>();
        ArrayList<CDORevisionKey> changedObjects = new ArrayList<CDORevisionKey>();
        ArrayList<CDOIDAndVersion> detachedObjects = new ArrayList<CDOIDAndVersion>();
        for (CDOID id : ids) {
            CDORevisionDelta delta;
            CDORevision startRevision = startProvider.getRevision(id);
            CDORevision endRevision = endProvider.getRevision(id);
            if (startRevision == null && endRevision != null) {
                newObjects.add(endRevision);
                continue;
            }
            if (endRevision == null && startRevision != null) {
                detachedObjects.add(CDOIDUtil.createIDAndVersion(id, 0));
                continue;
            }
            if (startRevision == null || endRevision == null || startRevision.equals(endRevision) || (delta = endRevision.compare(startRevision)).isEmpty()) continue;
            changedObjects.add(delta);
        }
        return new CDOChangeSetDataImpl(newObjects, changedObjects, detachedObjects);
    }
}

