/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.util;

import java.text.MessageFormat;

public final class CDOCommonUtil {
    private CDOCommonUtil() {
    }

    public static boolean isValidTimeStamp(long timeStamp, long startTime, long endTime) {
        if (timeStamp == 0L) {
            return endTime == 0L;
        }
        return (endTime == 0L || endTime >= timeStamp) && timeStamp >= startTime;
    }

    public static int compareTimeStamps(long t1, long t2) {
        if (t1 == 0L) {
            t1 = Long.MAX_VALUE;
        }
        if (t2 == 0L) {
            t2 = Long.MAX_VALUE;
        }
        return t1 < t2 ? -1 : (t1 == t2 ? 0 : 1);
    }

    public static String formatTimeStamp() {
        return CDOCommonUtil.formatTimeStamp(System.currentTimeMillis());
    }

    public static String formatTimeStamp(long timeStamp) {
        if (timeStamp == 0L) {
            return "*";
        }
        return MessageFormat.format("{0,date} {0,time,HH:mm:ss:SSS}", timeStamp);
    }
}

