/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOQueryInfoImpl
implements CDOQueryInfo {
    protected String queryLanguage;
    protected String queryString;
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    protected int maxResults = -1;

    public CDOQueryInfoImpl(String queryLanguage, String queryString) {
        this.queryLanguage = queryLanguage;
        this.queryString = queryString;
    }

    public CDOQueryInfoImpl(CDODataInput in) throws IOException {
        this.queryLanguage = in.readString();
        this.queryString = in.readString();
        this.maxResults = in.readInt();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            String key = in.readString();
            Object object = in.readCDORevisionOrPrimitiveOrClassifier();
            this.parameters.put(key, object);
            ++i;
        }
    }

    public void write(CDODataOutput out) throws IOException {
        out.writeString(this.queryLanguage);
        out.writeString(this.queryString);
        out.writeInt(this.maxResults);
        out.writeInt(this.parameters.size());
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            out.writeString(entry.getKey());
            out.writeCDORevisionOrPrimitiveOrClassifier(entry.getValue());
        }
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public String getQueryLanguage() {
        return this.queryLanguage;
    }

    @Override
    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public void addParameter(String key, Object value) {
        this.parameters.put(key, value);
    }

    @Override
    public int getMaxResults() {
        return this.maxResults;
    }

    public CDOQueryInfoImpl setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }
}

