/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.branch;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.internal.common.branch.CDOBranchPointImpl;
import org.eclipse.emf.cdo.internal.common.branch.CDOBranchVersionImpl;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.net4j.util.container.Container;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOBranchImpl
extends Container<CDOBranch>
implements InternalCDOBranch {
    public static final int ILLEGAL_BRANCH_ID = Integer.MIN_VALUE;
    private int id;
    private String name;
    private Object baseOrBranchManager;
    private CDOBranchPoint head = this.getPoint(0L);
    private InternalCDOBranch[] branches;

    public CDOBranchImpl(int id, String name, CDOBranchPoint base) {
        this.id = id;
        this.name = name;
        this.baseOrBranchManager = base;
    }

    public CDOBranchImpl(int id, InternalCDOBranchManager branchManager) {
        this.id = id;
        this.baseOrBranchManager = branchManager;
    }

    @Override
    public boolean isMainBranch() {
        return false;
    }

    @Override
    public boolean isLocal() {
        return this.id < 0;
    }

    @Override
    public InternalCDOBranchManager getBranchManager() {
        if (this.isProxy()) {
            return (InternalCDOBranchManager)this.baseOrBranchManager;
        }
        CDOBranchPoint base = (CDOBranchPoint)this.baseOrBranchManager;
        return (InternalCDOBranchManager)base.getBranch().getBranchManager();
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public String getName() {
        this.loadIfNeeded();
        return this.name;
    }

    @Override
    public boolean isProxy() {
        return this.name == null;
    }

    @Override
    public String getPathName() {
        StringBuilder builder = new StringBuilder();
        this.computePathName(this, builder);
        return builder.toString();
    }

    private void computePathName(CDOBranch branch, StringBuilder builder) {
        CDOBranchPoint base = branch.getBase();
        CDOBranch parent = base.getBranch();
        if (parent != null) {
            this.computePathName(parent, builder);
            builder.append("/");
        }
        builder.append(branch.getName());
    }

    @Override
    public CDOBranchPoint[] getBasePath() {
        ArrayList<CDOBranchPoint> path = new ArrayList<CDOBranchPoint>();
        this.computeBasePath(this, path);
        return path.toArray(new CDOBranchPoint[path.size()]);
    }

    private void computeBasePath(CDOBranch branch, List<CDOBranchPoint> path) {
        CDOBranchPoint base = branch.getBase();
        CDOBranch parent = base.getBranch();
        if (parent != null) {
            this.computeBasePath(parent, path);
        }
        path.add(base);
    }

    @Override
    public CDOBranchPoint getBase() {
        this.loadIfNeeded();
        return (CDOBranchPoint)this.baseOrBranchManager;
    }

    @Override
    public CDOBranchPoint getHead() {
        return this.head;
    }

    @Override
    public CDOBranchPoint getPoint(long timeStamp) {
        return new CDOBranchPointImpl(this, timeStamp);
    }

    @Override
    public CDOBranchVersion getVersion(int version) {
        return new CDOBranchVersionImpl(this, version);
    }

    @Override
    public InternalCDOBranch createBranch(String name, long timeStamp) {
        return this.getBranchManager().createBranch(Integer.MAX_VALUE, name, this, timeStamp);
    }

    @Override
    public InternalCDOBranch createBranch(String name) {
        return this.createBranch(name, 0L);
    }

    public CDOBranch[] getElements() {
        return this.getBranches();
    }

    @Override
    public synchronized InternalCDOBranch[] getBranches() {
        this.loadIfNeeded();
        if (this.branches == null) {
            InternalCDOBranchManager branchManager = this.getBranchManager();
            InternalCDOBranchManager.BranchLoader.SubBranchInfo[] infos = branchManager.getBranchLoader().loadSubBranches(this.id);
            this.branches = new InternalCDOBranch[infos.length];
            int i = 0;
            while (i < infos.length) {
                InternalCDOBranchManager.BranchLoader.SubBranchInfo info = infos[i];
                this.branches[i] = branchManager.getBranch(info.getID(), info.getName(), this, info.getBaseTimeStamp());
                ++i;
            }
        }
        return this.branches;
    }

    @Override
    public InternalCDOBranch getBranch(String path) {
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - "/".length());
        }
        int sep = path.indexOf("/");
        if (sep == -1) {
            return this.getChild(path);
        }
        String name = path.substring(0, sep);
        InternalCDOBranch child = this.getChild(name);
        if (child == null) {
            return null;
        }
        String rest = path.substring(sep + 1);
        return child.getBranch(rest);
    }

    private InternalCDOBranch getChild(String name) {
        InternalCDOBranch[] branches;
        InternalCDOBranch[] internalCDOBranchArray = branches = this.getBranches();
        int n = branches.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOBranch branch = internalCDOBranchArray[n2];
            if (name.equals(branch.getName())) {
                return branch;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public InternalCDOBranchManager.BranchLoader.BranchInfo getBranchInfo() {
        CDOBranchPoint base = this.getBase();
        return new InternalCDOBranchManager.BranchLoader.BranchInfo(this.getName(), base.getBranch().getID(), base.getTimeStamp());
    }

    @Override
    public void setBranchInfo(String name, InternalCDOBranch baseBranch, long baseTimeStamp) {
        this.name = name;
        this.baseOrBranchManager = baseBranch.getPoint(baseTimeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChild(InternalCDOBranch branch) {
        CDOBranchImpl cDOBranchImpl = this;
        synchronized (cDOBranchImpl) {
            if (this.branches == null) {
                this.branches = new InternalCDOBranch[]{branch};
            } else {
                InternalCDOBranch[] newBranches = new InternalCDOBranch[this.branches.length + 1];
                System.arraycopy(this.branches, 0, newBranches, 0, this.branches.length);
                newBranches[this.branches.length] = branch;
                this.branches = newBranches;
            }
        }
        this.fireElementAddedEvent(branch);
    }

    @Override
    public int compareTo(CDOBranch o) {
        int otherID = o.getID();
        return this.id < otherID ? -1 : (this.id == otherID ? 0 : 1);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CDOBranch) {
            CDOBranch that = (CDOBranch)obj;
            return this.id == that.getID();
        }
        return false;
    }

    public String toString() {
        if (this.isProxy()) {
            return MessageFormat.format("Branch[id={0}, PROXY]", this.id);
        }
        return MessageFormat.format("Branch[id={0}, name={1}]", this.id, this.name);
    }

    private synchronized void loadIfNeeded() {
        if (this.isProxy()) {
            InternalCDOBranchManager branchManager = (InternalCDOBranchManager)this.baseOrBranchManager;
            InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo = branchManager.getBranchLoader().loadBranch(this.id);
            InternalCDOBranch baseBranch = branchManager.getBranch(branchInfo.getBaseBranchID());
            this.name = branchInfo.getName();
            this.baseOrBranchManager = baseBranch.getPoint(branchInfo.getBaseTimeStamp());
        }
    }

    public static class Main
    extends CDOBranchImpl {
        private InternalCDOBranchManager branchManager;

        public Main(InternalCDOBranchManager branchManager, long timeStamp) {
            super(0, "MAIN", new CDOBranchPointImpl(null, timeStamp));
            this.branchManager = branchManager;
        }

        public boolean isMainBranch() {
            return true;
        }

        public InternalCDOBranchManager getBranchManager() {
            return this.branchManager;
        }
    }
}

