/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.commit;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOChangeSetDataImpl
implements CDOChangeSetData {
    private List<CDOIDAndVersion> newObjects;
    private List<CDORevisionKey> changedObjects;
    private List<CDOIDAndVersion> detachedObjects;

    public CDOChangeSetDataImpl(List<CDOIDAndVersion> newObjects, List<CDORevisionKey> changedObjects, List<CDOIDAndVersion> detachedObjects) {
        this.newObjects = newObjects;
        this.changedObjects = changedObjects;
        this.detachedObjects = detachedObjects;
    }

    public CDOChangeSetDataImpl() {
        this(new ArrayList<CDOIDAndVersion>(), new ArrayList<CDORevisionKey>(), new ArrayList<CDOIDAndVersion>());
    }

    @Override
    public boolean isEmpty() {
        if (this.newObjects != null && !this.newObjects.isEmpty()) {
            return false;
        }
        if (this.changedObjects != null && !this.changedObjects.isEmpty()) {
            return false;
        }
        return this.detachedObjects == null || this.detachedObjects.isEmpty();
    }

    @Override
    public List<CDOIDAndVersion> getNewObjects() {
        return this.newObjects;
    }

    @Override
    public List<CDORevisionKey> getChangedObjects() {
        return this.changedObjects;
    }

    @Override
    public List<CDOIDAndVersion> getDetachedObjects() {
        return this.detachedObjects;
    }

    public String toString() {
        return MessageFormat.format("ChangeSetData[newObjects={0}, changedObjects={1}, detachedObjects={2}]", this.newObjects.size(), this.changedObjects.size(), this.detachedObjects.size());
    }
}

