/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.commit;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.common.branch.CDOBranchPointImpl;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.net4j.util.CheckUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOCommitInfoImpl
extends CDOBranchPointImpl
implements CDOCommitInfo {
    private InternalCDOCommitInfoManager commitInfoManager;
    private String userID;
    private String comment;
    private CDOCommitData commitData;

    public CDOCommitInfoImpl(InternalCDOCommitInfoManager commitInfoManager, CDOBranch branch, long timeStamp, String userID, String comment, CDOCommitData commitData) {
        super(branch, timeStamp);
        CheckUtil.checkArg((Object)commitInfoManager, (String)"commitInfoManager");
        this.commitInfoManager = commitInfoManager;
        this.userID = userID;
        this.comment = comment;
        this.commitData = commitData;
    }

    @Override
    public InternalCDOCommitInfoManager getCommitInfoManager() {
        return this.commitInfoManager;
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public synchronized List<CDOPackageUnit> getNewPackageUnits() {
        this.loadCommitDataIfNeeded();
        return this.commitData.getNewPackageUnits();
    }

    @Override
    public synchronized List<CDOIDAndVersion> getNewObjects() {
        this.loadCommitDataIfNeeded();
        return this.commitData.getNewObjects();
    }

    @Override
    public synchronized List<CDORevisionKey> getChangedObjects() {
        this.loadCommitDataIfNeeded();
        return this.commitData.getChangedObjects();
    }

    @Override
    public synchronized List<CDOIDAndVersion> getDetachedObjects() {
        this.loadCommitDataIfNeeded();
        return this.commitData.getDetachedObjects();
    }

    @Override
    public String toString() {
        String data = null;
        if (this.commitData != null) {
            data = this.commitData.toString();
        }
        String timeStamp = CDOCommonUtil.formatTimeStamp(this.getTimeStamp());
        return MessageFormat.format("CommitInfo[{0}, {1}, {2}, {3}, {4}]", this.getBranch(), timeStamp, this.getUserID(), this.getComment(), data);
    }

    private void loadCommitDataIfNeeded() {
        if (this.commitData == null) {
            this.commitData = this.commitInfoManager.getCommitInfoLoader().loadCommitData(this.getTimeStamp());
        }
    }
}

