/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.model;

import java.util.ArrayList;
import org.eclipse.emf.cdo.common.model.CDOClassInfo;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CDOClassInfoImpl
extends AdapterImpl
implements CDOClassInfo {
    private EStructuralFeature[] allPersistentFeatures;
    private int[] featureIDMappings;

    public boolean isAdapterForType(Object type) {
        return type == CDOClassInfo.class;
    }

    public void setTarget(Notifier newTarget) {
        this.init((EClass)newTarget);
        super.setTarget(newTarget);
    }

    public EClass getEClass() {
        return (EClass)this.getTarget();
    }

    public boolean isResource() {
        return CDOModelUtil.isResource(this.getEClass());
    }

    public boolean isResourceFolder() {
        return CDOModelUtil.isResourceFolder(this.getEClass());
    }

    public boolean isResourceNode() {
        return CDOModelUtil.isResourceNode(this.getEClass());
    }

    public EStructuralFeature[] getAllPersistentFeatures() {
        return this.allPersistentFeatures;
    }

    public int getFeatureIndex(EStructuralFeature feature) {
        try {
            int featureID = this.getEClass().getFeatureID(feature);
            return this.getFeatureIndex(featureID);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalStateException("Feature not mapped: " + feature, ex);
        }
    }

    public int getFeatureIndex(int featureID) {
        return this.featureIDMappings[featureID];
    }

    private void init(EClass eClass) {
        int featureID;
        int maxID = 0;
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
            if (!EMFUtil.isPersistent(feature)) continue;
            features.add(feature);
            featureID = eClass.getFeatureID(feature);
            maxID = Math.max(maxID, featureID);
        }
        this.allPersistentFeatures = features.toArray(new EStructuralFeature[features.size()]);
        this.featureIDMappings = new int[maxID + 1];
        int i = 0;
        while (i < this.allPersistentFeatures.length) {
            EStructuralFeature feature = this.allPersistentFeatures[i];
            featureID = eClass.getFeatureID(feature);
            this.featureIDMappings[featureID] = i++;
        }
    }
}

