/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.model;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDTempMeta;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleState;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOPackageRegistryImpl
extends EPackageRegistryImpl
implements InternalCDOPackageRegistry {
    private static final long serialVersionUID = 1L;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, CDOPackageRegistryImpl.class);
    private static final ContextTracer METAID_TRACER = new ContextTracer(OM.DEBUG_METAID, MetaInstanceMapperImpl.class);
    private static final boolean eagerInternalCaches = false;
    private MetaInstanceMapperImpl metaInstanceMapper = new MetaInstanceMapperImpl();
    private boolean replacingDescriptors;
    private InternalCDOPackageRegistry.PackageProcessor packageProcessor;
    private InternalCDOPackageRegistry.PackageLoader packageLoader;
    private transient boolean active;
    @ReflectUtil.ExcludeFromDump
    private transient InternalCDOPackageInfo[] packageInfos;
    @ReflectUtil.ExcludeFromDump
    private transient InternalCDOPackageUnit[] packageUnits;

    @Override
    public InternalCDOPackageRegistry.MetaInstanceMapper getMetaInstanceMapper() {
        return this.metaInstanceMapper;
    }

    @Override
    public boolean isReplacingDescriptors() {
        return this.replacingDescriptors;
    }

    @Override
    public void setReplacingDescriptors(boolean replacingDescriptors) {
        this.replacingDescriptors = replacingDescriptors;
    }

    @Override
    public InternalCDOPackageRegistry.PackageProcessor getPackageProcessor() {
        return this.packageProcessor;
    }

    @Override
    public void setPackageProcessor(InternalCDOPackageRegistry.PackageProcessor packageProcessor) {
        this.packageProcessor = packageProcessor;
    }

    @Override
    public InternalCDOPackageRegistry.PackageLoader getPackageLoader() {
        return this.packageLoader;
    }

    @Override
    public void setPackageLoader(InternalCDOPackageRegistry.PackageLoader packageLoader) {
        LifecycleUtil.checkInactive((Object)this);
        this.packageLoader = packageLoader;
    }

    public Object get(Object key) {
        LifecycleUtil.checkActive((Object)this);
        return super.get(key);
    }

    @Override
    public Set<String> getAllKeys() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.keySet());
        if (this.delegateRegistry != null) {
            if (this.delegateRegistry instanceof InternalCDOPackageRegistry) {
                result.addAll(((InternalCDOPackageRegistry)this.delegateRegistry).getAllKeys());
            } else {
                result.addAll(this.delegateRegistry.keySet());
            }
        }
        return result;
    }

    @Override
    public Object getWithDelegation(String nsURI, boolean resolve) {
        Object result = CDOPackageRegistryImpl.getFrom(this, nsURI, resolve);
        if (result == null && this.delegateRegistry != null) {
            result = CDOPackageRegistryImpl.getFrom(this.delegateRegistry, nsURI, resolve);
        }
        return result;
    }

    private static Object getFrom(EPackage.Registry registry, String nsURI, boolean resolve) {
        if (resolve) {
            return registry.getEPackage(nsURI);
        }
        return registry.get((Object)nsURI);
    }

    @Override
    public Object basicPut(String nsURI, Object value) {
        Object oldValue;
        LifecycleUtil.checkActive((Object)this);
        if (TRACER.isEnabled()) {
            TRACER.format("Registering {0} --> {1}", new Object[]{nsURI, value});
        }
        if (this.packageProcessor != null) {
            value = this.packageProcessor.processPackage(value);
        }
        if ((oldValue = this.get(nsURI)) instanceof InternalCDOPackageInfo && value instanceof EPackage) {
            InternalCDOPackageInfo oldPackageInfo = (InternalCDOPackageInfo)oldValue;
            EPackage newValue = (EPackage)value;
            if (oldPackageInfo.getEPackage(false) == null) {
                EMFUtil.addAdapter((Notifier)newValue, oldPackageInfo);
                oldPackageInfo.getPackageUnit().setState(CDOPackageUnit.State.LOADED);
            }
        } else if (oldValue instanceof EPackage && value instanceof InternalCDOPackageInfo) {
            EPackage oldPackage = (EPackage)oldValue;
            InternalCDOPackageInfo oldPackageInfo = this.getPackageInfo(oldPackage);
            InternalCDOPackageInfo newPackageInfo = (InternalCDOPackageInfo)value;
            if (oldPackageInfo.getMetaIDRange().isTemporary() && !newPackageInfo.getMetaIDRange().isTemporary()) {
                oldPackageInfo.setMetaIDRange(newPackageInfo.getMetaIDRange());
            }
            InternalCDOPackageUnit oldPackageUnit = oldPackageInfo.getPackageUnit();
            InternalCDOPackageUnit newPackageUnit = newPackageInfo.getPackageUnit();
            if (oldPackageUnit.getState() == CDOPackageUnit.State.NEW && newPackageUnit.getState() != CDOPackageUnit.State.NEW) {
                oldPackageUnit.setState(CDOPackageUnit.State.LOADED);
            }
            return null;
        }
        return super.put((Object)nsURI, value);
    }

    public synchronized Object put(String nsURI, Object value) {
        EPackage ePackage;
        InternalCDOPackageInfo packageInfo;
        LifecycleUtil.checkActive((Object)this);
        if (this.replacingDescriptors && value instanceof EPackage.Descriptor) {
            EPackage.Descriptor descriptor = (EPackage.Descriptor)value;
            value = descriptor.getEPackage();
        }
        if (value instanceof EPackage && (packageInfo = this.getPackageInfo(ePackage = (EPackage)value)) == null) {
            this.initPackageUnit(ePackage);
            return null;
        }
        return this.basicPut(nsURI, value);
    }

    @Override
    public synchronized Object putEPackage(EPackage ePackage) {
        return this.put(ePackage.getNsURI(), (Object)ePackage);
    }

    @Override
    public synchronized void putPackageUnit(InternalCDOPackageUnit packageUnit) {
        LifecycleUtil.checkActive((Object)this);
        packageUnit.setPackageRegistry(this);
        InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageUnit.getPackageInfos();
        int n = internalCDOPackageInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
            EPackage ePackage = packageInfo.getEPackage(false);
            if (ePackage != null) {
                EMFUtil.addAdapter((Notifier)ePackage, packageInfo);
                this.basicPut(ePackage.getNsURI(), ePackage);
            } else {
                this.basicPut(packageInfo.getPackageURI(), packageInfo);
            }
            ++n2;
        }
        this.resetInternalCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized InternalCDOPackageInfo getPackageInfo(EPackage ePackage) {
        InternalCDOPackageInfo packageInfo;
        LifecycleUtil.checkActive((Object)this);
        Object object = this.get(ePackage.getNsURI());
        if (object instanceof InternalCDOPackageInfo && (packageInfo = (InternalCDOPackageInfo)object).getPackageUnit().getPackageRegistry() == this) {
            return packageInfo;
        }
        EPackage ePackage2 = ePackage;
        synchronized (ePackage2) {
            EList adapters = ePackage.eAdapters();
            int i = 0;
            int size = adapters.size();
            while (i < size) {
                InternalCDOPackageInfo packageInfo2;
                Adapter adapter = (Adapter)adapters.get(i);
                if (adapter instanceof InternalCDOPackageInfo && (packageInfo2 = (InternalCDOPackageInfo)adapter).getPackageUnit().getPackageRegistry() == this) {
                    return packageInfo2;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public synchronized InternalCDOPackageInfo[] getPackageInfos() {
        LifecycleUtil.checkActive((Object)this);
        if (this.packageInfos == null) {
            ArrayList<InternalCDOPackageInfo> result = new ArrayList<InternalCDOPackageInfo>();
            for (Object value : this.values()) {
                InternalCDOPackageInfo packageInfo;
                if (value instanceof InternalCDOPackageInfo) {
                    result.add((InternalCDOPackageInfo)value);
                    continue;
                }
                if (!(value instanceof EPackage) || (packageInfo = this.getPackageInfo((EPackage)value)) == null) continue;
                result.add(packageInfo);
            }
            this.packageInfos = result.toArray(new InternalCDOPackageInfo[result.size()]);
            Arrays.sort(this.packageInfos);
        }
        return this.packageInfos;
    }

    @Override
    public InternalCDOPackageUnit getPackageUnit(EPackage ePackage) {
        InternalCDOPackageInfo packageInfo = this.getPackageInfo(ePackage);
        if (packageInfo == null) {
            this.putEPackage(ePackage);
            packageInfo = this.getPackageInfo(ePackage);
            if (packageInfo == null) {
                throw new ImplementationError(MessageFormat.format(Messages.getString("CDOPackageRegistryImpl.0"), ePackage));
            }
        }
        return (InternalCDOPackageUnit)packageInfo.getPackageUnit();
    }

    @Override
    public synchronized InternalCDOPackageUnit getPackageUnit(String id) {
        LifecycleUtil.checkActive((Object)this);
        for (Object value : this.values()) {
            InternalCDOPackageInfo packageInfo;
            InternalCDOPackageUnit packageUnit = null;
            if (value instanceof InternalCDOPackageInfo) {
                packageUnit = ((InternalCDOPackageInfo)value).getPackageUnit();
            } else if (value instanceof EPackage && (packageInfo = this.getPackageInfo((EPackage)value)) != null) {
                packageUnit = packageInfo.getPackageUnit();
            }
            if (packageUnit == null || !id.equals(packageUnit.getID())) continue;
            return packageUnit;
        }
        return null;
    }

    @Override
    public synchronized InternalCDOPackageUnit[] getPackageUnits() {
        LifecycleUtil.checkActive((Object)this);
        if (this.packageUnits == null) {
            HashSet<InternalCDOPackageUnit> result = new HashSet<InternalCDOPackageUnit>();
            for (Object value : this.values()) {
                InternalCDOPackageInfo packageInfo;
                if (value instanceof InternalCDOPackageInfo) {
                    result.add(((InternalCDOPackageInfo)value).getPackageUnit());
                    continue;
                }
                if (!(value instanceof EPackage) || (packageInfo = this.getPackageInfo((EPackage)value)) == null) continue;
                InternalCDOPackageUnit packageUnit = packageInfo.getPackageUnit();
                result.add(packageUnit);
            }
            this.packageUnits = result.toArray(new InternalCDOPackageUnit[result.size()]);
            Arrays.sort(this.packageUnits);
        }
        return this.packageUnits;
    }

    @Override
    public InternalCDOPackageUnit[] getPackageUnits(long startTime, long endTime) {
        LifecycleUtil.checkActive((Object)this);
        if (endTime == 0L) {
            endTime = Long.MAX_VALUE;
        }
        HashSet<InternalCDOPackageUnit> result = new HashSet<InternalCDOPackageUnit>();
        for (Object value : this.values()) {
            long timeStamp;
            InternalCDOPackageInfo packageInfo;
            InternalCDOPackageUnit packageUnit = null;
            if (value instanceof InternalCDOPackageInfo) {
                packageUnit = ((InternalCDOPackageInfo)value).getPackageUnit();
            } else if (value instanceof EPackage && (packageInfo = this.getPackageInfo((EPackage)value)) != null) {
                packageUnit = packageInfo.getPackageUnit();
            }
            if (packageUnit == null || startTime > (timeStamp = packageUnit.getTimeStamp()) || timeStamp > endTime) continue;
            result.add(packageUnit);
        }
        return result.toArray(new InternalCDOPackageUnit[result.size()]);
    }

    @Override
    public synchronized EPackage[] getEPackages() {
        LifecycleUtil.checkActive((Object)this);
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        for (String packageURI : this.keySet()) {
            EPackage ePackage = this.getEPackage(packageURI);
            if (ePackage == null) continue;
            result.add(ePackage);
        }
        return result.toArray(new EPackage[result.size()]);
    }

    public String toString() {
        return MessageFormat.format("{0}[packageLoader={1}]", this.getClass().getSimpleName(), this.getPackageLoader());
    }

    public void addListener(IListener listener) {
    }

    public void removeListener(IListener listener) {
    }

    public IListener[] getListeners() {
        return EventUtil.NO_LISTENERS;
    }

    public boolean hasListeners() {
        return false;
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public synchronized LifecycleState getLifecycleState() {
        return this.active ? LifecycleState.ACTIVE : LifecycleState.INACTIVE;
    }

    public synchronized void activate() throws LifecycleException {
        if (!this.active) {
            CheckUtil.checkState((Object)this.packageLoader, (String)"packageLoader");
            this.active = true;
        }
    }

    public synchronized Exception deactivate() {
        if (this.active) {
            try {
                this.disposePackageUnits();
                this.metaInstanceMapper.clear();
                this.metaInstanceMapper = null;
                this.clear();
                this.active = false;
            }
            catch (RuntimeException ex) {
                return ex;
            }
        }
        return null;
    }

    protected void disposePackageUnits() {
        InternalCDOPackageUnit[] internalCDOPackageUnitArray = this.getPackageUnits();
        int n = internalCDOPackageUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
            packageUnit.dispose();
            ++n2;
        }
        this.packageInfos = null;
        this.packageUnits = null;
    }

    protected void initPackageUnit(EPackage ePackage) {
        InternalCDOPackageUnit packageUnit = this.createPackageUnit();
        packageUnit.setPackageRegistry(this);
        packageUnit.init(ePackage);
        this.resetInternalCaches();
    }

    protected void resetInternalCaches() {
        this.packageInfos = null;
        this.packageUnits = null;
    }

    protected InternalCDOPackageUnit createPackageUnit() {
        return (InternalCDOPackageUnit)CDOModelUtil.createPackageUnit();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MetaInstanceMapperImpl
    implements InternalCDOPackageRegistry.MetaInstanceMapper {
        private Map<CDOID, InternalEObject> idToMetaInstanceMap = new HashMap<CDOID, InternalEObject>();
        private Map<InternalEObject, CDOID> metaInstanceToIDMap = new HashMap<InternalEObject, CDOID>();
        @ReflectUtil.ExcludeFromDump
        private transient int lastTempMetaID;

        @Override
        public synchronized InternalEObject lookupMetaInstance(CDOID id) {
            LifecycleUtil.checkActive((Object)CDOPackageRegistryImpl.this);
            InternalEObject metaInstance = this.idToMetaInstanceMap.get(id);
            if (metaInstance != null) {
                return metaInstance;
            }
            if (CDOPackageRegistryImpl.this.delegateRegistry instanceof InternalCDOPackageRegistry) {
                try {
                    InternalCDOPackageRegistry delegate = (InternalCDOPackageRegistry)CDOPackageRegistryImpl.this.delegateRegistry;
                    return delegate.getMetaInstanceMapper().lookupMetaInstance(id);
                }
                catch (RuntimeException delegate) {
                    // empty catch block
                }
            }
            InternalCDOPackageInfo[] internalCDOPackageInfoArray = CDOPackageRegistryImpl.this.getPackageInfos();
            int n = internalCDOPackageInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
                CDOIDMetaRange metaIDRange = packageInfo.getMetaIDRange();
                if (metaIDRange != null && metaIDRange.contains(id)) {
                    EPackage ePackage = packageInfo.getEPackage();
                    this.mapMetaInstances(ePackage, packageInfo.getMetaIDRange());
                    metaInstance = this.idToMetaInstanceMap.get(id);
                    if (metaInstance == null) break;
                    return metaInstance;
                }
                ++n2;
            }
            throw new IllegalStateException(String.valueOf(MessageFormat.format(Messages.getString("CDOPackageRegistryImpl.1"), id)) + "\n" + this.dump());
        }

        @Override
        public synchronized CDOID lookupMetaInstanceID(InternalEObject metaInstance) {
            InternalCDOPackageInfo packageInfo;
            EPackage ePackage;
            LifecycleUtil.checkActive((Object)CDOPackageRegistryImpl.this);
            CDOID metaID = this.metaInstanceToIDMap.get(metaInstance);
            if (metaID != null) {
                return metaID;
            }
            if (CDOPackageRegistryImpl.this.delegateRegistry instanceof InternalCDOPackageRegistry) {
                try {
                    InternalCDOPackageRegistry delegate = (InternalCDOPackageRegistry)CDOPackageRegistryImpl.this.delegateRegistry;
                    return delegate.getMetaInstanceMapper().lookupMetaInstanceID(metaInstance);
                }
                catch (RuntimeException delegate) {
                    // empty catch block
                }
            }
            if ((ePackage = this.getContainingPackage(metaInstance)) != null && (packageInfo = CDOPackageRegistryImpl.this.getPackageInfo(ePackage)) != null) {
                this.mapMetaInstances(ePackage, packageInfo.getMetaIDRange());
                metaID = this.metaInstanceToIDMap.get(metaInstance);
                if (metaID != null) {
                    return metaID;
                }
            }
            throw new IllegalStateException(MessageFormat.format(Messages.getString("CDOPackageRegistryImpl.6"), metaInstance, ePackage));
        }

        private EPackage getContainingPackage(InternalEObject metaInstance) {
            InternalEObject object = metaInstance;
            while ((object = object.eContainer()) != null) {
                if (!(object instanceof EPackage)) continue;
                return (EPackage)object;
            }
            return null;
        }

        @Override
        public synchronized CDOIDMetaRange mapMetaInstances(EPackage ePackage) {
            LifecycleUtil.checkActive((Object)CDOPackageRegistryImpl.this);
            CDOIDMetaRange range = this.map(ePackage, this.lastTempMetaID + 1);
            this.lastTempMetaID = ((CDOIDTempMeta)range.getUpperBound()).getIntValue();
            return range;
        }

        @Override
        public synchronized void mapMetaInstances(EPackage ePackage, CDOIDMetaRange metaIDRange) {
            LifecycleUtil.checkActive((Object)CDOPackageRegistryImpl.this);
            CDOIDMetaRange range = CDOIDUtil.createMetaRange(metaIDRange.getLowerBound(), 0);
            range = this.map((InternalEObject)ePackage, range);
            if (range.size() != metaIDRange.size()) {
                throw new IllegalStateException("range.size() != metaIDRange.size()");
            }
        }

        @Override
        public void mapMetaInstances(InternalCDOPackageRegistry.MetaInstanceMapper source) {
            for (Map.Entry<CDOID, InternalEObject> entry : source.getEntrySet()) {
                this.map(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Set<Map.Entry<CDOID, InternalEObject>> getEntrySet() {
            return this.idToMetaInstanceMap.entrySet();
        }

        @Override
        public synchronized void remapMetaInstanceID(CDOID oldID, CDOID newID) {
            LifecycleUtil.checkActive((Object)CDOPackageRegistryImpl.this);
            InternalEObject metaInstance = this.idToMetaInstanceMap.remove(oldID);
            if (metaInstance == null) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOPackageRegistryImpl.10"), oldID));
            }
            if (METAID_TRACER.isEnabled()) {
                METAID_TRACER.format("Remapping meta instance: {0} --> {1} <-> {2}", new Object[]{oldID, newID, metaInstance});
            }
            this.map(newID, metaInstance);
        }

        public void clear() {
            this.idToMetaInstanceMap.clear();
            this.metaInstanceToIDMap.clear();
            this.lastTempMetaID = 0;
        }

        private String dump() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream stream = new PrintStream(baos);
            stream.println();
            stream.println();
            stream.println(CDOPackageRegistryImpl.this);
            stream.println();
            ArrayList<Map.Entry<CDOID, InternalEObject>> list = new ArrayList<Map.Entry<CDOID, InternalEObject>>(this.idToMetaInstanceMap.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<CDOID, InternalEObject>>(){

                @Override
                public int compare(Map.Entry<CDOID, InternalEObject> o1, Map.Entry<CDOID, InternalEObject> o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
            for (Map.Entry entry : list) {
                stream.println("    " + entry.getKey() + " --> " + entry.getValue());
            }
            return baos.toString();
        }

        private CDOIDMetaRange map(EPackage ePackage, int firstMetaID) {
            CDOIDTemp lowerBound = CDOIDUtil.createTempMeta(firstMetaID);
            CDOIDMetaRange range = CDOIDUtil.createMetaRange(lowerBound, 0);
            return this.map((InternalEObject)ePackage, range);
        }

        private CDOIDMetaRange map(InternalEObject metaInstance, CDOIDMetaRange range) {
            range = range.increase();
            CDOID id = range.getUpperBound();
            this.checkID(id);
            if (METAID_TRACER.isEnabled()) {
                METAID_TRACER.format("Registering meta instance: {0} <-> {1}", new Object[]{id, metaInstance});
            }
            this.idToMetaInstanceMap.put(id, metaInstance);
            CDOID oldID = this.metaInstanceToIDMap.put(metaInstance, id);
            if (oldID != null) {
                this.idToMetaInstanceMap.remove(oldID);
            }
            for (EObject content : metaInstance.eContents()) {
                if (content instanceof EPackage) continue;
                range = this.map((InternalEObject)content, range);
            }
            return range;
        }

        private void map(CDOID metaID, InternalEObject metaInstance) {
            this.checkID(metaID);
            this.idToMetaInstanceMap.put(metaID, metaInstance);
            this.metaInstanceToIDMap.put(metaInstance, metaID);
        }

        private void checkID(CDOID id) {
            if (!id.isMeta()) {
                throw new IllegalArgumentException("Not a meta ID: " + id);
            }
        }
    }
}

