/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.model;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;

public abstract class CDOTypeImpl
implements CDOType {
    private static Map<Integer, CDOTypeImpl> ids = new HashMap<Integer, CDOTypeImpl>();
    private static final byte BOOLEAN_DEFAULT_PRIMITIVE = 0;
    private static final char CHARACTER_DEFAULT_PRIMITIVE = '\u0000';
    private static final short SHORT_DEFAULT_PRIMITIVE = 0;
    public static final Boolean BOOLEAN_DEFAULT = new Boolean(false);
    public static final Byte BYTE_DEFAULT = new Byte(0);
    public static final Character CHARACTER_DEFAULT = new Character('\u0000');
    public static final Double DOUBLE_DEFAULT = new Double(0.0);
    public static final Float FLOAT_DEFAULT = new Float(0.0);
    public static final Integer INTEGER_DEFAULT = new Integer(0);
    public static final Long LONG_DEFAULT = new Long(0L);
    public static final Short SHORT_DEFAULT = new Short(0);
    public static final CDOType BOOLEAN = new CDOTypeImpl("BOOLEAN", 22, false, BOOLEAN_DEFAULT){

        public void writeValue(CDODataOutput out, Object value) throws IOException {
            boolean v = (Boolean)(value == null ? this.getDefaultValue() : value);
            out.writeBoolean(v);
        }

        public Boolean readValue(CDODataInput in) throws IOException {
            return in.readBoolean();
        }
    };
    public static final CDOType BYTE = new CDOTypeImpl("BYTE", 24, false, BYTE_DEFAULT){

        public void writeValue(CDODataOutput out, Object value) throws IOException {
            out.writeByte(((Byte)(value == null ? this.getDefaultValue() : value)).byteValue());
        }

        public Byte readValue(CDODataInput in) throws IOException {
            return in.readByte();
        }
    };
    public static final CDOType CHAR = new CDOTypeImpl("CHAR", 27, false, CHARACTER_DEFAULT){

        public void writeValue(CDODataOutput out, Object value) throws IOException {
            out.writeChar(((Character)(value == null ? this.getDefaultValue() : value)).charValue());
        }

        public Character readValue(CDODataInput in) throws IOException {
            return Character.valueOf(in.readChar());
        }
    };
    public static final CDOType DOUBLE = new CDOTypeImpl("DOUBLE", 31, false, DOUBLE_DEFAULT){

        public void writeValue(CDODataOutput out, Object value) throws IOException {
            out.writeDouble((Double)(value == null ? this.getDefaultValue() : value));
        }

        public Double readValue(CDODataInput in) throws IOException {
            return in.readDouble();
        }
    };
    public static final CDOType FLOAT = new CDOTypeImpl("FLOAT", 37, false, FLOAT_DEFAULT){

        public void writeValue(CDODataOutput out, Object value) throws IOException {
            out.writeFloat(((Float)(value == null ? this.getDefaultValue() : value)).floatValue());
        }

        public Float readValue(CDODataInput in) throws IOException {
            return Float.valueOf(in.readFloat());
        }
    };
    public static final CDOType INT = new CDOTypeImpl("INT", 39, false, INTEGER_DEFAULT){

        public void writeValue(CDODataOutput out, Object value) throws IOException {
            out.writeInt((Integer)(value == null ? this.getDefaultValue() : value));
        }

        public Integer readValue(CDODataInput in) throws IOException {
            return in.readInt();
        }
    };
    public static final CDOType LONG = new CDOTypeImpl("LONG", 43, false, LONG_DEFAULT){

        public void writeValue(CDODataOutput out, Object value) throws IOException {
            out.writeLong((Long)(value == null ? this.getDefaultValue() : value));
        }

        public Long readValue(CDODataInput in) throws IOException {
            return in.readLong();
        }
    };
    public static final CDOType SHORT = new CDOTypeImpl("SHORT", 48, false, SHORT_DEFAULT){

        public void writeValue(CDODataOutput out, Object value) throws IOException {
            out.writeShort(((Short)(value == null ? this.getDefaultValue() : value)).shortValue());
        }

        public Short readValue(CDODataInput in) throws IOException {
            return in.readShort();
        }
    };
    public static final CDOType BIG_DECIMAL = new CDOTypeImpl("BIG_DECIMAL", 20, true){

        public void writeValue(CDODataOutput out, Object value) throws IOException {
            if (value == null) {
                out.writeByteArray(null);
            } else {
                BigDecimal bigDecimal = (BigDecimal)value;
                out.writeByteArray(bigDecimal.unscaledValue().toByteArray());
                out.writeInt(bigDecimal.scale());
            }
        }

        public BigDecimal readValue(CDODataInput in) throws IOException {
            byte[] array = in.readByteArray();
            if (array == null) {
                return null;
            }
            BigInteger unscaled = new BigInteger(array);
            int scale = in.readInt();
            return new BigDecimal(unscaled, scale);
        }
    };
    public static final CDOType BIG_INTEGER = new CDOTypeImpl("BIG_INTEGER", 21, true){

        public void writeValue(CDODataOutput out, Object value) throws IOException {
            if (value == null) {
                out.writeByteArray(null);
            } else {
                out.writeByteArray(((BigInteger)value).toByteArray());
            }
        }

        public BigInteger readValue(CDODataInput in) throws IOException {
            byte[] array = in.readByteArray();
            if (array == null) {
                return null;
            }
            return new BigInteger(array);
        }
    };
    public static final CDOType OBJECT = new CDOTypeImpl("OBJECT", 10, true, CDOID.NULL){

        public void writeValue(CDODataOutput out, Object value) throws IOException {
            if (value instanceof CDORevision) {
                out.writeCDOID(((CDORevision)value).getID());
            } else {
                out.writeCDOID((CDOID)value);
            }
        }

        public CDOID readValue(CDODataInput in) throws IOException {
            return in.readCDOID();
        }

        public Object doAdjustReferences(CDOReferenceAdjuster adjuster, Object value) {
            return adjuster.adjustReference(value);
        }
    };
    public static final CDOType BOOLEAN_OBJECT = new ObjectType("BOOLEAN_OBJECT", 23){

        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeBoolean((Boolean)value);
        }

        protected Boolean doReadValue(CDODataInput in) throws IOException {
            return in.readBoolean();
        }
    };
    public static final CDOType BYTE_OBJECT = new ObjectType("BYTE_OBJECT", 26){

        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeByte(((Byte)value).byteValue());
        }

        protected Byte doReadValue(CDODataInput in) throws IOException {
            return in.readByte();
        }
    };
    public static final CDOType CHARACTER_OBJECT = new ObjectType("CHARACTER_OBJECT", 28){

        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeChar(((Character)value).charValue());
        }

        protected Character doReadValue(CDODataInput in) throws IOException {
            return Character.valueOf(in.readChar());
        }
    };
    public static final CDOType DATE = new ObjectType("DATE", 29){

        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeLong(((Date)value).getTime());
        }

        protected Date doReadValue(CDODataInput in) throws IOException {
            return new Date(in.readLong());
        }
    };
    public static final CDOType DOUBLE_OBJECT = new ObjectType("DOUBLE_OBJECT", 32){

        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeDouble((Double)value);
        }

        protected Double doReadValue(CDODataInput in) throws IOException {
            return in.readDouble();
        }
    };
    public static final CDOType FLOAT_OBJECT = new ObjectType("FLOAT_OBJECT", 38){

        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeFloat(((Float)value).floatValue());
        }

        protected Float doReadValue(CDODataInput in) throws IOException {
            return Float.valueOf(in.readFloat());
        }
    };
    public static final CDOType INTEGER_OBJECT = new ObjectType("INTEGER_OBJECT", 40){

        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeInt((Integer)value);
        }

        protected Integer doReadValue(CDODataInput in) throws IOException {
            return in.readInt();
        }
    };
    public static final CDOType LONG_OBJECT = new ObjectType("LONG_OBJECT", 44){

        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeLong((Long)value);
        }

        protected Long doReadValue(CDODataInput in) throws IOException {
            return in.readLong();
        }
    };
    public static final CDOType SHORT_OBJECT = new ObjectType("SHORT_OBJECT", 49){

        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeShort(((Short)value).shortValue());
        }

        protected Short doReadValue(CDODataInput in) throws IOException {
            return in.readShort();
        }
    };
    public static final CDOType STRING = new CDOTypeImpl("STRING", 50, true){

        protected String doCopyValue(Object value) {
            return (String)value;
        }

        public void writeValue(CDODataOutput out, Object value) throws IOException {
            out.writeString((String)value);
        }

        public String readValue(CDODataInput in) throws IOException {
            return in.readString();
        }
    };
    public static final CDOType BYTE_ARRAY = new CDOTypeImpl("BYTE_ARRAY", 25, true){

        protected byte[] doCopyValue(Object value) {
            byte[] array = (byte[])value;
            byte[] result = new byte[array.length];
            System.arraycopy(value, 0, result, 0, array.length);
            return result;
        }

        public void writeValue(CDODataOutput out, Object value) throws IOException {
            out.writeByteArray((byte[])value);
        }

        public byte[] readValue(CDODataInput in) throws IOException {
            return in.readByteArray();
        }
    };
    public static final CDOType ENUM_ORDINAL = new ObjectType("ENUM_ORDINAL", 998){

        protected Integer doCopyValue(Object value) {
            return (Integer)value;
        }

        public void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeInt((Integer)value);
        }

        public Integer doReadValue(CDODataInput in) throws IOException {
            return in.readInt();
        }

        public Object convertToCDO(EClassifier type, Object value) {
            for (EEnumLiteral literal : ((EEnum)type).getELiterals()) {
                if (literal != value && literal.getInstance() != value) continue;
                return literal.getValue();
            }
            throw new IllegalStateException(MessageFormat.format(Messages.getString("CDOTypeImpl.23"), value));
        }

        public Object convertToEMF(EClassifier type, Object value) {
            return ((EEnum)type).getEEnumLiteral(((Integer)value).intValue()).getInstance();
        }
    };
    public static final CDOType ENUM_LITERAL = new ObjectType("ENUM_LITERAL", 1001){

        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            EEnum eEnum = value instanceof EEnumLiteral ? ((EEnumLiteral)value).getEEnum() : this.findEnum((InternalCDOPackageRegistry)out.getPackageRegistry(), value);
            out.writeCDOClassifierRef((EClassifier)eEnum);
            out.writeInt(((Enumerator)value).getValue());
        }

        protected Object doReadValue(CDODataInput in) throws IOException {
            int ordinal;
            EEnum eEnum = (EEnum)in.readCDOClassifierRefAndResolve();
            EEnumLiteral literal = eEnum.getEEnumLiteral(ordinal = in.readInt());
            if (literal == null) {
                throw new IllegalArgumentException("Enum literal " + ordinal + " not found in " + eEnum);
            }
            return literal.getInstance();
        }

        private EEnum findEnum(InternalCDOPackageRegistry registry, Object value) {
            EPackage ePackage;
            EEnum eEnum;
            Object possiblePackage;
            Set<String> keys = registry.getAllKeys();
            for (String nsURI : keys) {
                possiblePackage = registry.getWithDelegation(nsURI, false);
                if (!(possiblePackage instanceof EPackage) || (eEnum = this.findEnum(ePackage = (EPackage)possiblePackage, value)) == null) continue;
                return eEnum;
            }
            for (String nsURI : keys) {
                possiblePackage = registry.getWithDelegation(nsURI, false);
                if (!(possiblePackage instanceof EPackage.Descriptor) || (eEnum = this.findEnum(ePackage = registry.getEPackage(nsURI), value)) == null) continue;
                return eEnum;
            }
            throw new IllegalArgumentException("EENum instance " + value.getClass().getName() + " not supported");
        }

        private EEnum findEnum(EPackage ePackage, Object value) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EEnum eEnum;
                if (!(eClassifier instanceof EEnum) || (eEnum = (EEnum)eClassifier).getInstanceClass() == null || eEnum.getInstanceClass() != value.getClass()) continue;
                return eEnum;
            }
            return null;
        }
    };
    public static final CDOType CUSTOM = new CDOTypeImpl("CUSTOM", 999, true){

        protected String doCopyValue(Object value) {
            return (String)value;
        }

        public void writeValue(CDODataOutput out, Object value) throws IOException {
            out.writeString((String)value);
        }

        public String readValue(CDODataInput in) throws IOException {
            return in.readString();
        }

        public Object convertToEMF(EClassifier eType, Object value) {
            return EcoreUtil.createFromString((EDataType)((EDataType)eType), (String)((String)value));
        }

        public Object convertToCDO(EClassifier eType, Object value) {
            return EcoreUtil.convertToString((EDataType)((EDataType)eType), (Object)value);
        }
    };
    public static final CDOType FEATURE_MAP_ENTRY = new CDOTypeImpl("FEATURE_MAP_ENTRY", 36, false){

        protected FeatureMap.Entry doCopyValue(Object value) {
            FeatureMap.Entry entry = (FeatureMap.Entry)value;
            EStructuralFeature innerFeature = entry.getEStructuralFeature();
            Object innerValue = entry.getValue();
            CDOType innerType = CDOModelUtil.getType(innerFeature.getEType());
            Object innerCopy = innerType.copyValue(innerValue);
            return CDORevisionUtil.createFeatureMapEntry(innerFeature, innerCopy);
        }

        public void writeValue(CDODataOutput out, Object value) throws IOException {
            throw new UnsupportedOperationException();
        }

        public FeatureMap.Entry readValue(CDODataInput in) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Object doAdjustReferences(CDOReferenceAdjuster adjuster, Object value) {
            FeatureMap.Entry entry = (FeatureMap.Entry)value;
            EStructuralFeature innerFeature = entry.getEStructuralFeature();
            Object innerValue = entry.getValue();
            CDOType innerType = CDOModelUtil.getType(innerFeature.getEType());
            Object innerCopy = innerType.adjustReferences(adjuster, innerValue);
            if (innerCopy != innerValue) {
                value = CDORevisionUtil.createFeatureMapEntry(innerFeature, innerCopy);
            }
            return value;
        }
    };
    public static final CDOType OBJECT_ARRAY = new ObjectType("OBJECT_ARRAY", 1000){

        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            Object[] objects = (Object[])value;
            out.writeInt(objects.length);
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                CDOType cdoType;
                Object object = objectArray[n2];
                if (object instanceof BigDecimal) {
                    cdoType = CDOType.BIG_DECIMAL;
                } else if (object instanceof BigInteger) {
                    cdoType = CDOType.BIG_INTEGER;
                } else if (object instanceof Boolean) {
                    cdoType = CDOType.BOOLEAN_OBJECT;
                } else if (object instanceof Byte) {
                    cdoType = CDOType.BYTE_OBJECT;
                } else if (object instanceof byte[]) {
                    cdoType = CDOType.BYTE_ARRAY;
                } else if (object instanceof Character) {
                    cdoType = CDOType.CHARACTER_OBJECT;
                } else if (object instanceof Date) {
                    cdoType = CDOType.DATE;
                } else if (object instanceof Double) {
                    cdoType = CDOType.DOUBLE_OBJECT;
                } else if (object instanceof EEnumLiteral) {
                    cdoType = CDOType.ENUM_LITERAL;
                } else if (object instanceof FeatureMap.Entry) {
                    cdoType = CDOType.FEATURE_MAP_ENTRY;
                } else if (object instanceof Float) {
                    cdoType = CDOType.FLOAT_OBJECT;
                } else if (object instanceof Integer) {
                    cdoType = CDOType.INTEGER_OBJECT;
                } else if (object instanceof Long) {
                    cdoType = CDOType.LONG_OBJECT;
                } else if (object instanceof Short) {
                    cdoType = CDOType.SHORT_OBJECT;
                } else if (object instanceof String) {
                    cdoType = CDOType.STRING;
                } else if (object instanceof CDOID || object instanceof CDORevision) {
                    cdoType = CDOType.OBJECT;
                } else if (object == null) {
                    cdoType = CDOType.OBJECT;
                } else {
                    throw new IllegalArgumentException("Object type " + object.getClass().getName() + " is not supported.");
                }
                out.writeInt(cdoType.getTypeID());
                cdoType.writeValue(out, object);
                ++n2;
            }
        }

        protected Object[] doReadValue(CDODataInput in) throws IOException {
            int size = in.readInt();
            Object[] objects = new Object[size];
            int i = 0;
            while (i < size) {
                int typeID = in.readInt();
                CDOType cdoType = CDOModelUtil.getType(typeID);
                objects[i] = cdoType.readValue(in);
                ++i;
            }
            return objects;
        }

        public Object doAdjustReferences(CDOReferenceAdjuster adjuster, Object value) {
            Object[] objects = (Object[])value;
            int i = 0;
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                objects[i++] = object instanceof CDOID ? adjuster.adjustReference(object) : object;
                ++n2;
            }
            return objects;
        }
    };
    private String name;
    private int typeID;
    private boolean canBeNull;
    private Object defaultValue;

    private CDOTypeImpl(String name, int typeID, boolean canBeNull, Object defaultValue) {
        this.name = name;
        this.typeID = typeID;
        this.canBeNull = canBeNull;
        this.defaultValue = defaultValue;
        ids.put(typeID, this);
    }

    private CDOTypeImpl(String name, int typeID, boolean canBeNull) {
        this(name, typeID, canBeNull, (Object)null);
    }

    public String getName() {
        return this.name;
    }

    public int getTypeID() {
        return this.typeID;
    }

    public boolean canBeNull() {
        return this.canBeNull;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return this.name;
    }

    public final Object copyValue(Object value) {
        if (value == null || value == CDORevisionData.NIL) {
            return value;
        }
        return this.doCopyValue(value);
    }

    protected Object doCopyValue(Object value) {
        return value;
    }

    public void write(CDODataOutput out) throws IOException {
        out.writeInt(this.typeID);
    }

    public final Object adjustReferences(CDOReferenceAdjuster adjuster, Object value) {
        return value == null ? null : this.doAdjustReferences(adjuster, value);
    }

    protected Object doAdjustReferences(CDOReferenceAdjuster adjuster, Object value) {
        return value;
    }

    public Object convertToEMF(EClassifier feature, Object value) {
        return value;
    }

    public Object convertToCDO(EClassifier feature, Object value) {
        return value;
    }

    public static CDOType getType(int typeID) {
        CDOTypeImpl type = ids.get(typeID);
        if (type == null) {
            throw new IllegalStateException(MessageFormat.format(Messages.getString("CDOModelUtil.6"), typeID));
        }
        return type;
    }

    /* synthetic */ CDOTypeImpl(String string, int n, boolean bl, Object object, CDOTypeImpl cDOTypeImpl) {
        this(string, n, bl, object);
    }

    /* synthetic */ CDOTypeImpl(String string, int n, boolean bl, CDOTypeImpl cDOTypeImpl) {
        this(string, n, bl);
    }

    private static abstract class ObjectType
    extends CDOTypeImpl {
        public ObjectType(String name, int typeID) {
            super(name, typeID, true, null);
        }

        public final void writeValue(CDODataOutput out, Object value) throws IOException {
            if (value == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.doWriteValue(out, value);
            }
        }

        protected abstract void doWriteValue(CDODataOutput var1, Object var2) throws IOException;

        public final Object readValue(CDODataInput in) throws IOException {
            boolean notNull = in.readBoolean();
            if (notNull) {
                return this.doReadValue(in);
            }
            return null;
        }

        protected abstract Object doReadValue(CDODataInput var1) throws IOException;
    }
}

