/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.protocol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndBranch;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.commit.CDOChangeSetDataImpl;
import org.eclipse.emf.cdo.internal.common.commit.CDOCommitDataImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDAndBranchImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDAndVersionImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDExternalImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDMetaImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDMetaRangeImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDObjectLongImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDTempMetaImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDTempObjectExternalImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDTempObjectImpl;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOAddFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOClearFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOContainerFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOListFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOMoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORemoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOSetFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOUnsetFeatureDeltaImpl;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOID;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.StringIO;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class CDODataInputImpl
extends ExtendedDataInput.Delegating
implements CDODataInput {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, CDODataInputImpl.class);
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$emf$cdo$common$id$CDOID$Type;

    public CDODataInputImpl(ExtendedDataInput delegate) {
        super(delegate);
    }

    public CDOPackageUnit readCDOPackageUnit(ResourceSet resourceSet) throws IOException {
        InternalCDOPackageUnit packageUnit = (InternalCDOPackageUnit)CDOModelUtil.createPackageUnit();
        packageUnit.read(this, resourceSet);
        return packageUnit;
    }

    public CDOPackageUnit[] readCDOPackageUnits(ResourceSet resourceSet) throws IOException {
        int size = this.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading {0} package units", new Object[]{size});
        }
        CDOPackageUnit[] packageUnits = new CDOPackageUnit[size];
        int i = 0;
        while (i < size) {
            packageUnits[i] = this.readCDOPackageUnit(resourceSet);
            ++i;
        }
        return packageUnits;
    }

    public CDOPackageUnit.Type readCDOPackageUnitType() throws IOException {
        return CDOPackageUnit.Type.values()[this.readByte()];
    }

    public CDOPackageInfo readCDOPackageInfo() throws IOException {
        InternalCDOPackageInfo packageInfo = (InternalCDOPackageInfo)CDOModelUtil.createPackageInfo();
        packageInfo.read(this);
        return packageInfo;
    }

    public String readCDOPackageURI() throws IOException {
        return this.getPackageURICompressor().read((ExtendedDataInput)this);
    }

    public CDOClassifierRef readCDOClassifierRef() throws IOException {
        return new CDOClassifierRef(this);
    }

    public EClassifier readCDOClassifierRefAndResolve() throws IOException {
        CDOClassifierRef classifierRef = this.readCDOClassifierRef();
        EClassifier classifier = classifierRef.resolve(this.getPackageRegistry());
        if (classifier == null) {
            throw new IOException("Unable to resolve " + classifierRef);
        }
        return classifier;
    }

    public CDOType readCDOType() throws IOException {
        int typeID = this.readInt();
        return CDOModelUtil.getType(typeID);
    }

    public CDOBranch readCDOBranch() throws IOException {
        int branchID = this.readInt();
        return this.getBranchManager().getBranch(branchID);
    }

    public CDOBranchPoint readCDOBranchPoint() throws IOException {
        CDOBranch branch = this.readCDOBranch();
        long timeStamp = this.readLong();
        return branch.getPoint(timeStamp);
    }

    public CDOBranchVersion readCDOBranchVersion() throws IOException {
        CDOBranch branch = this.readCDOBranch();
        int version = this.readInt();
        return branch.getVersion(version);
    }

    public CDOChangeSetData readCDOChangeSetData() throws IOException {
        int size1 = this.readInt();
        ArrayList<CDOIDAndVersion> newObjects = new ArrayList<CDOIDAndVersion>(size1);
        int i = 0;
        while (i < size1) {
            boolean revision = this.readBoolean();
            CDOIDAndVersion data = revision ? this.readCDORevision() : this.readCDOIDAndVersion();
            newObjects.add(data);
            ++i;
        }
        int size2 = this.readInt();
        ArrayList<CDORevisionKey> changedObjects = new ArrayList<CDORevisionKey>(size2);
        int i2 = 0;
        while (i2 < size2) {
            boolean delta = this.readBoolean();
            CDORevisionKey data = delta ? this.readCDORevisionDelta() : this.readCDORevisionKey();
            changedObjects.add(data);
            ++i2;
        }
        int size3 = this.readInt();
        ArrayList<CDOIDAndVersion> detachedObjects = new ArrayList<CDOIDAndVersion>(size3);
        int i3 = 0;
        while (i3 < size3) {
            CDOIDAndVersion data = this.readCDOIDAndVersion();
            detachedObjects.add(data);
            ++i3;
        }
        return new CDOChangeSetDataImpl(newObjects, changedObjects, detachedObjects);
    }

    public CDOCommitData readCDOCommitData() throws IOException {
        InternalCDOPackageRegistry packageRegistry = (InternalCDOPackageRegistry)this.getPackageRegistry();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setPackageRegistry((EPackage.Registry)packageRegistry);
        int size = this.readInt();
        ArrayList<CDOPackageUnit> newPackageUnits = new ArrayList<CDOPackageUnit>(size);
        int i = 0;
        while (i < size) {
            CDOPackageUnit data = this.readCDOPackageUnit((ResourceSet)resourceSet);
            newPackageUnits.add(data);
            packageRegistry.putPackageUnit((InternalCDOPackageUnit)data);
            ++i;
        }
        CDOChangeSetData data = this.readCDOChangeSetData();
        return new CDOCommitDataImpl(newPackageUnits, data.getNewObjects(), data.getChangedObjects(), data.getDetachedObjects());
    }

    public CDOCommitInfo readCDOCommitInfo() throws IOException {
        CDOBranch branch = this.readCDOBranch();
        long timeStamp = this.readLong();
        String userID = this.readString();
        String comment = this.readString();
        CDOCommitData commitData = this.readCDOCommitData();
        InternalCDOCommitInfoManager commitInfoManager = (InternalCDOCommitInfoManager)this.getCommitInfoManager();
        return commitInfoManager.createCommitInfo(branch, timeStamp, userID, comment, commitData);
    }

    public CDOID readCDOID() throws IOException {
        Object type;
        byte ordinal = this.readByte();
        if (ordinal < 0) {
            return this.readCDOIDObject(-ordinal - 1);
        }
        if (TRACER.isEnabled()) {
            try {
                type = CDOID.Type.values()[ordinal].toString();
            }
            catch (RuntimeException ex) {
                type = ex.getMessage();
            }
            TRACER.format("Reading CDOID of type {0} ({1})", new Object[]{ordinal, type});
        }
        type = CDOID.Type.values()[ordinal];
        switch (CDODataInputImpl.$SWITCH_TABLE$org$eclipse$emf$cdo$common$id$CDOID$Type()[((Enum)type).ordinal()]) {
            case 1: {
                return CDOID.NULL;
            }
            case 6: {
                return new CDOIDTempObjectImpl(this.readInt());
            }
            case 8: {
                return new CDOIDTempMetaImpl(this.readInt());
            }
            case 7: {
                return new CDOIDMetaImpl(this.readLong());
            }
            case 3: {
                return new CDOIDExternalImpl(this.readString());
            }
            case 5: {
                return new CDOIDTempObjectExternalImpl(this.readString());
            }
            case 2: {
                CDOIDObjectLongImpl id = new CDOIDObjectLongImpl();
                ((AbstractCDOID)id).read(this);
                return id;
            }
        }
        throw new IOException("Illegal type: " + type);
    }

    private CDOID readCDOIDObject(int subTypeOrdinal) throws IOException {
        Object subType;
        if (TRACER.isEnabled()) {
            try {
                subType = CDOID.ObjectType.values()[subTypeOrdinal].toString();
            }
            catch (RuntimeException ex) {
                subType = ex.getMessage();
            }
            TRACER.format("Reading CDOIDObject of sub type {0} ({1})", new Object[]{subTypeOrdinal, subType});
        }
        subType = CDOID.ObjectType.values()[subTypeOrdinal];
        AbstractCDOID id = CDOIDUtil.createCDOIDObject(subType);
        id.read(this);
        return id;
    }

    public CDOIDAndVersion readCDOIDAndVersion() throws IOException {
        CDOID id = this.readCDOID();
        int version = this.readInt();
        return new CDOIDAndVersionImpl(id, version);
    }

    public CDOIDAndBranch readCDOIDAndBranch() throws IOException {
        CDOID id = this.readCDOID();
        CDOBranch branch = this.readCDOBranch();
        return new CDOIDAndBranchImpl(id, branch);
    }

    public CDOIDMetaRange readCDOIDMetaRange() throws IOException {
        boolean exist = this.readBoolean();
        if (exist) {
            return new CDOIDMetaRangeImpl(this.readCDOID(), this.readInt());
        }
        return null;
    }

    public CDORevisionKey readCDORevisionKey() throws IOException {
        CDOID id = this.readCDOID();
        CDOBranch branch = this.readCDOBranch();
        int version = this.readInt();
        return CDORevisionUtil.createRevisionKey(id, branch, version);
    }

    public CDORevision readCDORevision() throws IOException {
        boolean notNull = this.readBoolean();
        if (notNull) {
            InternalCDORevision revision = (InternalCDORevision)this.getRevisionFactory().createRevision(null);
            revision.read(this);
            return revision;
        }
        return null;
    }

    public CDOList readCDOList(EClass owner, EStructuralFeature feature) throws IOException {
        int referenceChunk;
        int size = this.readInt();
        if (size < 0) {
            size = -size;
            referenceChunk = this.readInt();
            if (TRACER.isEnabled()) {
                TRACER.format("Read feature {0}: size={1}, referenceChunk={2}", new Object[]{feature.getName(), size, referenceChunk});
            }
        } else {
            referenceChunk = size;
            if (TRACER.isEnabled()) {
                TRACER.format("Read feature {0}: size={1}", new Object[]{feature.getName(), size});
            }
        }
        Object value = null;
        CDOType type = null;
        boolean isFeatureMap = FeatureMapUtil.isFeatureMap((EStructuralFeature)feature);
        if (!isFeatureMap) {
            type = CDOModelUtil.getType(feature.getEType());
        }
        InternalCDOList list = (InternalCDOList)this.getListFactory().createList(size, size, referenceChunk);
        int j = 0;
        while (j < referenceChunk) {
            if (isFeatureMap) {
                int featureID = this.readInt();
                EStructuralFeature innerFeature = owner.getEStructuralFeature(featureID);
                type = CDOModelUtil.getType(innerFeature.getEType());
                value = type.readValue(this);
                value = CDORevisionUtil.createFeatureMapEntry(innerFeature, value);
            } else {
                value = type.readValue(this);
            }
            list.set(j, value);
            if (TRACER.isEnabled()) {
                TRACER.trace("    " + value);
            }
            ++j;
        }
        return list;
    }

    public Object readCDOFeatureValue(EStructuralFeature feature) throws IOException {
        CDOType type = CDOModelUtil.getType(feature);
        return type.readValue(this);
    }

    public CDORevisionDelta readCDORevisionDelta() throws IOException {
        return new CDORevisionDeltaImpl(this);
    }

    public CDOFeatureDelta readCDOFeatureDelta(EClass owner) throws IOException {
        int typeOrdinal = this.readInt();
        CDOFeatureDelta.Type type = CDOFeatureDelta.Type.values()[typeOrdinal];
        switch (type) {
            case ADD: {
                return new CDOAddFeatureDeltaImpl(this, owner);
            }
            case SET: {
                return new CDOSetFeatureDeltaImpl(this, owner);
            }
            case LIST: {
                return new CDOListFeatureDeltaImpl(this, owner);
            }
            case MOVE: {
                return new CDOMoveFeatureDeltaImpl(this, owner);
            }
            case CLEAR: {
                return new CDOClearFeatureDeltaImpl(this, owner);
            }
            case REMOVE: {
                return new CDORemoveFeatureDeltaImpl(this, owner);
            }
            case CONTAINER: {
                return new CDOContainerFeatureDeltaImpl(this, owner);
            }
            case UNSET: {
                return new CDOUnsetFeatureDeltaImpl(this, owner);
            }
        }
        throw new IOException(MessageFormat.format(Messages.getString("CDODataInputImpl.5"), typeOrdinal));
    }

    public Object readCDORevisionOrPrimitive() throws IOException {
        CDOType type = this.readCDOType();
        return type.readValue(this);
    }

    public Object readCDORevisionOrPrimitiveOrClassifier() throws IOException {
        boolean isClassifier = this.readBoolean();
        if (isClassifier) {
            return this.readCDOClassifierRefAndResolve();
        }
        return this.readCDORevisionOrPrimitive();
    }

    public IRWLockManager.LockType readCDOLockType() throws IOException {
        return this.readBoolean() ? IRWLockManager.LockType.WRITE : IRWLockManager.LockType.READ;
    }

    protected StringIO getPackageURICompressor() {
        return StringIO.DIRECT;
    }

    protected abstract CDOPackageRegistry getPackageRegistry();

    protected abstract CDOBranchManager getBranchManager();

    protected abstract CDOCommitInfoManager getCommitInfoManager();

    protected abstract CDORevisionFactory getRevisionFactory();

    protected abstract CDOListFactory getListFactory();

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$emf$cdo$common$id$CDOID$Type() {
        if ($SWITCH_TABLE$org$eclipse$emf$cdo$common$id$CDOID$Type != null) {
            return $SWITCH_TABLE$org$eclipse$emf$cdo$common$id$CDOID$Type;
        }
        int[] nArray = new int[CDOID.Type.values().length];
        try {
            nArray[CDOID.Type.DANGLING_OBJECT.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CDOID.Type.EXTERNAL_OBJECT.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CDOID.Type.EXTERNAL_TEMP_OBJECT.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CDOID.Type.META.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CDOID.Type.NULL.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CDOID.Type.OBJECT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CDOID.Type.TEMP_META.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CDOID.Type.TEMP_OBJECT.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$emf$cdo$common$id$CDOID$Type = nArray;
        return nArray;
    }
}

