/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.protocol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndBranch;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.internal.common.model.CDOTypeImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionDeltaImpl;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOID;
import org.eclipse.emf.cdo.spi.common.id.InternalCDOIDObject;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.StringIO;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class CDODataOutputImpl
extends ExtendedDataOutput.Delegating
implements CDODataOutput {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, CDODataOutputImpl.class);

    public CDODataOutputImpl(ExtendedDataOutput delegate) {
        super(delegate);
    }

    public void writeCDOPackageUnit(CDOPackageUnit packageUnit, boolean withPackages) throws IOException {
        ((InternalCDOPackageUnit)packageUnit).write(this, withPackages);
    }

    public void writeCDOPackageUnits(CDOPackageUnit ... packageUnits) throws IOException {
        int size = packageUnits.length;
        this.writeInt(size);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} package units", new Object[]{size});
        }
        CDOPackageUnit[] cDOPackageUnitArray = packageUnits;
        int n = packageUnits.length;
        int n2 = 0;
        while (n2 < n) {
            CDOPackageUnit packageUnit = cDOPackageUnitArray[n2];
            this.writeCDOPackageUnit(packageUnit, false);
            ++n2;
        }
    }

    public void writeCDOPackageUnitType(CDOPackageUnit.Type type) throws IOException {
        this.writeByte(type.ordinal());
    }

    public void writeCDOPackageInfo(CDOPackageInfo packageInfo) throws IOException {
        ((InternalCDOPackageInfo)packageInfo).write(this);
    }

    public void writeCDOClassifierRef(CDOClassifierRef eClassifierRef) throws IOException {
        eClassifierRef.write(this);
    }

    public void writeCDOClassifierRef(EClassifier eClassifier) throws IOException {
        this.writeCDOClassifierRef(new CDOClassifierRef(eClassifier));
    }

    public void writeCDOPackageURI(String uri) throws IOException {
        this.getPackageURICompressor().write((ExtendedDataOutput)this, uri);
    }

    public void writeCDOType(CDOType cdoType) throws IOException {
        ((CDOTypeImpl)cdoType).write(this);
    }

    public void writeCDOBranch(CDOBranch branch) throws IOException {
        this.writeInt(branch.getID());
    }

    public void writeCDOBranchPoint(CDOBranchPoint branchPoint) throws IOException {
        this.writeCDOBranch(branchPoint.getBranch());
        this.writeLong(branchPoint.getTimeStamp());
    }

    public void writeCDOBranchVersion(CDOBranchVersion branchVersion) throws IOException {
        this.writeCDOBranch(branchVersion.getBranch());
        this.writeInt(branchVersion.getVersion());
    }

    public void writeCDOChangeSetData(CDOChangeSetData changeSetData) throws IOException {
        List<CDOIDAndVersion> newObjects = changeSetData.getNewObjects();
        this.writeInt(newObjects.size());
        for (CDOIDAndVersion data : newObjects) {
            if (data instanceof CDORevision) {
                this.writeBoolean(true);
                this.writeCDORevision((CDORevision)data, -1);
                continue;
            }
            this.writeBoolean(false);
            this.writeCDOIDAndVersion(data);
        }
        List<CDORevisionKey> changedObjects = changeSetData.getChangedObjects();
        this.writeInt(changedObjects.size());
        for (CDORevisionKey data : changedObjects) {
            if (data instanceof CDORevisionDelta) {
                this.writeBoolean(true);
                this.writeCDORevisionDelta((CDORevisionDelta)data);
                continue;
            }
            this.writeBoolean(false);
            this.writeCDORevisionKey(data);
        }
        List<CDOIDAndVersion> detachedObjects = changeSetData.getDetachedObjects();
        this.writeInt(detachedObjects.size());
        for (CDOIDAndVersion data : detachedObjects) {
            this.writeCDOIDAndVersion(data);
        }
    }

    public void writeCDOCommitData(CDOCommitData commitData) throws IOException {
        List<CDOPackageUnit> newPackageUnits = commitData.getNewPackageUnits();
        this.writeInt(newPackageUnits.size());
        for (CDOPackageUnit data : newPackageUnits) {
            this.writeCDOPackageUnit(data, false);
        }
        this.writeCDOChangeSetData(commitData);
    }

    public void writeCDOCommitInfo(CDOCommitInfo commitInfo) throws IOException {
        this.writeCDOBranch(commitInfo.getBranch());
        this.writeLong(commitInfo.getTimeStamp());
        this.writeString(commitInfo.getUserID());
        this.writeString(commitInfo.getComment());
        this.writeCDOCommitData(commitInfo);
    }

    public void writeCDOID(CDOID id) throws IOException {
        if (id == null) {
            id = CDOID.NULL;
        }
        if (id instanceof InternalCDOIDObject) {
            CDOID.ObjectType subType = ((InternalCDOIDObject)id).getSubType();
            int ordinal = subType.ordinal();
            if (TRACER.isEnabled()) {
                TRACER.format("Writing CDOIDObject of subtype {0} ({1})", new Object[]{ordinal, subType});
            }
            this.writeByte(-ordinal - 1);
        } else {
            CDOID.Type type = id.getType();
            int ordinal = type.ordinal();
            if (TRACER.isEnabled()) {
                TRACER.format("Writing CDOID of type {0} ({1})", new Object[]{ordinal, type});
            }
            this.writeByte(ordinal);
        }
        ((AbstractCDOID)id).write(this);
    }

    public void writeCDOIDAndVersion(CDOIDAndVersion idAndVersion) throws IOException {
        this.writeCDOID(idAndVersion.getID());
        this.writeInt(idAndVersion.getVersion());
    }

    public void writeCDOIDAndBranch(CDOIDAndBranch idAndBranch) throws IOException {
        this.writeCDOID(idAndBranch.getID());
        this.writeCDOBranch(idAndBranch.getBranch());
    }

    public void writeCDOIDMetaRange(CDOIDMetaRange metaRange) throws IOException {
        if (metaRange == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeCDOID(metaRange.getLowerBound());
            this.writeInt(metaRange.size());
        }
    }

    public CDOPackageRegistry getPackageRegistry() {
        return null;
    }

    public CDOIDProvider getIDProvider() {
        return null;
    }

    public void writeCDORevisionKey(CDORevisionKey revisionKey) throws IOException {
        this.writeCDOID(revisionKey.getID());
        this.writeCDOBranch(revisionKey.getBranch());
        this.writeInt(revisionKey.getVersion());
    }

    public void writeCDORevision(CDORevision revision, int referenceChunk) throws IOException {
        if (revision != null) {
            this.writeBoolean(true);
            ((InternalCDORevision)revision).write(this, referenceChunk);
        } else {
            this.writeBoolean(false);
        }
    }

    public void writeCDOList(EClass owner, EStructuralFeature feature, CDOList list, int referenceChunk) throws IOException {
        int size;
        int n = size = list == null ? 0 : list.size();
        if (size > 0) {
            int sizeToLook = referenceChunk == -1 ? size : Math.min(referenceChunk, size);
            int i = 0;
            while (i < sizeToLook) {
                Object element = list.get(i, false);
                if (element == CDORevisionUtil.UNINITIALIZED) {
                    referenceChunk = i;
                    break;
                }
                ++i;
            }
        }
        if (referenceChunk != -1 && referenceChunk < size) {
            if (TRACER.isEnabled()) {
                TRACER.format("Writing feature {0}: size={1}, referenceChunk={2}", new Object[]{feature.getName(), size, referenceChunk});
            }
            this.writeInt(-size);
            this.writeInt(referenceChunk);
            size = referenceChunk;
        } else {
            if (TRACER.isEnabled()) {
                TRACER.format("Writing feature {0}: size={1}", new Object[]{feature.getName(), size});
            }
            this.writeInt(size);
        }
        CDOIDProvider idProvider = this.getIDProvider();
        boolean isFeatureMap = FeatureMapUtil.isFeatureMap((EStructuralFeature)feature);
        int j = 0;
        while (j < size) {
            Object value = list.get(j, false);
            EStructuralFeature innerFeature = feature;
            if (isFeatureMap) {
                FeatureMap.Entry entry = (FeatureMap.Entry)value;
                innerFeature = entry.getEStructuralFeature();
                value = entry.getValue();
                int featureID = owner.getFeatureID(innerFeature);
                this.writeInt(featureID);
            }
            if (value != null && innerFeature instanceof EReference) {
                value = idProvider.provideCDOID(value);
            }
            if (TRACER.isEnabled()) {
                TRACER.trace("    " + value);
            }
            this.writeCDOFeatureValue(innerFeature, value);
            ++j;
        }
    }

    public void writeCDOFeatureValue(EStructuralFeature feature, Object value) throws IOException {
        CDOType type = CDOModelUtil.getType(feature);
        type.writeValue(this, value);
    }

    public void writeCDORevisionDelta(CDORevisionDelta revisionDelta) throws IOException {
        ((CDORevisionDeltaImpl)revisionDelta).write(this);
    }

    public void writeCDOFeatureDelta(EClass owner, CDOFeatureDelta featureDelta) throws IOException {
        ((CDOFeatureDeltaImpl)featureDelta).write(this, owner);
    }

    public void writeCDORevisionOrPrimitive(Object value) throws IOException {
        if (value == null) {
            value = CDOID.NULL;
        } else if (value instanceof CDORevision) {
            value = ((CDORevision)value).getID();
        }
        CDOType type = null;
        if (value instanceof CDOID) {
            CDOID id = (CDOID)value;
            if (id.isTemporary()) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDODataOutputImpl.5"), value));
            }
            type = CDOType.OBJECT;
        } else {
            type = CDOModelUtil.getPrimitiveType(value.getClass());
            if (type == null) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDODataOutputImpl.6"), value.getClass()));
            }
        }
        this.writeCDOType(type);
        type.writeValue(this, value);
    }

    public void writeCDORevisionOrPrimitiveOrClassifier(Object value) throws IOException {
        if (value instanceof EClassifier) {
            this.writeBoolean(true);
            this.writeCDOClassifierRef((EClassifier)((EClass)value));
        } else {
            this.writeBoolean(false);
            this.writeCDORevisionOrPrimitive(value);
        }
    }

    public void writeCDOLockType(IRWLockManager.LockType lockType) throws IOException {
        this.writeBoolean(lockType == IRWLockManager.LockType.WRITE);
    }

    protected StringIO getPackageURICompressor() {
        return StringIO.DIRECT;
    }
}

