/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision;

import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.spi.common.revision.BaseCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CDORevisionImpl
extends BaseCDORevision {
    private Object[] values;

    public CDORevisionImpl(EClass eClass) {
        super(eClass);
    }

    protected CDORevisionImpl(CDORevisionImpl source) {
        super(source);
        EStructuralFeature[] features = CDOModelUtil.getAllPersistentFeatures(this.getEClass());
        this.initValues(features);
        int i = 0;
        while (i < features.length) {
            EStructuralFeature feature = features[i];
            EClassifier classifier = feature.getEType();
            if (feature.isMany()) {
                InternalCDOList sourceList = (InternalCDOList)source.values[i];
                if (sourceList != null) {
                    this.setValue(i, (Object)sourceList.clone(classifier));
                }
            } else {
                CDOType type = CDOModelUtil.getType(feature);
                this.setValue(i, type.copyValue(source.values[i]));
            }
            ++i;
        }
    }

    public InternalCDORevision copy() {
        return new CDORevisionImpl(this);
    }

    protected void initValues(EStructuralFeature[] allPersistentFeatures) {
        this.values = new Object[allPersistentFeatures.length];
    }

    protected Object getValue(int featureIndex) {
        return this.values[featureIndex];
    }

    protected void setValue(int featureIndex, Object value) {
        this.values[featureIndex] = value;
    }
}

