/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.cache.branch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.cache.CDORevisionCacheFactory;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchDispatcher
extends Lifecycle
implements InternalCDORevisionCache {
    private Map<CDOBranch, InternalCDORevisionCache> caches = new HashMap<CDOBranch, InternalCDORevisionCache>();
    private CDORevisionCacheFactory factory;

    @Override
    public InternalCDORevisionCache instantiate(CDORevision revision) {
        BranchDispatcher cache = new BranchDispatcher();
        cache.setFactory(this.factory);
        return cache;
    }

    @Override
    public boolean isSupportingBranches() {
        return true;
    }

    public CDORevisionCacheFactory getFactory() {
        return this.factory;
    }

    public void setFactory(CDORevisionCacheFactory factory) {
        this.checkInactive();
        this.factory = factory;
    }

    @Override
    public EClass getObjectType(CDOID id) {
        InternalCDORevisionCache[] internalCDORevisionCacheArray = this.getCaches();
        int n = internalCDORevisionCacheArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevisionCache cache = internalCDORevisionCacheArray[n2];
            EClass type = cache.getObjectType(id);
            if (type != null) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public CDORevision getRevision(CDOID id, CDOBranchPoint branchPoint) {
        InternalCDORevisionCache cache = this.getCache(branchPoint.getBranch());
        if (cache == null) {
            return null;
        }
        return cache.getRevision(id, branchPoint);
    }

    @Override
    public CDORevision getRevisionByVersion(CDOID id, CDOBranchVersion branchVersion) {
        InternalCDORevisionCache cache = this.getCache(branchVersion.getBranch());
        if (cache == null) {
            return null;
        }
        return cache.getRevisionByVersion(id, branchVersion);
    }

    @Override
    public CDORevision removeRevision(CDOID id, CDOBranchVersion branchVersion) {
        InternalCDORevisionCache cache = this.getCache(branchVersion.getBranch());
        if (cache == null) {
            return null;
        }
        return cache.removeRevision(id, branchVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRevision(CDORevision revision) {
        InternalCDORevisionCache cache;
        CDOBranch branch = revision.getBranch();
        Map<CDOBranch, InternalCDORevisionCache> map = this.caches;
        synchronized (map) {
            cache = this.caches.get(branch);
            if (cache == null) {
                cache = (InternalCDORevisionCache)this.factory.createRevisionCache(revision);
                LifecycleUtil.activate((Object)cache);
                this.caches.put(branch, cache);
            }
        }
        return cache.addRevision(revision);
    }

    @Override
    public List<CDORevision> getCurrentRevisions() {
        ArrayList<CDORevision> result = new ArrayList<CDORevision>();
        InternalCDORevisionCache[] internalCDORevisionCacheArray = this.getCaches();
        int n = internalCDORevisionCacheArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevisionCache cache = internalCDORevisionCacheArray[n2];
            result.addAll(cache.getCurrentRevisions());
            ++n2;
        }
        return result;
    }

    @Override
    public void clear() {
        InternalCDORevisionCache[] internalCDORevisionCacheArray = this.getCaches();
        int n = internalCDORevisionCacheArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevisionCache cache = internalCDORevisionCacheArray[n2];
            cache.clear();
            ++n2;
        }
    }

    @Override
    public Map<CDOBranch, List<CDORevision>> getAllRevisions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<CDORevision> getRevisions(CDOBranchPoint branchPoint) {
        throw new UnsupportedOperationException();
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.factory, "factory");
    }

    protected void doDeactivate() throws Exception {
        InternalCDORevisionCache[] internalCDORevisionCacheArray = this.getCaches();
        int n = internalCDORevisionCacheArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevisionCache cache = internalCDORevisionCacheArray[n2];
            LifecycleUtil.deactivate((Object)cache);
            ++n2;
        }
        super.doDeactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalCDORevisionCache getCache(CDOBranch branch) {
        Map<CDOBranch, InternalCDORevisionCache> map = this.caches;
        synchronized (map) {
            return this.caches.get(branch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalCDORevisionCache[] getCaches() {
        Map<CDOBranch, InternalCDORevisionCache> map = this.caches;
        synchronized (map) {
            return this.caches.values().toArray(new InternalCDORevisionCache[this.caches.size()]);
        }
    }
}

