/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.cache.branch;

import java.lang.ref.Reference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndBranch;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.revision.cache.EvictionEventImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.ref.KeyedReference;
import org.eclipse.net4j.util.ref.KeyedSoftReference;
import org.eclipse.net4j.util.ref.KeyedStrongReference;
import org.eclipse.net4j.util.ref.ReferenceQueueWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchRevisionCache
extends ReferenceQueueWorker<InternalCDORevision>
implements InternalCDORevisionCache {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REVISION, BranchRevisionCache.class);
    private static boolean disableGC;
    private Map<CDOIDAndBranch, RevisionList> revisionLists = new HashMap<CDOIDAndBranch, RevisionList>();

    @Override
    public InternalCDORevisionCache instantiate(CDORevision revision) {
        return new BranchRevisionCache();
    }

    @Override
    public boolean isSupportingBranches() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EClass getObjectType(CDOID id) {
        Map<CDOIDAndBranch, RevisionList> map = this.revisionLists;
        synchronized (map) {
            for (Map.Entry<CDOIDAndBranch, RevisionList> entry : this.revisionLists.entrySet()) {
                RevisionList revisionList;
                EClass type;
                if (!id.equals(entry.getKey().getID()) || (type = (revisionList = entry.getValue()).getObjectType()) == null) continue;
                return type;
            }
        }
        return null;
    }

    @Override
    public InternalCDORevision getRevision(CDOID id, CDOBranchPoint branchPoint) {
        RevisionList revisionList = this.getRevisionList(id, branchPoint.getBranch());
        if (revisionList != null) {
            return revisionList.getRevision(branchPoint.getTimeStamp());
        }
        return null;
    }

    @Override
    public InternalCDORevision getRevisionByVersion(CDOID id, CDOBranchVersion branchVersion) {
        RevisionList revisionList = this.getRevisionList(id, branchVersion.getBranch());
        if (revisionList != null) {
            return revisionList.getRevisionByVersion(branchVersion.getVersion());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CDORevision> getCurrentRevisions() {
        ArrayList<CDORevision> currentRevisions = new ArrayList<CDORevision>();
        Map<CDOIDAndBranch, RevisionList> map = this.revisionLists;
        synchronized (map) {
            for (RevisionList revisionList : this.revisionLists.values()) {
                InternalCDORevision revision = revisionList.getRevision(0L);
                if (revision == null) continue;
                currentRevisions.add(revision);
            }
        }
        return currentRevisions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRevision(CDORevision revision) {
        CheckUtil.checkArg((Object)revision, (String)"revision");
        CDOIDAndBranch key = CDOIDUtil.createIDAndBranch(revision.getID(), revision.getBranch());
        Map<CDOIDAndBranch, RevisionList> map = this.revisionLists;
        synchronized (map) {
            RevisionList list = this.revisionLists.get(key);
            if (list == null) {
                list = new RevisionList();
                this.revisionLists.put(key, list);
            }
            InternalCDORevision rev = (InternalCDORevision)revision;
            return list.addRevision(rev, this.createReference(key, rev));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDORevision removeRevision(CDOID id, CDOBranchVersion branchVersion) {
        CDOIDAndBranch key = CDOIDUtil.createIDAndBranch(id, branchVersion.getBranch());
        Map<CDOIDAndBranch, RevisionList> map = this.revisionLists;
        synchronized (map) {
            RevisionList list = this.revisionLists.get(key);
            if (list != null) {
                list.removeRevision(branchVersion.getVersion());
                if (list.isEmpty()) {
                    this.revisionLists.remove(key);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Removed cache list of {0}", new Object[]{key});
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<CDOIDAndBranch, RevisionList> map = this.revisionLists;
        synchronized (map) {
            this.revisionLists.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<CDOIDAndBranch, RevisionList> map = this.revisionLists;
        synchronized (map) {
            return this.revisionLists.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<CDOBranch, List<CDORevision>> getAllRevisions() {
        HashMap<CDOBranch, List<CDORevision>> result = new HashMap<CDOBranch, List<CDORevision>>();
        Map<CDOIDAndBranch, RevisionList> map = this.revisionLists;
        synchronized (map) {
            for (RevisionList list : this.revisionLists.values()) {
                list.getAllRevisions(result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CDORevision> getRevisions(CDOBranchPoint branchPoint) {
        ArrayList<CDORevision> result = new ArrayList<CDORevision>();
        CDOBranch branch = branchPoint.getBranch();
        Map<CDOIDAndBranch, RevisionList> map = this.revisionLists;
        synchronized (map) {
            for (Map.Entry<CDOIDAndBranch, RevisionList> entry : this.revisionLists.entrySet()) {
                RevisionList list;
                InternalCDORevision revision;
                if (!ObjectUtil.equals((Object)entry.getKey().getBranch(), (Object)branch) || (revision = (list = entry.getValue()).getRevision(branchPoint.getTimeStamp())) == null) continue;
                result.add(revision);
            }
        }
        return result;
    }

    protected void work(Reference<? extends InternalCDORevision> reference) {
        IListener[] listeners;
        int version;
        CDOBranch branch;
        KeyedReference keyedRef = (KeyedReference)reference;
        CDORevisionKey key = (CDORevisionKey)keyedRef.getKey();
        CDOID id = key.getID();
        InternalCDORevision revision = this.removeRevision(id, (branch = key.getBranch()).getVersion(version = key.getVersion()));
        if (revision == null) {
            key = revision;
        }
        if ((listeners = this.getListeners()) != null) {
            this.fireEvent(new EvictionEventImpl(this, key), listeners);
        }
    }

    private KeyedReference<CDORevisionKey, InternalCDORevision> createReference(CDOIDAndBranch idAndBranch, InternalCDORevision revision) {
        RevisionKey key = new RevisionKey(idAndBranch, revision.getVersion());
        if (disableGC) {
            return new KeyedStrongReference((Object)key, (Object)revision);
        }
        return new KeyedSoftReference((Object)key, (Object)revision, this.getQueue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RevisionList getRevisionList(CDOID id, CDOBranch branch) {
        CDOIDAndBranch key = CDOIDUtil.createIDAndBranch(id, branch);
        Map<CDOIDAndBranch, RevisionList> map = this.revisionLists;
        synchronized (map) {
            return this.revisionLists.get(key);
        }
    }

    private static final class RevisionKey
    implements CDORevisionKey {
        private CDOIDAndBranch idAndBranch;
        private int version;

        public RevisionKey(CDOIDAndBranch idAndBranch, int version) {
            this.idAndBranch = idAndBranch;
            this.version = version;
        }

        public CDOID getID() {
            return this.idAndBranch.getID();
        }

        public CDOBranch getBranch() {
            return this.idAndBranch.getBranch();
        }

        public int getVersion() {
            return this.version;
        }

        public String toString() {
            return MessageFormat.format("{0}:{1}v{2}", this.getID(), this.getBranch().getID(), this.getVersion());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RevisionList
    extends LinkedList<KeyedReference<CDORevisionKey, InternalCDORevision>> {
        private static final long serialVersionUID = 1L;

        public synchronized EClass getObjectType() {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                EClass type;
                KeyedReference ref = (KeyedReference)it.next();
                InternalCDORevision revision = (InternalCDORevision)ref.get();
                if (revision != null && (type = revision.getEClass()) != null) {
                    return type;
                }
                it.remove();
            }
            return null;
        }

        public synchronized InternalCDORevision getRevision(long timeStamp) {
            if (timeStamp == 0L) {
                KeyedReference ref;
                KeyedReference keyedReference = ref = this.isEmpty() ? null : (KeyedReference)this.getFirst();
                if (ref != null) {
                    InternalCDORevision revision = (InternalCDORevision)ref.get();
                    if (revision != null) {
                        if (!revision.isHistorical()) {
                            return revision;
                        }
                    } else {
                        this.removeFirst();
                    }
                }
                return null;
            }
            Iterator it = this.iterator();
            while (it.hasNext()) {
                KeyedReference ref = (KeyedReference)it.next();
                InternalCDORevision revision = (InternalCDORevision)ref.get();
                if (revision != null) {
                    long created = revision.getTimeStamp();
                    if (created > timeStamp) continue;
                    long revised = revision.getRevised();
                    if (timeStamp > revised && revised != 0L) break;
                    return revision;
                }
                it.remove();
            }
            return null;
        }

        public synchronized InternalCDORevision getRevisionByVersion(int version) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                KeyedReference ref = (KeyedReference)it.next();
                InternalCDORevision revision = (InternalCDORevision)ref.get();
                if (revision != null) {
                    int v = revision.getVersion();
                    if (v == version) {
                        return revision;
                    }
                    if (v >= version) continue;
                    break;
                }
                it.remove();
            }
            return null;
        }

        public synchronized boolean addRevision(InternalCDORevision revision, KeyedReference<CDORevisionKey, InternalCDORevision> reference) {
            int version = revision.getVersion();
            ListIterator<KeyedReference<CDORevisionKey, InternalCDORevision>> it = this.listIterator();
            while (it.hasNext()) {
                KeyedReference ref = (KeyedReference)it.next();
                InternalCDORevision foundRevision = (InternalCDORevision)ref.get();
                if (foundRevision != null) {
                    CDORevisionKey key = (CDORevisionKey)ref.getKey();
                    int v = key.getVersion();
                    if (v == version) {
                        return false;
                    }
                    if (v >= version) continue;
                    it.previous();
                    it.add(reference);
                    return true;
                }
                it.remove();
            }
            this.addLast(reference);
            return true;
        }

        public synchronized void removeRevision(int version) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                KeyedReference ref = (KeyedReference)it.next();
                CDORevisionKey key = (CDORevisionKey)ref.getKey();
                int v = key.getVersion();
                if (v == version) {
                    it.remove();
                    if (!TRACER.isEnabled()) break;
                    TRACER.format("Removed version {0} from cache list of {1}", new Object[]{version, key.getID()});
                    break;
                }
                if (v < version) break;
            }
        }

        @Override
        public String toString() {
            StringBuffer buffer = new StringBuffer();
            for (KeyedReference ref : this) {
                InternalCDORevision revision = (InternalCDORevision)ref.get();
                if (buffer.length() == 0) {
                    buffer.append("{");
                } else {
                    buffer.append(", ");
                }
                buffer.append(revision);
            }
            buffer.append("}");
            return buffer.toString();
        }

        public void getAllRevisions(Map<CDOBranch, List<CDORevision>> result) {
            for (KeyedReference ref : this) {
                InternalCDORevision revision = (InternalCDORevision)ref.get();
                if (revision == null) continue;
                CDOBranch branch = revision.getBranch();
                List<CDORevision> resultList = result.get(branch);
                if (resultList == null) {
                    resultList = new ArrayList<CDORevision>(1);
                    result.put(branch, resultList);
                }
                resultList.add(revision);
            }
        }
    }
}

