/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.cache.lru;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.revision.cache.EvictionEventImpl;
import org.eclipse.emf.cdo.internal.common.revision.cache.lru.DLRevisionHolder;
import org.eclipse.emf.cdo.internal.common.revision.cache.lru.LRURevisionHolder;
import org.eclipse.emf.cdo.internal.common.revision.cache.lru.LRURevisionList;
import org.eclipse.emf.cdo.internal.common.revision.cache.lru.RevisionHolder;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRURevisionCache
extends Lifecycle
implements InternalCDORevisionCache {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REVISION, LRURevisionCache.class);
    private Map<CDOID, RevisionHolder> revisions = new HashMap<CDOID, RevisionHolder>();
    private int capacityCurrent;
    private int capacityRevised;
    private LRU currentLRU;
    private LRU revisedLRU;

    @Override
    public InternalCDORevisionCache instantiate(CDORevision revision) {
        LRURevisionCache cache = new LRURevisionCache();
        cache.setCapacityCurrent(this.capacityCurrent);
        cache.setCapacityRevised(this.capacityRevised);
        return cache;
    }

    @Override
    public boolean isSupportingBranches() {
        return false;
    }

    public int getCapacityCurrent() {
        return this.capacityCurrent;
    }

    public void setCapacityCurrent(int capacity) {
        this.capacityCurrent = capacity;
        if (this.currentLRU != null) {
            this.currentLRU.capacity(capacity);
        }
    }

    public int getCapacityRevised() {
        return this.capacityRevised;
    }

    public void setCapacityRevised(int capacity) {
        this.capacityRevised = capacity;
        if (this.revisedLRU != null) {
            this.revisedLRU.capacity(capacity);
        }
    }

    @Override
    public synchronized List<CDORevision> getCurrentRevisions() {
        ArrayList<CDORevision> currentRevisions = new ArrayList<CDORevision>();
        for (RevisionHolder holder : this.revisions.values()) {
            InternalCDORevision revision = holder.getRevision();
            if (revision == null || revision.isHistorical()) continue;
            currentRevisions.add(revision);
        }
        return currentRevisions;
    }

    @Override
    public synchronized EClass getObjectType(CDOID id) {
        RevisionHolder holder = this.getHolder(id);
        if (holder == null) {
            return null;
        }
        InternalCDORevision revision = holder.getRevision();
        return revision.getEClass();
    }

    @Override
    public synchronized InternalCDORevision getRevision(CDOID id, CDOBranchPoint branchPoint) {
        RevisionHolder holder = this.getHolder(id);
        return this.getRevision(holder, branchPoint.getTimeStamp());
    }

    @Override
    public synchronized InternalCDORevision getRevisionByVersion(CDOID id, CDOBranchVersion branchVersion) {
        for (RevisionHolder holder = this.getHolder(id); holder != null; holder = holder.getNext()) {
            int version;
            int holderVersion = holder.getVersion();
            if (holderVersion > (version = branchVersion.getVersion())) {
                continue;
            }
            if (holderVersion != version) break;
            return holder.getRevision();
        }
        return null;
    }

    @Override
    public synchronized boolean addRevision(CDORevision revision) {
        RevisionHolder holder;
        CheckUtil.checkArg((Object)revision, (String)"revision");
        if (TRACER.isEnabled()) {
            TRACER.format("Adding revision: {0}, timeStamp={1}, revised={2}, historical={3}", new Object[]{revision, CDOCommonUtil.formatTimeStamp(revision.getTimeStamp()), CDOCommonUtil.formatTimeStamp(revision.getRevised()), revision.isHistorical()});
        }
        int version = revision.getVersion();
        RevisionHolder lastHolder = null;
        for (holder = this.getHolder(revision.getID()); holder != null; holder = holder.getNext()) {
            int holderVersion = holder.getVersion();
            if (holderVersion > version) {
                lastHolder = holder;
                continue;
            }
            if (holderVersion != version) break;
            return false;
        }
        RevisionHolder newHolder = this.createHolder((InternalCDORevision)revision);
        LRU list = revision.isHistorical() ? this.revisedLRU : this.currentLRU;
        list.add((DLRevisionHolder)newHolder);
        this.adjustHolder((InternalCDORevision)revision, newHolder, lastHolder, holder);
        return true;
    }

    @Override
    public synchronized InternalCDORevision removeRevision(CDOID id, CDOBranchVersion branchVersion) {
        InternalCDORevision revision = null;
        RevisionHolder holder = this.getHolder(id);
        while (holder != null) {
            int version;
            int holderVersion = holder.getVersion();
            if (holderVersion > (version = branchVersion.getVersion())) {
                holder = holder.getNext();
                continue;
            }
            if (holderVersion == version) {
                revision = holder.getRevision();
                LRU list = revision.isHistorical() ? this.revisedLRU : this.currentLRU;
                list.remove((DLRevisionHolder)holder);
                this.removeHolder(holder);
            }
            holder = null;
        }
        return revision;
    }

    public synchronized boolean removeRevisions(CDOID id, CDOBranch branch) {
        RevisionHolder lookupHolder;
        RevisionHolder holder = lookupHolder = this.getHolder(id);
        while (holder != null) {
            RevisionHolder nextHolder = holder.getNext();
            this.removeHolder(holder);
            holder = nextHolder;
        }
        return lookupHolder != null;
    }

    @Override
    public synchronized void clear() {
        this.revisions.clear();
        this.currentLRU = new LRU(this.capacityCurrent);
        this.revisedLRU = new LRU(this.capacityRevised);
    }

    @Override
    public Map<CDOBranch, List<CDORevision>> getAllRevisions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<CDORevision> getRevisions(CDOBranchPoint branchPoint) {
        throw new UnsupportedOperationException();
    }

    private InternalCDORevision getRevision(RevisionHolder holder, long timeStamp) {
        while (holder != null) {
            int indicator = holder.compareTo(timeStamp);
            if (indicator == 1) {
                holder = holder.getNext();
                continue;
            }
            if (indicator != 0) break;
            return holder.getRevision();
        }
        return null;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.currentLRU = new LRU(this.capacityCurrent);
        this.revisedLRU = new LRU(this.capacityRevised);
    }

    protected void doDeactivate() throws Exception {
        this.currentLRU = null;
        this.revisedLRU = null;
        super.doDeactivate();
    }

    public final synchronized RevisionHolder getHolder(CDOID id) {
        return this.revisions.get(id);
    }

    protected RevisionHolder createHolder(InternalCDORevision revision) {
        return new LRURevisionHolder(revision);
    }

    private void adjustHolder(InternalCDORevision revision, RevisionHolder holder, RevisionHolder prevHolder, RevisionHolder nextHolder) {
        if (prevHolder != null) {
            if (nextHolder == null) {
                nextHolder = prevHolder.getNext();
            }
            holder.setPrev(prevHolder);
            holder.setNext(nextHolder);
            prevHolder.setNext(holder);
        } else {
            holder.setNext(nextHolder);
            this.revisions.put(revision.getID(), holder);
        }
        this.reviseHolder(holder, nextHolder);
    }

    private void reviseHolder(RevisionHolder holder, RevisionHolder nextHolder) {
        if (nextHolder != null) {
            nextHolder.setPrev(holder);
            if (holder.isCurrent() && nextHolder.isCurrent()) {
                this.currentLRU.remove((DLRevisionHolder)nextHolder);
                InternalCDORevision oldRevision = nextHolder.getRevision();
                if (oldRevision != null && oldRevision.getRevised() == 0L && holder.getCreated() > 0L && oldRevision.getVersion() == holder.getVersion() - 1) {
                    this.revisedLRU.add((DLRevisionHolder)nextHolder);
                    oldRevision.setRevised(holder.getCreated() - 1L);
                } else {
                    this.removeHolder(nextHolder);
                }
            }
        }
    }

    private synchronized void removeHolder(RevisionHolder holder) {
        CDOID id = holder.getID();
        RevisionHolder prev = holder.getPrev();
        RevisionHolder next = holder.getNext();
        if (next != null) {
            next.setPrev(prev);
        }
        if (prev != null) {
            prev.setNext(next);
        } else if (next != null) {
            this.revisions.put(id, next);
        } else {
            this.revisions.remove(id);
        }
        holder.setPrev(null);
        holder.setNext(null);
    }

    private final class LRU
    extends LRURevisionList {
        public LRU(int capacity) {
            super(capacity);
        }

        public String toString() {
            return MessageFormat.format("LRU[size={0}, capacity={1}]", this.size(), this.capacity());
        }

        protected void evict(LRURevisionHolder holder) {
            if (TRACER.isEnabled()) {
                TRACER.format("Evicting revision {0}v{1}", new Object[]{holder.getID(), holder.getVersion()});
            }
            InternalCDORevision revision = holder.getRevision();
            boolean revised = !holder.isCurrent();
            super.evict(holder);
            LRURevisionCache.this.removeHolder(holder);
            if (revision != null) {
                if (this == LRURevisionCache.this.currentLRU && revised) {
                    LRURevisionCache.this.addRevision(revision);
                } else {
                    IListener[] listeners = LRURevisionCache.this.getListeners();
                    if (listeners != null) {
                        LRURevisionCache.this.fireEvent(new EvictionEventImpl(LRURevisionCache.this, revision), listeners);
                    }
                }
            }
        }
    }
}

