/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.cache.lru;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;

public class RevisionHolder {
    private RevisionHolder prev;
    private RevisionHolder next;
    private InternalCDORevision revision;

    public RevisionHolder(InternalCDORevision revision) {
        this.setRevision(revision);
    }

    public CDOID getID() {
        return this.revision.getID();
    }

    public int getVersion() {
        return this.revision.getVersion();
    }

    public long getCreated() {
        return this.revision.getTimeStamp();
    }

    public long getRevised() {
        return this.revision.getRevised();
    }

    public boolean isCurrent() {
        return this.getRevised() == 0L;
    }

    public boolean isValid(long timeStamp) {
        return (this.getRevised() == 0L || this.getRevised() >= timeStamp) && timeStamp >= this.getCreated();
    }

    public int compareTo(long timeStamp) {
        if (timeStamp < this.getCreated()) {
            return 1;
        }
        long revised = this.getRevised();
        if (revised != 0L && revised < timeStamp) {
            return -1;
        }
        return 0;
    }

    public RevisionHolder getPrev() {
        return this.prev;
    }

    public void setPrev(RevisionHolder prev) {
        this.prev = prev;
    }

    public RevisionHolder getNext() {
        return this.next;
    }

    public void setNext(RevisionHolder next) {
        this.next = next;
    }

    public boolean isLoaded() {
        return this.revision != null;
    }

    public InternalCDORevision getRevision() {
        return this.revision;
    }

    public void setRevision(InternalCDORevision revision) {
        this.revision = revision;
    }

    public String toString() {
        return MessageFormat.format("RevisionHolder[{0}]", this.revision);
    }
}

