/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.cache.mem;

import java.lang.ref.Reference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.internal.common.branch.CDOBranchVersionImpl;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.internal.common.revision.cache.EvictionEventImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.ref.KeyedPhantomReference;
import org.eclipse.net4j.util.ref.KeyedReference;
import org.eclipse.net4j.util.ref.KeyedSoftReference;
import org.eclipse.net4j.util.ref.KeyedStrongReference;
import org.eclipse.net4j.util.ref.KeyedWeakReference;
import org.eclipse.net4j.util.ref.ReferenceQueueWorker;
import org.eclipse.net4j.util.ref.ReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MEMRevisionCache
extends ReferenceQueueWorker<InternalCDORevision>
implements InternalCDORevisionCache {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REVISION, MEMRevisionCache.class);
    private Map<CDOID, CacheList> cacheLists = new HashMap<CDOID, CacheList>();
    private ReferenceType referenceType;

    public MEMRevisionCache(ReferenceType referenceType) {
        this.setReferenceType(referenceType);
    }

    public MEMRevisionCache() {
        this(ReferenceType.SOFT);
    }

    @Override
    public InternalCDORevisionCache instantiate(CDORevision revision) {
        return new MEMRevisionCache(this.referenceType);
    }

    @Override
    public boolean isSupportingBranches() {
        return false;
    }

    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(ReferenceType referenceType) {
        this.checkInactive();
        this.referenceType = referenceType;
    }

    @Override
    public EClass getObjectType(CDOID id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDORevision getRevision(CDOID id, CDOBranchPoint branchPoint) {
        Map<CDOID, CacheList> map = this.cacheLists;
        synchronized (map) {
            CacheList list = this.cacheLists.get(id);
            if (list != null) {
                return list.getRevision(branchPoint.getTimeStamp());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDORevision getRevisionByVersion(CDOID id, CDOBranchVersion branchVersion) {
        Map<CDOID, CacheList> map = this.cacheLists;
        synchronized (map) {
            CacheList list = this.cacheLists.get(id);
            if (list != null) {
                int version = branchVersion.getVersion();
                return list.getRevisionByVersion(version);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CDORevision> getCurrentRevisions() {
        ArrayList<CDORevision> currentRevisions = new ArrayList<CDORevision>();
        Map<CDOID, CacheList> map = this.cacheLists;
        synchronized (map) {
            for (Map.Entry<CDOID, CacheList> entry : this.cacheLists.entrySet()) {
                CacheList list = entry.getValue();
                InternalCDORevision revision = list.getRevision(0L);
                if (revision == null) continue;
                currentRevisions.add(revision);
            }
        }
        return currentRevisions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRevision(CDORevision revision) {
        CheckUtil.checkArg((Object)revision, (String)"revision");
        CDOID id = revision.getID();
        Map<CDOID, CacheList> map = this.cacheLists;
        synchronized (map) {
            CacheList list = this.cacheLists.get(id);
            if (list == null) {
                list = new CacheList();
                this.cacheLists.put(id, list);
            }
            return list.addRevision((InternalCDORevision)revision);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDORevision removeRevision(CDOID id, CDOBranchVersion branchVersion) {
        Map<CDOID, CacheList> map = this.cacheLists;
        synchronized (map) {
            CacheList list = this.cacheLists.get(id);
            if (list != null) {
                int version = branchVersion.getVersion();
                list.removeRevision(version);
                if (list.isEmpty()) {
                    this.cacheLists.remove(id);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Removed cache list of {0}", new Object[]{id});
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<CDOID, CacheList> map = this.cacheLists;
        synchronized (map) {
            this.cacheLists.clear();
        }
    }

    @Override
    public Map<CDOBranch, List<CDORevision>> getAllRevisions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<CDORevision> getRevisions(CDOBranchPoint branchPoint) {
        throw new UnsupportedOperationException();
    }

    protected void work(Reference<? extends InternalCDORevision> reference) {
        int version;
        CDOBranch branch;
        KeyedReference keyedRef = (KeyedReference)reference;
        CDOIDAndVersion key = (CDOIDAndVersion)keyedRef.getKey();
        CDOID id = key.getID();
        InternalCDORevision revision = this.removeRevision(id, new CDOBranchVersionImpl(branch = null, version = key.getVersion()));
        if (revision == null) {
            IListener[] listeners = this.getListeners();
            if (listeners != null) {
                this.fireEvent(new EvictionEventImpl(this, CDORevisionUtil.createRevisionKey(id, branch, version)), listeners);
            }
        } else {
            IListener[] listeners = this.getListeners();
            if (listeners != null) {
                this.fireEvent(new EvictionEventImpl(this, revision), listeners);
            }
        }
    }

    protected KeyedReference<CDOIDAndVersion, InternalCDORevision> createReference(InternalCDORevision revision) {
        if (this.referenceType != null) {
            CDOIDAndVersion key = CDOIDUtil.createIDAndVersion(revision.getID(), revision.getVersion());
            switch (this.referenceType) {
                case STRONG: {
                    return new KeyedStrongReference((Object)key, (Object)revision);
                }
                case SOFT: {
                    return new KeyedSoftReference((Object)key, (Object)revision, this.getQueue());
                }
                case WEAK: {
                    return new KeyedWeakReference((Object)key, (Object)revision, this.getQueue());
                }
                case PHANTOM: {
                    return new KeyedPhantomReference((Object)key, (Object)revision, this.getQueue());
                }
            }
        }
        throw new IllegalStateException(MessageFormat.format(Messages.getString("MEMRevisionCache.1"), this.referenceType));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CacheList
    extends LinkedList<KeyedReference<CDOIDAndVersion, InternalCDORevision>> {
        private static final long serialVersionUID = 1L;

        public InternalCDORevision getRevision(long timeStamp) {
            if (timeStamp == 0L) {
                KeyedReference ref;
                KeyedReference keyedReference = ref = this.isEmpty() ? null : (KeyedReference)this.getFirst();
                if (ref != null) {
                    InternalCDORevision revision = (InternalCDORevision)ref.get();
                    if (revision != null) {
                        if (!revision.isHistorical()) {
                            return revision;
                        }
                    } else {
                        this.removeFirst();
                    }
                }
                return null;
            }
            Iterator it = this.iterator();
            while (it.hasNext()) {
                KeyedReference ref = (KeyedReference)it.next();
                InternalCDORevision revision = (InternalCDORevision)ref.get();
                if (revision != null) {
                    long created = revision.getTimeStamp();
                    if (created > timeStamp) continue;
                    long revised = revision.getRevised();
                    if (timeStamp > revised && revised != 0L) break;
                    return revision;
                }
                it.remove();
            }
            return null;
        }

        public InternalCDORevision getRevisionByVersion(int version) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                KeyedReference ref = (KeyedReference)it.next();
                InternalCDORevision revision = (InternalCDORevision)ref.get();
                if (revision != null) {
                    int v = revision.getVersion();
                    if (v == version) {
                        return revision;
                    }
                    if (v >= version) continue;
                    break;
                }
                it.remove();
            }
            return null;
        }

        public void removeRevision(int version) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                KeyedReference ref = (KeyedReference)it.next();
                CDOIDAndVersion key = (CDOIDAndVersion)ref.getKey();
                int v = key.getVersion();
                if (v == version) {
                    it.remove();
                    if (!TRACER.isEnabled()) break;
                    TRACER.format("Removed version {0} from cache list of {1}", new Object[]{version, key.getID()});
                    break;
                }
                if (v < version) break;
            }
        }

        public boolean addRevision(InternalCDORevision revision) {
            KeyedReference<CDOIDAndVersion, InternalCDORevision> reference = MEMRevisionCache.this.createReference(revision);
            int version = revision.getVersion();
            ListIterator<KeyedReference<CDOIDAndVersion, InternalCDORevision>> it = this.listIterator();
            while (it.hasNext()) {
                KeyedReference ref = (KeyedReference)it.next();
                InternalCDORevision foundRevision = (InternalCDORevision)ref.get();
                if (foundRevision != null) {
                    CDOIDAndVersion key = (CDOIDAndVersion)ref.getKey();
                    int v = key.getVersion();
                    if (v == version) {
                        return false;
                    }
                    if (v >= version) continue;
                    it.previous();
                    it.add(reference);
                    return true;
                }
                it.remove();
            }
            this.addLast(reference);
            return true;
        }
    }
}

