/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.cache.two;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.cache.CDORevisionCache;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoLevelRevisionCache
extends Lifecycle
implements InternalCDORevisionCache,
IListener {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REVISION, TwoLevelRevisionCache.class);
    private InternalCDORevisionCache level1;
    private InternalCDORevisionCache level2;

    @Override
    public InternalCDORevisionCache instantiate(CDORevision revision) {
        TwoLevelRevisionCache cache = new TwoLevelRevisionCache();
        cache.setLevel1(this.level1.instantiate(revision));
        cache.setLevel2(this.level2.instantiate(revision));
        return cache;
    }

    @Override
    public boolean isSupportingBranches() {
        return false;
    }

    public InternalCDORevisionCache getLevel1() {
        return this.level1;
    }

    public void setLevel1(InternalCDORevisionCache level1) {
        this.level1 = level1;
    }

    public InternalCDORevisionCache getLevel2() {
        return this.level2;
    }

    public void setLevel2(InternalCDORevisionCache level2) {
        this.level2 = level2;
    }

    @Override
    public EClass getObjectType(CDOID id) {
        EClass objectType = this.level1.getObjectType(id);
        if (objectType == null) {
            objectType = this.level2.getObjectType(id);
        }
        return objectType;
    }

    @Override
    public CDORevision getRevision(CDOID id, CDOBranchPoint branchPoint) {
        CDORevision revision = this.level1.getRevision(id, branchPoint);
        if (revision == null) {
            revision = this.level2.getRevision(id, branchPoint);
        }
        return revision;
    }

    @Override
    public CDORevision getRevisionByVersion(CDOID id, CDOBranchVersion branchVersion) {
        CDORevision revision = this.level1.getRevisionByVersion(id, branchVersion);
        if (revision == null) {
            revision = this.level2.getRevisionByVersion(id, branchVersion);
        }
        return revision;
    }

    @Override
    public List<CDORevision> getCurrentRevisions() {
        ArrayList<CDORevision> revisions = new ArrayList<CDORevision>();
        revisions.addAll(this.level1.getCurrentRevisions());
        revisions.addAll(this.level2.getCurrentRevisions());
        return revisions;
    }

    @Override
    public boolean addRevision(CDORevision revision) {
        CDOID id;
        CDORevision revisionInLevel2;
        CheckUtil.checkArg((Object)revision, (String)"revision");
        boolean added = this.level1.addRevision(revision);
        if (added && !revision.isHistorical() && (revisionInLevel2 = this.level2.getRevision(id = revision.getID(), revision)) != null && !revisionInLevel2.isHistorical()) {
            if (revision.getVersion() == revisionInLevel2.getVersion() + 1) {
                ((InternalCDORevision)revisionInLevel2).setRevised(revision.getTimeStamp() - 1L);
            } else {
                this.level2.removeRevision(id, revision.getBranch().getVersion(revisionInLevel2.getVersion()));
            }
        }
        return added;
    }

    @Override
    public CDORevision removeRevision(CDOID id, CDOBranchVersion branchVersion) {
        CDORevision revision1 = this.level1.removeRevision(id, branchVersion);
        CDORevision revision2 = this.level2.removeRevision(id, branchVersion);
        return revision1 != null ? revision1 : revision2;
    }

    @Override
    public void clear() {
        this.level1.clear();
        this.level2.clear();
    }

    @Override
    public Map<CDOBranch, List<CDORevision>> getAllRevisions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<CDORevision> getRevisions(CDOBranchPoint branchPoint) {
        throw new UnsupportedOperationException();
    }

    public void notifyEvent(IEvent event) {
        CDORevisionCache.EvictionEvent e;
        CDORevision revision;
        if (event instanceof CDORevisionCache.EvictionEvent && (revision = (e = (CDORevisionCache.EvictionEvent)event).getRevision()) != null) {
            CDORevisionCache cache = e.getSource();
            if (cache == this.level1) {
                this.evictedFromLevel1(revision);
            } else if (cache == this.level2) {
                this.evictedFromLevel2(revision);
            }
        }
    }

    protected void evictedFromLevel1(CDORevision revision) {
        this.level2.addRevision(revision);
        if (TRACER.isEnabled()) {
            TRACER.format("Recached revision {0}", new Object[]{revision});
        }
    }

    protected void evictedFromLevel2(CDORevision revision) {
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.level1, "level1");
        this.checkState(this.level2, "level2");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.level1.addListener(this);
        this.level2.addListener(this);
        LifecycleUtil.activate((Object)this.level1);
        LifecycleUtil.activate((Object)this.level2);
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.level2);
        LifecycleUtil.deactivate((Object)this.level1);
        this.level2.removeListener(this);
        this.level1.removeListener(this);
        super.doDeactivate();
    }
}

