/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOFeatureDelta;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.CheckUtil;

public abstract class CDOFeatureDeltaImpl
implements InternalCDOFeatureDelta {
    public static final int NO_INDEX = -1;
    private EStructuralFeature feature;

    protected CDOFeatureDeltaImpl(EStructuralFeature feature) {
        CheckUtil.checkArg((Object)feature, (String)"feature");
        this.feature = feature;
    }

    public CDOFeatureDeltaImpl(CDODataInput in, EClass eClass) throws IOException {
        int featureID = in.readInt();
        this.feature = eClass.getEStructuralFeature(featureID);
        CheckUtil.checkState((Object)this.feature, (String)"feature");
    }

    public void write(CDODataOutput out, EClass eClass) throws IOException {
        out.writeInt(this.getType().ordinal());
        out.writeInt(eClass.getFeatureID(this.feature));
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    public int hashCode() {
        return this.feature.hashCode() ^ this.getType().hashCode() << 16;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CDOFeatureDelta) {
            CDOFeatureDelta that = (CDOFeatureDelta)obj;
            return this.feature.equals(that.getFeature()) && this.getType().equals((Object)that.getType());
        }
        return false;
    }

    public String toString() {
        String additional = this.toStringAdditional();
        if (additional == null) {
            return MessageFormat.format("CDOFeatureDelta[{0}, {1}]", new Object[]{this.feature.getName(), this.getType()});
        }
        return MessageFormat.format("CDOFeatureDelta[{0}, {1}, {2}]", new Object[]{this.feature.getName(), this.getType(), additional});
    }

    public abstract void adjustReferences(CDOReferenceAdjuster var1);

    protected abstract String toStringAdditional();
}

