/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOFeatureDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CDOMoveFeatureDeltaImpl
extends CDOFeatureDeltaImpl
implements CDOMoveFeatureDelta,
InternalCDOFeatureDelta.ListIndexAffecting,
InternalCDOFeatureDelta.WithIndex {
    private int oldPosition;
    private int newPosition;
    private Object value;

    public CDOMoveFeatureDeltaImpl(EStructuralFeature feature, int newPosition, int oldPosition) {
        super(feature);
        this.newPosition = newPosition;
        this.oldPosition = oldPosition;
        this.value = UNKNOWN_VALUE;
    }

    public CDOMoveFeatureDeltaImpl(CDODataInput in, EClass eClass) throws IOException {
        super(in, eClass);
        this.newPosition = in.readInt();
        this.oldPosition = in.readInt();
        this.value = UNKNOWN_VALUE;
    }

    public void write(CDODataOutput out, EClass eClass) throws IOException {
        super.write(out, eClass);
        out.writeInt(this.newPosition);
        out.writeInt(this.oldPosition);
    }

    public int getNewPosition() {
        return this.newPosition;
    }

    public int getOldPosition() {
        return this.oldPosition;
    }

    public CDOFeatureDelta.Type getType() {
        return CDOFeatureDelta.Type.MOVE;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public CDOFeatureDelta copy() {
        CDOMoveFeatureDeltaImpl copy = new CDOMoveFeatureDeltaImpl(this.getFeature(), this.newPosition, this.oldPosition);
        copy.setValue(this.getValue());
        return copy;
    }

    public void apply(CDORevision revision) {
        ((InternalCDORevision)revision).getList(this.getFeature()).move(this.newPosition, this.oldPosition);
    }

    public void affectIndices(InternalCDOFeatureDelta.ListTargetAdding[] source, int[] indices) {
        block9: {
            block8: {
                if (this.oldPosition >= this.newPosition) break block8;
                int i = 1;
                while (i <= indices[0]) {
                    if (this.oldPosition < indices[i] && indices[i] <= this.newPosition) {
                        int n = i;
                        indices[n] = indices[n] - 1;
                    } else if (indices[i] == this.oldPosition) {
                        indices[i] = this.newPosition;
                    }
                    ++i;
                }
                break block9;
            }
            if (this.newPosition >= this.oldPosition) break block9;
            int i = 1;
            while (i <= indices[0]) {
                if (this.newPosition <= indices[i] && indices[i] < this.oldPosition) {
                    int n = i;
                    indices[n] = indices[n] + 1;
                } else if (indices[i] == this.oldPosition) {
                    indices[i] = this.newPosition;
                }
                ++i;
            }
        }
    }

    public void accept(CDOFeatureDeltaVisitor visitor) {
        visitor.visit(this);
    }

    public void adjustAfterAddition(int index) {
        if (index <= this.oldPosition) {
            ++this.oldPosition;
        }
        if (index <= this.newPosition) {
            ++this.newPosition;
        }
    }

    public void adjustAfterRemoval(int index) {
        if (index <= this.oldPosition && this.oldPosition > 0) {
            --this.oldPosition;
        }
        if (index <= this.newPosition && this.newPosition > 0) {
            --this.newPosition;
        }
    }

    public void adjustReferences(CDOReferenceAdjuster adjuster) {
    }

    public int hashCode() {
        return super.hashCode() ^ this.oldPosition ^ this.newPosition;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        CDOMoveFeatureDelta that = (CDOMoveFeatureDelta)obj;
        return this.oldPosition == that.getOldPosition() && this.newPosition == that.getNewPosition();
    }

    protected String toStringAdditional() {
        return MessageFormat.format("from={0}, to={1}", this.oldPosition, this.newPosition);
    }
}

