/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOAddFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOClearFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOContainerFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOListFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOMoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORemoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOSetFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOUnsetFeatureDeltaImpl;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOFeatureDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ListChange;
import org.eclipse.emf.ecore.change.util.ListDifferenceAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDORevisionDeltaImpl
implements InternalCDORevisionDelta {
    private EClass eClass;
    private CDOID id;
    private CDOBranch branch;
    private int version;
    private CDOBranchVersion target;
    private Map<EStructuralFeature, CDOFeatureDelta> featureDeltas = new HashMap<EStructuralFeature, CDOFeatureDelta>();

    public CDORevisionDeltaImpl(CDORevision revision) {
        this.eClass = revision.getEClass();
        this.id = revision.getID();
        this.branch = revision.getBranch();
        this.version = revision.getVersion();
    }

    public CDORevisionDeltaImpl(CDORevisionDelta revisionDelta, boolean copyFeatureDeltas) {
        this.eClass = revisionDelta.getEClass();
        this.id = revisionDelta.getID();
        this.branch = revisionDelta.getBranch();
        this.version = revisionDelta.getVersion();
        if (copyFeatureDeltas) {
            for (CDOFeatureDelta delta : revisionDelta.getFeatureDeltas()) {
                this.addFeatureDelta(((InternalCDOFeatureDelta)delta).copy());
            }
        }
    }

    public CDORevisionDeltaImpl(CDORevision sourceRevision, CDORevision targetRevision) {
        if (sourceRevision.getEClass() != targetRevision.getEClass()) {
            throw new IllegalArgumentException();
        }
        this.eClass = sourceRevision.getEClass();
        this.id = sourceRevision.getID();
        this.branch = sourceRevision.getBranch();
        this.version = sourceRevision.getVersion();
        this.target = CDOBranchUtil.copyBranchVersion(targetRevision);
        this.compare(sourceRevision, targetRevision);
        CDORevisionData originData = sourceRevision.data();
        CDORevisionData dirtyData = targetRevision.data();
        if (!(this.compare(originData.getContainerID(), dirtyData.getContainerID()) && this.compare(originData.getContainingFeatureID(), dirtyData.getContainingFeatureID()) && this.compare(originData.getResourceID(), dirtyData.getResourceID()))) {
            this.addFeatureDelta(new CDOContainerFeatureDeltaImpl(dirtyData.getResourceID(), dirtyData.getContainerID(), dirtyData.getContainingFeatureID()));
        }
    }

    public CDORevisionDeltaImpl(CDODataInput in) throws IOException {
        this.eClass = (EClass)in.readCDOClassifierRefAndResolve();
        this.id = in.readCDOID();
        this.branch = in.readCDOBranch();
        this.version = in.readInt();
        if (this.version < 0) {
            this.version = -this.version;
            this.target = in.readCDOBranchVersion();
        }
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            CDOFeatureDelta featureDelta = in.readCDOFeatureDelta(this.eClass);
            this.featureDeltas.put(featureDelta.getFeature(), featureDelta);
            ++i;
        }
    }

    public void write(CDODataOutput out) throws IOException {
        out.writeCDOClassifierRef((EClassifier)this.eClass);
        out.writeCDOID(this.id);
        out.writeCDOBranch(this.branch);
        if (this.target == null) {
            out.writeInt(this.version);
        } else {
            out.writeInt(-this.version);
            out.writeCDOBranchVersion(this.target);
        }
        out.writeInt(this.featureDeltas.size());
        for (CDOFeatureDelta featureDelta : this.featureDeltas.values()) {
            out.writeCDOFeatureDelta(this.eClass, featureDelta);
        }
    }

    @Override
    public EClass getEClass() {
        return this.eClass;
    }

    @Override
    public CDOID getID() {
        return this.id;
    }

    @Override
    public CDOBranch getBranch() {
        return this.branch;
    }

    @Override
    public void setBranch(CDOBranch branch) {
        this.branch = branch;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    public CDOBranchVersion getTarget() {
        return this.target;
    }

    public void setTarget(CDOBranchVersion target) {
        this.target = target;
    }

    @Override
    public boolean isEmpty() {
        return this.featureDeltas.isEmpty();
    }

    @Override
    public Map<EStructuralFeature, CDOFeatureDelta> getFeatureDeltaMap() {
        return this.featureDeltas;
    }

    public CDOFeatureDelta getFeatureDelta(EStructuralFeature feature) {
        return this.featureDeltas.get(feature);
    }

    @Override
    public List<CDOFeatureDelta> getFeatureDeltas() {
        return new ArrayList<CDOFeatureDelta>(this.featureDeltas.values());
    }

    @Override
    public void apply(CDORevision revision) {
        for (CDOFeatureDelta featureDelta : this.featureDeltas.values()) {
            ((CDOFeatureDeltaImpl)featureDelta).apply(revision);
        }
    }

    @Override
    public void addFeatureDelta(CDOFeatureDelta delta) {
        if (delta instanceof CDOListFeatureDelta) {
            CDOListFeatureDelta deltas = (CDOListFeatureDelta)delta;
            for (CDOFeatureDelta childDelta : deltas.getListChanges()) {
                this.addFeatureDelta(childDelta);
            }
        } else {
            this.addSingleFeatureDelta(delta);
        }
    }

    private void addSingleFeatureDelta(CDOFeatureDelta delta) {
        EStructuralFeature feature = delta.getFeature();
        if (feature.isMany()) {
            CDOListFeatureDeltaImpl listDelta = (CDOListFeatureDeltaImpl)this.featureDeltas.get(feature);
            if (listDelta == null) {
                listDelta = new CDOListFeatureDeltaImpl(feature);
                this.featureDeltas.put(listDelta.getFeature(), listDelta);
            }
            if (delta instanceof CDOClearFeatureDelta || delta instanceof CDOUnsetFeatureDelta) {
                listDelta.getListChanges().clear();
            }
            listDelta.add(delta);
        } else {
            this.featureDeltas.put(feature, delta);
        }
    }

    @Override
    public void adjustReferences(CDOReferenceAdjuster idMappings) {
        for (CDOFeatureDelta featureDelta : this.featureDeltas.values()) {
            ((CDOFeatureDeltaImpl)featureDelta).adjustReferences(idMappings);
        }
    }

    @Override
    public void accept(CDOFeatureDeltaVisitor visitor) {
        for (CDOFeatureDelta featureDelta : this.featureDeltas.values()) {
            ((CDOFeatureDeltaImpl)featureDelta).accept(visitor);
        }
    }

    private void compare(CDORevision originRevision, CDORevision dirtyRevision) {
        CDORevisionData originData = originRevision.data();
        CDORevisionData dirtyData = dirtyRevision.data();
        EStructuralFeature[] eStructuralFeatureArray = CDOModelUtil.getAllPersistentFeatures(this.eClass);
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            final EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature.isMany()) {
                if (originData.size(feature) > 0 && dirtyData.size(feature) == 0) {
                    this.addFeatureDelta(new CDOClearFeatureDeltaImpl(feature));
                } else {
                    CDOListFeatureDeltaImpl listFeatureDelta = new CDOListFeatureDeltaImpl(feature);
                    final List<CDOFeatureDelta> changes = listFeatureDelta.getListChanges();
                    ListDifferenceAnalyzer analyzer = new ListDifferenceAnalyzer(){

                        protected void createAddListChange(EList<Object> oldList, EList<ListChange> listChanges, Object value, int index) {
                            CDOAddFeatureDeltaImpl delta = new CDOAddFeatureDeltaImpl(feature, index, value);
                            changes.add(delta);
                            oldList.add(index, value);
                        }

                        protected void createRemoveListChange(EList<?> oldList, EList<ListChange> listChanges, Object value, int index) {
                            CDORemoveFeatureDeltaImpl delta = new CDORemoveFeatureDeltaImpl(feature, index);
                            delta.setValue(oldList.get(index));
                            changes.add(delta);
                            oldList.remove(index);
                        }

                        protected void createMoveListChange(EList<?> oldList, EList<ListChange> listChanges, Object value, int index, int toIndex) {
                            CDOMoveFeatureDeltaImpl delta = new CDOMoveFeatureDeltaImpl(feature, toIndex, index);
                            changes.add(delta);
                            oldList.move(toIndex, index);
                        }
                    };
                    CDOList originList = ((InternalCDORevision)originRevision).getList(feature);
                    CDOList dirtyList = ((InternalCDORevision)dirtyRevision).getList(feature);
                    analyzer.analyzeLists((EList)originList, (EList)dirtyList, (EList)new NOOPList());
                    if (!changes.isEmpty()) {
                        this.featureDeltas.put(feature, listFeatureDelta);
                    }
                }
            } else {
                Object dirtyValue;
                Object originValue = originData.get(feature, 0);
                if (!this.compare(originValue, dirtyValue = dirtyData.get(feature, 0))) {
                    if (dirtyValue == null) {
                        this.addFeatureDelta(new CDOUnsetFeatureDeltaImpl(feature));
                    } else {
                        this.addFeatureDelta(new CDOSetFeatureDeltaImpl(feature, 0, dirtyValue));
                    }
                }
            }
            ++n2;
        }
    }

    private boolean compare(Object originValue, Object dirtyValue) {
        return originValue == dirtyValue || originValue != null && dirtyValue != null && originValue.equals(dirtyValue);
    }

    public String toString() {
        return MessageFormat.format("CDORevisionDelta[{0}@{1}:{2}v{3} --> {4}]", this.eClass.getName(), this.id, this.branch.getID(), this.version, this.featureDeltas.values());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NOOPList
    implements EList<ListChange> {
        private static final EList<ListChange> LIST = ECollections.emptyEList();

        public int size() {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean contains(Object o) {
            return false;
        }

        public Iterator<ListChange> iterator() {
            return LIST.iterator();
        }

        public Object[] toArray() {
            return LIST.toArray();
        }

        public <T> T[] toArray(T[] a) {
            return LIST.toArray((Object[])a);
        }

        public boolean add(ListChange o) {
            return false;
        }

        public boolean remove(Object o) {
            return false;
        }

        public boolean containsAll(Collection<?> c) {
            return false;
        }

        public boolean addAll(Collection<? extends ListChange> c) {
            return false;
        }

        public boolean addAll(int index, Collection<? extends ListChange> c) {
            return false;
        }

        public boolean removeAll(Collection<?> c) {
            return false;
        }

        public boolean retainAll(Collection<?> c) {
            return false;
        }

        public void clear() {
        }

        public ListChange get(int index) {
            return (ListChange)LIST.get(index);
        }

        public ListChange set(int index, ListChange element) {
            return null;
        }

        public void add(int index, ListChange element) {
        }

        public ListChange remove(int index) {
            return null;
        }

        public int indexOf(Object o) {
            return LIST.indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return LIST.lastIndexOf(o);
        }

        public ListIterator<ListChange> listIterator() {
            return LIST.listIterator();
        }

        public ListIterator<ListChange> listIterator(int index) {
            return LIST.listIterator(index);
        }

        public List<ListChange> subList(int fromIndex, int toIndex) {
            return LIST.subList(fromIndex, toIndex);
        }

        public void move(int newPosition, ListChange object) {
        }

        public ListChange move(int newPosition, int oldPosition) {
            return null;
        }
    }
}

