/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.revision;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClassInfo;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDeltaUtil;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.revision.AbstractCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.CDORevisionMerger;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.om.trace.PerfTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCDORevision
extends AbstractCDORevision {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REVISION, BaseCDORevision.class);
    private static final PerfTracer READING = new PerfTracer(OM.PERF_REVISION_READING, BaseCDORevision.class);
    private static final PerfTracer WRITING = new PerfTracer(OM.PERF_REVISION_WRITING, BaseCDORevision.class);
    private static final byte UNSET = 0;
    private static final byte SET_NULL = 1;
    private static final byte SET_NOT_NULL = 2;
    private CDOID id;
    private CDOBranchPoint branchPoint;
    private int version;
    private long revised;
    private CDOID resourceID;
    private Object containerID;
    private int containingFeatureID;

    public BaseCDORevision(EClass eClass) {
        super(eClass);
        if (eClass != null) {
            this.version = 0;
            this.revised = 0L;
            this.resourceID = CDOID.NULL;
            this.containerID = CDOID.NULL;
            this.containingFeatureID = 0;
            this.initValues(this.getAllPersistentFeatures());
        }
    }

    protected BaseCDORevision(BaseCDORevision source) {
        super(source.getEClass());
        this.id = source.id;
        this.branchPoint = source.branchPoint;
        this.version = source.version;
        this.revised = source.revised;
        this.resourceID = source.resourceID;
        this.containerID = source.containerID;
        this.containingFeatureID = source.containingFeatureID;
    }

    @Override
    public void read(CDODataInput in) throws IOException {
        READING.start((Object)this);
        EClassifier classifier = in.readCDOClassifierRefAndResolve();
        CDOClassInfo classInfo = CDOModelUtil.getClassInfo((EClass)classifier);
        this.setClassInfo(classInfo);
        this.id = in.readCDOID();
        this.branchPoint = in.readCDOBranchPoint();
        this.version = in.readInt();
        if (!this.id.isTemporary()) {
            this.revised = in.readLong();
        }
        this.resourceID = in.readCDOID();
        this.containerID = in.readCDOID();
        this.containingFeatureID = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading revision: ID={0}, className={1}, version={2}, branchPoint={3}, revised={4}, resource={5}, container={6}, featureID={7}", new Object[]{this.id, this.getEClass().getName(), this.version, this.branchPoint, this.revised, this.resourceID, this.containerID, this.containingFeatureID});
        }
        this.readValues(in);
        READING.stop((Object)this);
    }

    @Override
    public void write(CDODataOutput out, int referenceChunk) throws IOException {
        EClass eClass = this.getEClass();
        CDOClassifierRef classRef = new CDOClassifierRef((EClassifier)eClass);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing revision: ID={0}, className={1}, version={2}, branchPoint={3}, revised={4}, resource={5}, container={6}, featureID={7}", new Object[]{this.id, eClass.getName(), this.getVersion(), this.branchPoint, this.revised, this.resourceID, this.containerID, this.containingFeatureID});
        }
        WRITING.start((Object)this);
        out.writeCDOClassifierRef(classRef);
        out.writeCDOID(this.id);
        out.writeCDOBranchPoint(this.branchPoint);
        out.writeInt(this.getVersion());
        if (!this.id.isTemporary()) {
            out.writeLong(this.revised);
        }
        out.writeCDOID(this.resourceID);
        out.writeCDOID(out.getIDProvider().provideCDOID(this.containerID));
        out.writeInt(this.containingFeatureID);
        this.writeValues(out, referenceChunk);
        WRITING.stop((Object)this);
    }

    @Override
    public void convertEObjects(CDOIDProvider idProvider) {
        if (!(this.containerID instanceof CDOID)) {
            this.containerID = idProvider.provideCDOID(this.containerID);
        }
        EStructuralFeature[] features = this.getAllPersistentFeatures();
        int i = 0;
        while (i < features.length) {
            EStructuralFeature feature = features[i];
            if (feature.isMany()) {
                CDOList list = this.getValueAsList(i);
                if (list != null) {
                    boolean isFeatureMap = FeatureMapUtil.isFeatureMap((EStructuralFeature)feature);
                    int j = 0;
                    while (j < list.size()) {
                        CDOID newValue;
                        Object value = list.get(j, false);
                        EStructuralFeature innerFeature = feature;
                        if (isFeatureMap) {
                            FeatureMap.Entry entry = (FeatureMap.Entry)value;
                            innerFeature = entry.getEStructuralFeature();
                            value = entry.getValue();
                        }
                        if (value != null && innerFeature instanceof EReference && (newValue = idProvider.provideCDOID(value)) != value) {
                            list.set(j, newValue);
                        }
                        ++j;
                    }
                }
            } else {
                CDOID newValue;
                BaseCDORevision.checkNoFeatureMap(feature);
                Object value = this.getValue(i);
                if (value != null && feature instanceof EReference && (newValue = idProvider.provideCDOID(value)) != value) {
                    this.setValue(i, (Object)newValue);
                }
            }
            ++i;
        }
    }

    @Override
    public CDOID getID() {
        return this.id;
    }

    @Override
    public void setID(CDOID id) {
        if (CDOIDUtil.isNull(id)) {
            throw new IllegalArgumentException(Messages.getString("AbstractCDORevision.1"));
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Setting ID: {0}", new Object[]{id});
        }
        this.id = id;
    }

    @Override
    public CDOBranch getBranch() {
        if (this.branchPoint == null) {
            return null;
        }
        return this.branchPoint.getBranch();
    }

    @Override
    public long getTimeStamp() {
        if (this.branchPoint == null) {
            return 0L;
        }
        return this.branchPoint.getTimeStamp();
    }

    @Override
    public void setBranchPoint(CDOBranchPoint branchPoint) {
        branchPoint = CDOBranchUtil.copyBranchPoint(branchPoint);
        if (TRACER.isEnabled()) {
            TRACER.format("Setting branchPoint {0}: {1}", new Object[]{this, branchPoint});
        }
        this.branchPoint = branchPoint;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting version for {0}: v{1}", new Object[]{this, version});
        }
        this.version = version;
    }

    @Override
    public long getRevised() {
        return this.revised;
    }

    @Override
    public void setRevised(long revised) {
        long created = this.branchPoint.getTimeStamp();
        if (revised != 0L && revised < Math.max(0L, created)) {
            throw new IllegalArgumentException("revision=" + this + ", created=" + CDOCommonUtil.formatTimeStamp(created) + ", revised=" + CDOCommonUtil.formatTimeStamp(revised));
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Setting revised {0}: {1}", new Object[]{this, CDOCommonUtil.formatTimeStamp(revised)});
        }
        this.revised = revised;
    }

    @Override
    public InternalCDORevisionDelta compare(CDORevision origin) {
        return (InternalCDORevisionDelta)CDORevisionDeltaUtil.create(origin, this);
    }

    @Override
    public int compareTo(CDOBranchPoint o) {
        return this.branchPoint.compareTo(o);
    }

    @Override
    public void merge(CDORevisionDelta delta) {
        CDORevisionMerger applier = new CDORevisionMerger();
        applier.merge(this, delta);
    }

    @Override
    public CDOID getResourceID() {
        return this.resourceID;
    }

    @Override
    public void setResourceID(CDOID resourceID) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting resourceID {0}: {1}", new Object[]{this, resourceID});
        }
        this.resourceID = resourceID;
    }

    @Override
    public Object getContainerID() {
        return this.containerID;
    }

    @Override
    public void setContainerID(Object containerID) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting containerID {0}: {1}", new Object[]{this, containerID});
        }
        this.containerID = containerID;
    }

    @Override
    public int getContainingFeatureID() {
        return this.containingFeatureID;
    }

    @Override
    public void setContainingFeatureID(int containingFeatureID) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting containingFeatureID {0}: {1}", new Object[]{this, containingFeatureID});
        }
        this.containingFeatureID = containingFeatureID;
    }

    @Override
    public int hashCode(EStructuralFeature feature) {
        return this.getValue(feature).hashCode();
    }

    @Override
    public Object get(EStructuralFeature feature, int index) {
        if (feature.isMany() && index != -1) {
            return this.getList(feature).get(index);
        }
        return this.getValue(feature);
    }

    @Override
    public boolean contains(EStructuralFeature feature, Object value) {
        return this.getList(feature).contains(value);
    }

    @Override
    public int indexOf(EStructuralFeature feature, Object value) {
        return this.getList(feature).indexOf(value);
    }

    @Override
    public boolean isEmpty(EStructuralFeature feature) {
        return this.getList(feature).isEmpty();
    }

    @Override
    public int lastIndexOf(EStructuralFeature feature, Object value) {
        return this.getList(feature).lastIndexOf(value);
    }

    @Override
    public int size(EStructuralFeature feature) {
        return this.getList(feature).size();
    }

    @Override
    public Object[] toArray(EStructuralFeature feature) {
        if (!feature.isMany()) {
            throw new IllegalStateException("!feature.isMany()");
        }
        return this.getList(feature).toArray();
    }

    @Override
    public <T> T[] toArray(EStructuralFeature feature, T[] array) {
        if (!feature.isMany()) {
            throw new IllegalStateException("!feature.isMany()");
        }
        return this.getList(feature).toArray(array);
    }

    @Override
    public void add(EStructuralFeature feature, int index, Object value) {
        this.getList(feature).add(index, value);
    }

    @Override
    public void clear(EStructuralFeature feature) {
        this.setValue(feature, null);
    }

    @Override
    public Object move(EStructuralFeature feature, int targetIndex, int sourceIndex) {
        return this.getList(feature).move(targetIndex, sourceIndex);
    }

    @Override
    public Object remove(EStructuralFeature feature, int index) {
        return this.getList(feature).remove(index);
    }

    @Override
    public Object set(EStructuralFeature feature, int index, Object value) {
        if (feature.isMany()) {
            return this.getList(feature).set(index, value);
        }
        return this.setValue(feature, value);
    }

    @Override
    public void unset(EStructuralFeature feature) {
        this.setValue(feature, null);
    }

    @Override
    public void adjustReferences(CDOReferenceAdjuster revisionAdjuster) {
        if (TRACER.isEnabled()) {
            TRACER.format("Adjusting references for revision {0}", new Object[]{this});
        }
        this.resourceID = (CDOID)revisionAdjuster.adjustReference(this.resourceID);
        this.containerID = revisionAdjuster.adjustReference(this.containerID);
        EStructuralFeature[] features = this.getAllPersistentFeatures();
        int i = 0;
        while (i < features.length) {
            EStructuralFeature feature = features[i];
            if (feature instanceof EReference || FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                if (feature.isMany()) {
                    InternalCDOList list = (InternalCDOList)this.getValueAsList(i);
                    if (list != null) {
                        list.adjustReferences(revisionAdjuster, feature);
                    }
                } else {
                    Object newValue;
                    CDOType type = CDOModelUtil.getType(feature);
                    Object oldValue = this.getValue(i);
                    if (oldValue != (newValue = type.adjustReferences(revisionAdjuster, oldValue))) {
                        this.setValue(i, newValue);
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public Object getValue(EStructuralFeature feature) {
        int featureIndex = this.getFeatureIndex(feature);
        return this.getValue(featureIndex);
    }

    @Override
    public Object setValue(EStructuralFeature feature, Object value) {
        int featureIndex = this.getFeatureIndex(feature);
        try {
            Object old = this.getValue(featureIndex);
            this.setValue(featureIndex, value);
            return old;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("AbstractCDORevision.20"), feature, this.getClassInfo()), ex);
        }
    }

    @Override
    public CDOList getList(EStructuralFeature feature) {
        return this.getList(feature, 0);
    }

    @Override
    public CDOList getList(EStructuralFeature feature, int size) {
        int featureIndex = this.getFeatureIndex(feature);
        CDOList list = (CDOList)this.getValue(featureIndex);
        if (list == null && size != -1) {
            list = CDOListFactory.DEFAULT.createList(size, 0, 0);
            this.setValue(featureIndex, (Object)list);
        }
        return list;
    }

    @Override
    public void setList(EStructuralFeature feature, InternalCDOList list) {
        int featureIndex = this.getFeatureIndex(feature);
        this.setValue(featureIndex, (Object)list);
    }

    protected abstract void initValues(EStructuralFeature[] var1);

    protected abstract Object getValue(int var1);

    protected abstract void setValue(int var1, Object var2);

    private CDOList getValueAsList(int i) {
        return (CDOList)this.getValue(i);
    }

    private void writeValues(CDODataOutput out, int referenceChunk) throws IOException {
        EClass owner = this.getEClass();
        EStructuralFeature[] features = this.getAllPersistentFeatures();
        int i = 0;
        while (i < features.length) {
            EStructuralFeature feature = features[i];
            Object value = this.getValue(i);
            if (value == null) {
                out.writeByte(0);
            } else if (value == CDORevisionData.NIL) {
                out.writeByte(1);
            } else {
                out.writeByte(2);
                if (feature.isMany()) {
                    CDOList list = (CDOList)value;
                    out.writeCDOList(owner, feature, list, referenceChunk);
                } else {
                    BaseCDORevision.checkNoFeatureMap(feature);
                    if (feature instanceof EReference) {
                        value = out.getIDProvider().provideCDOID(value);
                    }
                    if (TRACER.isEnabled()) {
                        TRACER.format("Writing feature {0}: {1}", new Object[]{feature.getName(), value});
                    }
                    out.writeCDOFeatureValue(feature, value);
                }
            }
            ++i;
        }
    }

    private void readValues(CDODataInput in) throws IOException {
        EClass owner = this.getEClass();
        EStructuralFeature[] features = this.getAllPersistentFeatures();
        this.initValues(features);
        int i = 0;
        while (i < features.length) {
            EStructuralFeature feature = features[i];
            byte unsetState = in.readByte();
            switch (unsetState) {
                case 0: {
                    break;
                }
                case 1: {
                    this.setValue(i, (Object)CDORevisionData.NIL);
                    break;
                }
                default: {
                    Object value;
                    if (feature.isMany()) {
                        value = in.readCDOList(owner, feature);
                    } else {
                        value = in.readCDOFeatureValue(feature);
                        if (TRACER.isEnabled()) {
                            TRACER.format("Read feature {0}: {1}", new Object[]{feature.getName(), value});
                        }
                    }
                    this.setValue(i, value);
                }
            }
            ++i;
        }
    }

    public static void checkNoFeatureMap(EStructuralFeature feature) {
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
            throw new UnsupportedOperationException("Single-valued feature maps not yet handled");
        }
    }

    public static Object remapID(Object value, Map<CDOID, CDOID> idMappings, boolean allowUnmappedTempIDs) {
        CDOID oldID;
        if (value instanceof CDOID && !(oldID = (CDOID)value).isNull()) {
            CDOID newID = idMappings.get(oldID);
            if (newID != null) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Adjusting ID: {0} --> {1}", new Object[]{oldID, newID});
                }
                return newID;
            }
            if (oldID instanceof CDOIDTemp) {
                throw new IllegalStateException(MessageFormat.format(Messages.getString("AbstractCDORevision.2"), oldID));
            }
        }
        return value;
    }
}

