/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.codegen.actions;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.dawn.codegen.dawngenmodel.DawnGMFGenerator;
import org.eclipse.emf.cdo.dawn.codegen.dawngenmodel.DawngenmodelFactory;
import org.eclipse.emf.cdo.dawn.codegen.util.ProjectCreationHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GenerateDawnGenModelAction
implements IObjectActionDelegate {
    private IResource selectedElement;
    public static final String dawngenmodelFileExtension = "dawngenmodel";
    private final String generalPrefix = "Dawn";

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            window.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Generate Dawn Code", 1000);
                    IFile gmfGen = (IFile)GenerateDawnGenModelAction.this.selectedElement;
                    String gmfGenModelFile = gmfGen.getRawLocationURI().toString();
                    String path = gmfGenModelFile.replace(gmfGen.getName(), "");
                    String modelname = gmfGen.getName().replace(".gmfgen", "");
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("gmfgen", new XMIResourceFactoryImpl());
                    resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("genmodel", new XMIResourceFactoryImpl());
                    resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(GenerateDawnGenModelAction.dawngenmodelFileExtension, new XMIResourceFactoryImpl());
                    URI gmfGenModelResourceUri = URI.createURI((String)gmfGenModelFile);
                    Resource gmfGenModelResource = resourceSet.getResource(gmfGenModelResourceUri, true);
                    String dawnGenModelResourcePath = String.valueOf(path) + modelname + "." + GenerateDawnGenModelAction.dawngenmodelFileExtension;
                    Resource dawnGenModelResource = resourceSet.createResource(URI.createURI((String)dawnGenModelResourcePath));
                    GenEditorGenerator editorGenerator = (GenEditorGenerator)gmfGenModelResource.getContents().get(0);
                    DawnGMFGenerator dawnGMFGenerator = DawngenmodelFactory.eINSTANCE.createDawnGMFGenerator();
                    String dawnEditorClassName = GenerateDawnGenModelAction.this.getDawnEditorClassName(editorGenerator);
                    dawnGMFGenerator.setDawnEditorClassName(dawnEditorClassName);
                    dawnGMFGenerator.setFragmentName(String.valueOf(editorGenerator.getPlugin().getID()) + ".dawn");
                    dawnGMFGenerator.setDawnCanonicalEditingPolicyClassName("Dawn" + editorGenerator.getDiagram().getCanonicalEditPolicyClassName());
                    dawnGMFGenerator.setDawnCreationWizardClassName("Dawn" + editorGenerator.getDiagram().getCreationWizardClassName());
                    dawnGMFGenerator.setDawnDiagramEditPartClassName("Dawn" + editorGenerator.getDiagram().getEditPartClassName());
                    dawnGMFGenerator.setDawnDocumentProviderClassName("Dawn" + editorGenerator.getDiagram().getDocumentProviderClassName());
                    dawnGMFGenerator.setDawnEditorUtilClassName("Dawn" + editorGenerator.getDiagram().getDiagramEditorUtilClassName());
                    dawnGMFGenerator.setDawnEditPartFactoryClassName("Dawn" + editorGenerator.getDiagram().getEditPartFactoryClassName());
                    dawnGMFGenerator.setDawnEditPartProviderClassName("Dawn" + editorGenerator.getDiagram().getEditPartProviderClassName());
                    dawnGMFGenerator.setDawnEditPolicyProviderClassName("Dawn" + editorGenerator.getDiagram().getEditPartProviderClassName().replace("EditPart", "EditPolicy"));
                    dawnGMFGenerator.setGMFGenEditorGenerator(editorGenerator);
                    dawnGenModelResource.getContents().add((Object)dawnGMFGenerator);
                    try {
                        dawnGenModelResource.save(Collections.EMPTY_MAP);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ProjectCreationHelper.refreshProject(null, monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private String getDawnEditorClassName(GenEditorGenerator editorGenerator) {
        String dawnEditorClassName = editorGenerator.getEditor().getClassName();
        if (dawnEditorClassName == null || dawnEditorClassName.equals("")) {
            dawnEditorClassName = "Dawn" + editorGenerator.getDomainGenModel() + "DiagramEditor";
        }
        dawnEditorClassName = "Dawn" + dawnEditorClassName;
        return dawnEditorClassName;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object sel;
        if (selection instanceof IStructuredSelection && (sel = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            this.selectedElement = (IResource)sel;
        }
    }
}

