/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.codegen.creators.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.dawn.codegen.creators.Creator;
import org.eclipse.emf.cdo.dawn.codegen.dawngenmodel.DawnGMFGenerator;
import org.eclipse.emf.cdo.dawn.codegen.util.ProjectCreationHelper;
import org.eclipse.emf.cdo.dawn.codegen.util.Utils;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.mwe.core.WorkflowRunner;
import org.eclipse.emf.mwe.core.monitor.NullProgressMonitor;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;

public class GMFFragmentCreator
implements Creator {
    private final IResource selectedElement;
    private final String PLUGIN_NATURE = "org.eclipse.pde.PluginNature";
    private final String JAVA_NATURE = "org.eclipse.jdt.core.javanature";

    public GMFFragmentCreator(IResource selectedElement) {
        this.selectedElement = selectedElement;
    }

    public void create(IProgressMonitor monitor) {
        IFile dawnGenModelFile = (IFile)this.selectedElement;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("dawngenmodel", new XMIResourceFactoryImpl());
        Resource dawnGenModelResource = resourceSet.getResource(URI.createURI((String)dawnGenModelFile.getRawLocationURI().toString()), true);
        DawnGMFGenerator dawnGMFGenerator = (DawnGMFGenerator)dawnGenModelResource.getContents().get(0);
        monitor.subTask("Create client fragment's basic structure");
        String[] natures = new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature"};
        ProjectCreationHelper projectCreationHelper = new ProjectCreationHelper();
        projectCreationHelper.setName(dawnGMFGenerator.getFragmentName());
        projectCreationHelper.setNatures(natures);
        try {
            IProject project = projectCreationHelper.createProject();
            projectCreationHelper.createJavaProject(project);
            monitor.worked(100);
            monitor.subTask("Creating folder structure...");
            projectCreationHelper.createFolder("lib", project);
            projectCreationHelper.createFolder("META-INF", project);
            projectCreationHelper.createFolder("icons", project);
            monitor.worked(100);
            monitor.subTask("Creating generic content...");
            this.createGenericContent(monitor, project.getLocation());
            ProjectCreationHelper.refreshProject((IResource)project, monitor);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        monitor.worked(100);
    }

    private void createGenericContent(IProgressMonitor monitor, IPath location) {
        IFile file = (IFile)this.selectedElement;
        HashMap<String, String> properties = new HashMap<String, String>();
        HashMap slotMap = new HashMap();
        try {
            String dawnGenFile = file.getRawLocationURI().toString();
            IFile dawnGen = (IFile)this.selectedElement;
            IProject hostProject = dawnGen.getProject();
            Utils.setPackage(hostProject.getName());
            String ouputFolder = location.toFile().getAbsoluteFile().toString();
            properties.put("model", dawnGenFile);
            properties.put("src-gen", ouputFolder);
            URL workFlowURL = this.getClass().getClassLoader().getResource("/workflow/gmfFragmentGenerator.oaw");
            WorkflowRunner workflowRunner = new WorkflowRunner();
            String workflow = FileLocator.toFileURL((URL)workFlowURL).getFile();
            workflowRunner.run(workflow, (ProgressMonitor)new NullProgressMonitor(), properties, slotMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

