/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.ui.wizards;

import java.util.Date;
import org.eclipse.emf.cdo.dawn.ui.views.DawnWizardPageItemProvider;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DawnCreateNewResourceWizardPage
extends WizardPage {
    public static int VALIDATION_NONE = 0;
    public static int VALIDATION_WARN = 1;
    public static int VALIDATION_ERROR = 2;
    protected Text resourcePathText;
    protected Text resourceText;
    private Composite container;
    private TreeViewer viewer;
    private ContainerItemProvider<IContainer<Object>> itemProvider;
    private boolean showResources;
    private final String fileExtension;
    private String resourceNamePrefix = "default";
    private final CDOView view;
    private boolean createAutomaticResourceName;
    private int resourceValidationType = VALIDATION_ERROR;

    public DawnCreateNewResourceWizardPage(String fileExtension) {
        this(fileExtension, true, null);
    }

    public DawnCreateNewResourceWizardPage(String fileExtension, boolean showResources, CDOView view) {
        super("First Page");
        this.view = view;
        this.setTitle("Create a Dawn Resource");
        this.setDescription("Creates Dawn Resource");
        this.showResources = showResources;
        this.fileExtension = fileExtension;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 1;
        this.createResourcePathInput();
        this.itemProvider = this.createContainerItemProvider();
        this.viewer = new TreeViewer(this.container, 2818);
        this.viewer.setContentProvider(this.createContentProvider());
        this.viewer.setLabelProvider(this.createLabelProvider());
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.setInput((Object)this.getManagedContainer());
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof CDOResource) {
                    return DawnCreateNewResourceWizardPage.this.showResources;
                }
                return true;
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    DawnCreateNewResourceWizardPage.this.resourceText.setText("");
                    return;
                }
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Object element = selection.getFirstElement();
                    if (element instanceof CDOResource) {
                        String resourceName = ((CDOResource)element).getName();
                        DawnCreateNewResourceWizardPage.this.resourcePathText.setText(((CDOResource)element).getPath().replace(resourceName, ""));
                        DawnCreateNewResourceWizardPage.this.resourceText.setText(resourceName);
                    } else if (element instanceof CDOResourceNode) {
                        DawnCreateNewResourceWizardPage.this.resourcePathText.setText(((CDOResourceNode)element).getPath());
                    }
                }
                DawnCreateNewResourceWizardPage.this.validatePage();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "org.mftech.examples.ui.rcp.views.viewer");
        this.createResourceInput();
        if (this.createAutomaticResourceName) {
            this.createAutomaticResourceName(this.fileExtension, this.view);
        }
        this.setControl((Control)this.container);
        this.validatePage();
    }

    private void createResourceInput() {
        Label label1 = new Label(this.container, 0);
        label1.setText("File name: ");
        this.resourceText = new Text(this.container, 2052);
        this.resourceText.setText(String.valueOf(this.getDefaultName()) + "." + this.fileExtension);
        this.resourceText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                DawnCreateNewResourceWizardPage.this.validatePage();
            }
        });
        GridData gd = new GridData(768);
        this.resourceText.setLayoutData((Object)gd);
    }

    private GridData createResourcePathInput() {
        Label resourcePathLabel = new Label(this.container, 0);
        resourcePathLabel.setText("Enter or select the parent folder: ");
        this.resourcePathText = new Text(this.container, 2052);
        this.resourcePathText.setText("");
        this.resourcePathText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                DawnCreateNewResourceWizardPage.this.validatePage();
            }
        });
        GridData gd = new GridData(768);
        this.resourcePathText.setLayoutData((Object)gd);
        return gd;
    }

    private void validatePage() {
        boolean valid = false;
        if (this.resourceText.getText().length() != 0) {
            this.setPageComplete(true);
            valid = true;
        } else {
            this.setErrorMessage("Please insert a name for the resource");
            valid = false;
        }
        if (this.view != null && this.resourceValidationType != VALIDATION_NONE) {
            try {
                if (this.view.hasResource(this.getURI().path())) {
                    String newMessage = "A resource with the same name already exists!";
                    if (this.resourceValidationType == VALIDATION_WARN) {
                        this.setMessage(newMessage, 2);
                        valid = true;
                    } else if (this.resourceValidationType == VALIDATION_ERROR) {
                        this.setErrorMessage("A resource with the same name already exists!");
                        valid = false;
                    }
                }
            }
            catch (Exception e) {
                this.setErrorMessage(e.getMessage());
            }
        }
        if (valid) {
            this.setErrorMessage(null);
        }
        this.setPageComplete(valid);
    }

    protected ContainerItemProvider<IContainer<Object>> createContainerItemProvider() {
        return new DawnWizardPageItemProvider(new IElementFilter(){

            public boolean filter(Object element) {
                return element instanceof CDOSession;
            }
        });
    }

    protected IBaseLabelProvider createLabelProvider() {
        ILabelDecorator labelDecorator = this.createLabelDecorator();
        return new DecoratingLabelProvider(this.itemProvider, labelDecorator);
    }

    protected IContentProvider createContentProvider() {
        return this.itemProvider;
    }

    protected ILabelDecorator createLabelDecorator() {
        return PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
    }

    protected IManagedContainer getManagedContainer() {
        return IPluginContainer.INSTANCE;
    }

    public URI getURI() {
        return URI.createURI((String)("cdo://" + this.resourcePathText.getText() + "/" + this.resourceText.getText()));
    }

    public void setShowResources(boolean showResources) {
        this.showResources = showResources;
    }

    public boolean isShowResources() {
        return this.showResources;
    }

    public String getDefaultName() {
        return this.getResourceNamePrefix();
    }

    public void setResourceNamePrefix(String resourceNamePrefix) {
        this.resourceNamePrefix = resourceNamePrefix;
        this.resourceText.setText(resourceNamePrefix);
    }

    public String getResourceNamePrefix() {
        return this.resourceNamePrefix;
    }

    public void setResourcePath(String resourcePathText) {
        if (!resourcePathText.endsWith("/") || resourcePathText.endsWith("\\")) {
            resourcePathText = String.valueOf(resourcePathText) + "/";
        }
        this.resourcePathText.setText(resourcePathText);
    }

    public String getResourcePath() {
        return this.resourcePathText.getText();
    }

    public void setCreateAutomaticResourceName(boolean createAutomaticResourceName) {
        this.createAutomaticResourceName = createAutomaticResourceName;
    }

    public boolean isCreateAutomaticResourceName() {
        return this.createAutomaticResourceName;
    }

    private void createAutomaticResourceName(String fileExtension, CDOView view) {
        int i = 2;
        while (i < 30 && view.hasResource(this.getURI().path())) {
            this.resourceText.setText(String.valueOf(this.resourceNamePrefix) + i + "." + fileExtension);
            ++i;
        }
        if (i < 30) {
            return;
        }
        this.resourceText.setText(String.valueOf(this.resourceNamePrefix) + new Date().getTime() + "." + fileExtension);
    }

    public void setResourceValidationType(int resourceValidationType) {
        this.resourceValidationType = resourceValidationType;
    }

    public int getResourceValidationType() {
        return this.resourceValidationType;
    }
}

