/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.notifications;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.dawn.synchronize.DawnConflictHelper;
import org.eclipse.emf.cdo.dawn.util.DawnDiagramUpdater;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.InvalidObjectException;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.swt.widgets.Display;

public class BasicDawnListener
implements IListener {
    protected DiagramDocumentEditor editor;

    public void setEditor(DiagramDocumentEditor editor) {
        this.editor = editor;
    }

    public BasicDawnListener() {
    }

    public BasicDawnListener(DiagramDocumentEditor editor) {
        this.editor = editor;
    }

    public void notifyEvent(IEvent event) {
        if (event instanceof CDOViewInvalidationEvent) {
            CDOViewInvalidationEvent e = (CDOViewInvalidationEvent)event;
            for (CDOObject object : e.getDirtyObjects()) {
                System.out.println("Dirty: " + object);
            }
            for (CDOObject object : e.getDetachedObjects()) {
                System.out.println("Dirty: " + object);
            }
        } else {
            System.out.println("Unhandeled Event: " + event);
        }
    }

    public static void adjustDeletedEdges(final CDOViewInvalidationEvent e) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                for (CDOObject obj : e.getDetachedObjects()) {
                    EObject view = CDOUtil.getEObject((EObject)obj);
                    if (!(view instanceof Edge)) continue;
                    try {
                        ((Edge)view).setTarget(null);
                    }
                    catch (InvalidObjectException invalidObjectException) {
                        // empty catch block
                    }
                    try {
                        ((Edge)view).setSource(null);
                    }
                    catch (InvalidObjectException invalidObjectException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    protected void handleConflicts(CDOViewInvalidationEvent e) {
        for (CDOObject obj : e.getDetachedObjects()) {
            EObject element = CDOUtil.getEObject((EObject)obj);
            View view = DawnDiagramUpdater.findViewByContainer((EObject)element);
            DawnConflictHelper.handleConflictedView(CDOUtil.getCDOObject((EObject)element), view, this.editor);
        }
    }
}

