/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.notifications;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.dawn.notifications.BasicDawnListener;
import org.eclipse.emf.cdo.dawn.synchronize.DawnConflictHelper;
import org.eclipse.emf.cdo.dawn.util.DawnDiagramUpdater;
import org.eclipse.emf.cdo.internal.dawn.bundle.OM;
import org.eclipse.emf.cdo.transaction.CDOTransactionConflictEvent;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class DawnGMFTransactionListener
extends BasicDawnListener {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DawnGMFTransactionListener.class);

    public DawnGMFTransactionListener() {
    }

    public DawnGMFTransactionListener(DiagramDocumentEditor editor) {
        super(editor);
    }

    public void notifyEvent(IEvent event) {
        if (event instanceof CDOViewInvalidationEvent) {
            CDOViewInvalidationEvent e = (CDOViewInvalidationEvent)event;
            if (TRACER.isEnabled()) {
                TRACER.format("Detached Objects {0} ", new Object[]{e.getDetachedObjects()});
                TRACER.format("Dirty Objects {0} ", new Object[]{e.getDirtyObjects()});
            }
            DawnGMFTransactionListener.adjustDeletedEdges(e);
            for (CDOObject dirtyObject : e.getDirtyObjects()) {
                this.handleObject(dirtyObject);
            }
            for (CDOObject detachedObject : e.getDetachedObjects()) {
                this.handleObject(detachedObject);
            }
        } else if (event instanceof CDOTransactionConflictEvent) {
            CDOTransactionConflictEvent cdoTransactionConflictEvent = (CDOTransactionConflictEvent)event;
            CDOObject cdoObject = cdoTransactionConflictEvent.getConflictingObject();
            EObject element = CDOUtil.getEObject((EObject)cdoObject);
            View view = DawnDiagramUpdater.findView((EObject)element);
            if (DawnConflictHelper.isConflicted((EObject)cdoObject)) {
                DawnConflictHelper.handleConflictedView(cdoObject, view, this.editor);
                return;
            }
        } else if (TRACER.isEnabled()) {
            TRACER.format("Unhandled Event: {0} ", new Object[]{event});
        }
    }

    private void handleObject(CDOObject dirtyObject) {
        EObject element = CDOUtil.getEObject((EObject)dirtyObject);
        View view = DawnDiagramUpdater.findView((EObject)element);
        if (DawnConflictHelper.isConflicted((EObject)dirtyObject)) {
            return;
        }
        EditPart relatedEditPart = DawnDiagramUpdater.findEditPart((View)view, (EditPartViewer)this.editor.getDiagramEditPart().getViewer());
        if (relatedEditPart != null) {
            if (TRACER.isEnabled()) {
                TRACER.format("Updating EditPart {0} ", new Object[]{relatedEditPart});
            }
            DawnDiagramUpdater.refreshEditPart((EditPart)relatedEditPart.getParent(), (DiagramDocumentEditor)this.editor);
        } else {
            if (TRACER.isEnabled()) {
                TRACER.format("Updating DiagramEditPart {0} ", new Object[]{this.editor.getDiagramEditPart()});
            }
            DawnDiagramUpdater.refreshEditPart((EditPart)this.editor.getDiagramEditPart(), (DiagramDocumentEditor)this.editor);
        }
    }
}

