/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.notifications;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.dawn.notifications.AbstractDawnResoureChangeListener;
import org.eclipse.emf.cdo.dawn.notifications.BasicDawnListener;
import org.eclipse.emf.cdo.dawn.notifications.DawnResoureChangeListener;
import org.eclipse.emf.cdo.internal.dawn.bundle.OM;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class DawnNotificationRegistry {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DawnNotificationRegistry.class);
    private static final String DAWN_RECOURCELISTENERS_ID = "org.eclipse.emf.cdo.dawn.listeners";

    public static AbstractDawnResoureChangeListener createDawnResoureChangeListener(DiagramDocumentEditor editor) {
        AbstractDawnResoureChangeListener listener = null;
        try {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(DAWN_RECOURCELISTENERS_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("class");
                if (o instanceof AbstractDawnResoureChangeListener) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("Registering AbstractDawnResoureChangeListener {0} ", new Object[]{o});
                    }
                    listener = (AbstractDawnResoureChangeListener)((Object)o);
                    listener.setEditor(editor);
                    return listener;
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (listener == null) {
            if (TRACER.isEnabled()) {
                TRACER.trace("No AbstractDawnResoureChangeListener found in regsitry. Creating defaul listener.");
            }
            listener = new DawnResoureChangeListener(editor);
        }
        return listener;
    }

    public static BasicDawnListener createDawnTransactionListener(DiagramDocumentEditor editor) {
        BasicDawnListener listener = null;
        try {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(DAWN_RECOURCELISTENERS_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("class");
                if (o instanceof BasicDawnListener) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("Registering TransactionListener  {0} ", new Object[]{o});
                    }
                    listener = (BasicDawnListener)o;
                    listener.setEditor(editor);
                    return listener;
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (listener == null) {
            if (TRACER.isEnabled()) {
                TRACER.trace("No TransactionListener found in regsitry. Creating default listener.");
            }
            listener = new BasicDawnListener(editor);
        }
        return listener;
    }
}

