/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.notifications;

import java.util.ArrayList;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditor;
import org.eclipse.emf.cdo.dawn.notifications.BasicDawnListener;
import org.eclipse.emf.cdo.dawn.notifications.DawnNotificationRegistry;
import org.eclipse.emf.cdo.dawn.notifications.DawnTransactionHandler;
import org.eclipse.emf.cdo.internal.dawn.bundle.OM;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler;
import org.eclipse.emf.cdo.view.CDOAdapterPolicy;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.impl.TransactionChangeRecorder;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class DawnNotificationUtil {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DawnNotificationUtil.class);

    public static void removeTransactionChangeRecorder(Notifier notifier) {
        ArrayList<Adapter> changeRecorders = new ArrayList<Adapter>();
        for (Adapter adapter : notifier.eAdapters()) {
            if (!(adapter instanceof TransactionChangeRecorder)) continue;
            changeRecorders.add(adapter);
        }
        if (changeRecorders.size() > 0) {
            if (TRACER.isEnabled()) {
                TRACER.format("Removing Change Recorder on e {0} ", new Object[]{notifier});
            }
            notifier.eAdapters().removeAll(changeRecorders);
        }
    }

    public static void registerResourceListeners(ResourceSet resourceSet, DiagramDocumentEditor editor) {
    }

    public static void registerTransactionListeners(CDOTransaction transaction, IDawnEditor editor) {
        BasicDawnListener transactionListener = DawnNotificationRegistry.createDawnTransactionListener((DiagramDocumentEditor)editor);
        transaction.addListener((IListener)transactionListener);
        transaction.addTransactionHandler((CDOTransactionHandler)new DawnTransactionHandler(editor));
    }

    public static void setChangeSubscriptionPolicy(CDOTransaction transaction) {
        transaction.options().addChangeSubscriptionPolicy(CDOAdapterPolicy.CDO);
    }

    public static void registerModelListeners(Diagram diagram, DiagramDocumentEditor editor) {
    }
}

