/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.notifications;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.dawn.notifications.AbstractDawnResoureChangeListener;
import org.eclipse.emf.cdo.dawn.synchronize.DawnConflictHelper;
import org.eclipse.emf.cdo.dawn.util.DawnDiagramUpdater;
import org.eclipse.emf.cdo.internal.dawn.bundle.OM;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.AbstractDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class DawnResoureChangeListener
extends AbstractDawnResoureChangeListener {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DawnResoureChangeListener.class);

    public DawnResoureChangeListener() {
    }

    public DawnResoureChangeListener(DiagramDocumentEditor editor) {
        super(editor);
    }

    public void notifyChanged(Notification notification) {
        CDOTransaction transaction;
        CDOObject cdoObject;
        CDOView cdoView;
        if (TRACER.isEnabled()) {
            TRACER.format("DawnResoureChangeListener fired. {0} ", new Object[]{notification});
        }
        if (notification.getOldValue() instanceof DawnResoureChangeListener) {
            if (TRACER.isEnabled()) {
                TRACER.trace("No notification for ArrayDelegatingAdapterList");
            }
            return;
        }
        super.notifyChanged(notification);
        if (TRACER.isEnabled()) {
            TRACER.format("Changing feature {0} ", new Object[]{notification.getFeature()});
            TRACER.format("\t-OLD {0} ", new Object[]{notification.getOldValue()});
            TRACER.format("\t-NEW {0} ", new Object[]{notification.getNewValue()});
        }
        if (!((cdoView = (cdoObject = CDOUtil.getCDOObject((EObject)((EObject)notification.getNotifier()))).cdoView()) instanceof CDOTransaction)) {
            return;
        }
        if (cdoView instanceof CDOTransaction && (transaction = (CDOTransaction)cdoView).isClosed()) {
            return;
        }
        EObject element = CDOUtil.getEObject((EObject)cdoObject);
        View view = DawnDiagramUpdater.findViewByContainer((EObject)element);
        if (view == null) {
            view = DawnDiagramUpdater.findViewForModel((EObject)element, (DiagramDocumentEditor)this.editor);
        }
        DawnConflictHelper.handleConflictedView(cdoObject, view, this.editor);
        EditPart relatedEditPart = DawnDiagramUpdater.findEditPart((View)view, (EditPartViewer)this.editor.getDiagramEditPart().getViewer());
        if (relatedEditPart != null) {
            if (TRACER.isEnabled()) {
                TRACER.format("Updating EditPart {0} ", new Object[]{relatedEditPart});
            }
            DawnDiagramUpdater.refreshEditPart((EditPart)relatedEditPart.getParent(), (DiagramDocumentEditor)this.editor);
        } else {
            if (TRACER.isEnabled()) {
                TRACER.format("Updating DiagramEditPart {0} ", new Object[]{this.editor.getDiagramEditPart()});
            }
            DawnDiagramUpdater.refreshEditPart((EditPart)this.editor.getDiagramEditPart(), (DiagramDocumentEditor)this.editor);
        }
        ((AbstractDocumentProvider)this.editor.getDocumentProvider()).changed((Object)this.editor.getEditorInput());
    }
}

