/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.notifications;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditor;
import org.eclipse.emf.cdo.dawn.notifications.DawnElementChangeListener;
import org.eclipse.emf.cdo.dawn.util.DawnDiagramUpdater;
import org.eclipse.emf.cdo.internal.dawn.bundle.OM;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class DawnTransactionHandler
implements CDOTransactionHandler {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DawnElementChangeListener.class);
    private final IDawnEditor editor;

    public DawnTransactionHandler(IDawnEditor editor) {
        this.editor = editor;
    }

    public void attachingObject(CDOTransaction transaction, CDOObject object) {
        if (TRACER.isEnabled()) {
            TRACER.format("attachingObject {0}", new Object[]{object});
        }
        this.refresh(object);
        this.editor.setDirty();
    }

    public void detachingObject(CDOTransaction transaction, CDOObject object) {
        if (TRACER.isEnabled()) {
            TRACER.format("detachingObject {0}", new Object[]{object});
        }
        this.editor.setDirty();
    }

    public void modifyingObject(CDOTransaction transaction, final CDOObject object, CDOFeatureDelta featureDelta) {
        if (TRACER.isEnabled()) {
            TRACER.format("modifyingObject {0}", new Object[]{object});
        }
        this.refresh(object);
        this.editor.setDirty();
        object.eAdapters().add((Object)new Adapter(){

            public void setTarget(Notifier newTarget) {
            }

            public void notifyChanged(Notification notification) {
                DawnDiagramUpdater.refreshEditPart((EditPart)((DiagramDocumentEditor)DawnTransactionHandler.this.editor).getDiagramEditPart(), (DiagramDocumentEditor)((DiagramDocumentEditor)DawnTransactionHandler.this.editor));
                object.eAdapters().remove((Object)this);
            }

            public boolean isAdapterForType(Object type) {
                return false;
            }

            public Notifier getTarget() {
                return null;
            }
        });
    }

    private void refresh(CDOObject object) {
        EditPart relatedEditPart;
        View view = DawnDiagramUpdater.findViewByContainer((EObject)object);
        if (view == null) {
            view = DawnDiagramUpdater.findViewForModel((EObject)object, (DiagramDocumentEditor)((DiagramDocumentEditor)this.editor));
        }
        if (view == null) {
            DawnDiagramUpdater.findViewFromCrossReferences((EObject)object);
        }
        if ((relatedEditPart = DawnDiagramUpdater.findEditPart((View)view, (EditPartViewer)((DiagramDocumentEditor)this.editor).getDiagramEditPart().getViewer())) != null) {
            EditPart parent;
            if (TRACER.isEnabled()) {
                TRACER.format("Updating EditPart {0} ", new Object[]{relatedEditPart});
            }
            if ((parent = relatedEditPart.getParent()) instanceof IGraphicalEditPart) {
                DawnDiagramUpdater.refresh((IGraphicalEditPart)((IGraphicalEditPart)parent));
            } else {
                DawnDiagramUpdater.refreshEditPart((EditPart)parent, (DiagramDocumentEditor)((DiagramDocumentEditor)this.editor));
            }
        } else {
            if (TRACER.isEnabled()) {
                TRACER.format("Updating DiagramEditPart {0} ", new Object[]{((DiagramDocumentEditor)this.editor).getDiagramEditPart()});
            }
            DawnDiagramUpdater.refresh((IGraphicalEditPart)((DiagramDocumentEditor)this.editor).getDiagramEditPart());
        }
    }

    public void committingTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
        if (TRACER.isEnabled()) {
            TRACER.format("committingTransaction", new Object[0]);
        }
    }

    public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
        if (TRACER.isEnabled()) {
            TRACER.format("committedTransaction", new Object[0]);
        }
    }

    public void rolledBackTransaction(CDOTransaction transaction) {
        if (TRACER.isEnabled()) {
            TRACER.format("rolledBackTransaction", new Object[0]);
        }
    }
}

