/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j;

import java.util.Set;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.util.CDOTimeProvider;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageRegistryImpl;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisionManagerImpl;
import org.eclipse.emf.cdo.internal.net4j.CDONet4jSessionImpl;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.net4j.CDOSession;
import org.eclipse.emf.cdo.net4j.CDOSessionConfiguration;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOCommitInfoUtil;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.internal.cdo.session.CDOSessionConfigurationImpl;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.signal.failover.IFailOverStrategy;
import org.eclipse.net4j.signal.failover.NOOPFailOverStrategy;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.io.IStreamWrapper;

public class CDONet4jSessionConfigurationImpl
extends CDOSessionConfigurationImpl
implements CDOSessionConfiguration {
    private String repositoryName;
    private IConnector connector;
    private IFailOverStrategy failOverStrategy;
    private IStreamWrapper streamWrapper;
    private InternalCDOBranchManager branchManager;
    private InternalCDOPackageRegistry packageRegistry;
    private InternalCDORevisionManager revisionManager;
    private InternalCDOCommitInfoManager commitInfoManager;

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.checkNotOpen();
        this.repositoryName = repositoryName;
    }

    public IConnector getConnector() {
        return this.connector;
    }

    public void setConnector(IConnector connector) {
        this.checkNotOpen();
        this.connector = connector;
    }

    public IFailOverStrategy getFailOverStrategy() {
        return this.failOverStrategy;
    }

    public void setFailOverStrategy(IFailOverStrategy failOverStrategy) {
        this.checkNotOpen();
        this.failOverStrategy = failOverStrategy;
    }

    public IStreamWrapper getStreamWrapper() {
        return this.streamWrapper;
    }

    public void setStreamWrapper(IStreamWrapper streamWrapper) {
        this.checkNotOpen();
        this.streamWrapper = streamWrapper;
    }

    public InternalCDOBranchManager getBranchManager() {
        return this.branchManager;
    }

    public void setBranchManager(CDOBranchManager branchManager) {
        this.checkNotOpen();
        this.branchManager = (InternalCDOBranchManager)branchManager;
    }

    public InternalCDOPackageRegistry getPackageRegistry() {
        return this.packageRegistry;
    }

    public void setPackageRegistry(CDOPackageRegistry packageRegistry) {
        this.checkNotOpen();
        this.packageRegistry = (InternalCDOPackageRegistry)packageRegistry;
    }

    public InternalCDORevisionManager getRevisionManager() {
        return this.revisionManager;
    }

    public void setRevisionManager(CDORevisionManager revisionManager) {
        this.checkNotOpen();
        this.revisionManager = (InternalCDORevisionManager)revisionManager;
    }

    public InternalCDOCommitInfoManager getCommitInfoManager() {
        return this.commitInfoManager;
    }

    public void setCommitInfoManager(CDOCommitInfoManager commitInfoManager) {
        this.checkNotOpen();
        this.commitInfoManager = (InternalCDOCommitInfoManager)commitInfoManager;
    }

    public CDOSession openSession() {
        return (CDOSession)super.openSession();
    }

    public InternalCDOSession createSession() {
        if (this.isActivateOnOpen()) {
            CheckUtil.checkState((boolean)(this.connector != null ^ this.failOverStrategy != null), (String)"Specify exactly one of connector or failOverStrategy");
        }
        return new CDONet4jSessionImpl(this);
    }

    public void activateSession(InternalCDOSession session) throws Exception {
        super.activateSession(session);
        CDOClientProtocol protocol = new CDOClientProtocol();
        protocol.setInfraStructure(session);
        if (this.streamWrapper != null) {
            protocol.setStreamWrapper(this.streamWrapper);
        }
        session.setSessionProtocol((CDOSessionProtocol)protocol);
        if (this.connector != null) {
            protocol.setFailOverStrategy((IFailOverStrategy)new NOOPFailOverStrategy(this.connector));
        } else if (this.failOverStrategy != null) {
            protocol.setFailOverStrategy(this.failOverStrategy);
        }
        CDOSessionProtocol.OpenSessionResult result = protocol.openSession(this.repositoryName, this.isPassiveUpdateEnabled(), this.getPassiveUpdateMode());
        session.setSessionID(result.getSessionID());
        session.setUserID(result.getUserID());
        session.setLastUpdateTime(result.getLastUpdateTime());
        session.setRepositoryInfo((CDORepositoryInfo)new RepositoryInfo(this.repositoryName, result));
        if (this.packageRegistry == null) {
            this.packageRegistry = new CDOPackageRegistryImpl();
        }
        this.packageRegistry.setPackageProcessor((InternalCDOPackageRegistry.PackageProcessor)session);
        this.packageRegistry.setPackageLoader((InternalCDOPackageRegistry.PackageLoader)session);
        this.packageRegistry.activate();
        if (this.revisionManager == null) {
            this.revisionManager = new CDORevisionManagerImpl();
        }
        this.revisionManager.setSupportingBranches(session.getRepositoryInfo().isSupportingBranches());
        this.revisionManager.setRevisionLoader((InternalCDORevisionManager.RevisionLoader)session.getSessionProtocol());
        this.revisionManager.setRevisionLocker((InternalCDORevisionManager.RevisionLocker)session);
        this.revisionManager.activate();
        if (this.branchManager == null) {
            this.branchManager = CDOBranchUtil.createBranchManager();
        }
        this.branchManager.setBranchLoader((InternalCDOBranchManager.BranchLoader)session.getSessionProtocol());
        this.branchManager.setTimeProvider((CDOTimeProvider)session.getRepositoryInfo());
        this.branchManager.initMainBranch(session.getRepositoryInfo().getCreationTime());
        this.branchManager.activate();
        if (this.commitInfoManager == null) {
            this.commitInfoManager = CDOCommitInfoUtil.createCommitInfoManager();
        }
        this.commitInfoManager.setCommitInfoLoader((InternalCDOCommitInfoManager.CommitInfoLoader)session.getSessionProtocol());
        this.commitInfoManager.activate();
        for (InternalCDOPackageUnit packageUnit : result.getPackageUnits()) {
            if (EcorePackage.eINSTANCE.getNsURI().equals(packageUnit.getID())) {
                EMFUtil.addAdapter((Notifier)EcorePackage.eINSTANCE, (Adapter)packageUnit.getTopLevelPackageInfo());
                packageUnit.setState(CDOPackageUnit.State.LOADED);
            } else if (EresourcePackage.eINSTANCE.getNsURI().equals(packageUnit.getID())) {
                EMFUtil.addAdapter((Notifier)EresourcePackage.eINSTANCE, (Adapter)packageUnit.getTopLevelPackageInfo());
                packageUnit.setState(CDOPackageUnit.State.LOADED);
            }
            this.getPackageRegistry().putPackageUnit(packageUnit);
        }
    }

    public void deactivateSession(InternalCDOSession session) throws Exception {
        this.commitInfoManager.deactivate();
        this.revisionManager.deactivate();
        super.deactivateSession(session);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RepositoryInfo
    implements CDORepositoryInfo {
        private String name;
        private String uuid;
        private CDOCommonRepository.Type type;
        private CDOCommonRepository.State state;
        private String storeType;
        private Set<CDOID.ObjectType> objectIDTypes;
        private long creationTime;
        private CDOSessionProtocol.RepositoryTimeResult timeResult;
        private CDOID rootResourceID;
        private boolean supportingAudits;
        private boolean supportingBranches;
        private boolean ensuringReferentialIntegrity;

        public RepositoryInfo(String name, CDOSessionProtocol.OpenSessionResult result) {
            this.name = name;
            this.uuid = result.getRepositoryUUID();
            this.type = result.getRepositoryType();
            this.state = result.getRepositoryState();
            this.storeType = result.getStoreType();
            this.objectIDTypes = result.getObjectIDTypes();
            this.creationTime = result.getRepositoryCreationTime();
            this.timeResult = result.getRepositoryTimeResult();
            this.rootResourceID = result.getRootResourceID();
            this.supportingAudits = result.isRepositorySupportingAudits();
            this.supportingBranches = result.isRepositorySupportingBranches();
            this.ensuringReferentialIntegrity = result.isRepositoryEnsuringReferentialIntegrity();
        }

        public String getName() {
            return this.name;
        }

        public String getUUID() {
            return this.uuid;
        }

        public CDOCommonRepository.Type getType() {
            return this.type;
        }

        public void setType(CDOCommonRepository.Type type) {
            this.type = type;
        }

        public CDOCommonRepository.State getState() {
            return this.state;
        }

        public void setState(CDOCommonRepository.State state) {
            this.state = state;
        }

        public String getStoreType() {
            return this.storeType;
        }

        public Set<CDOID.ObjectType> getObjectIDTypes() {
            return this.objectIDTypes;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public long getTimeStamp() {
            return this.getTimeStamp(false);
        }

        public long getTimeStamp(boolean forceRefresh) {
            if (this.timeResult == null || forceRefresh) {
                this.timeResult = this.refreshTime();
            }
            return this.timeResult.getAproximateRepositoryTime();
        }

        public CDOID getRootResourceID() {
            return this.rootResourceID;
        }

        public boolean isSupportingAudits() {
            return this.supportingAudits;
        }

        public boolean isSupportingBranches() {
            return this.supportingBranches;
        }

        public boolean isEnsuringReferentialIntegrity() {
            return this.ensuringReferentialIntegrity;
        }

        private CDOSessionProtocol.RepositoryTimeResult refreshTime() {
            return CDONet4jSessionConfigurationImpl.this.getSession().getSessionProtocol().getRepositoryTime();
        }
    }
}

