/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.internal.net4j.CDONet4jSessionImpl;
import org.eclipse.emf.cdo.internal.net4j.messages.Messages;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.signal.failover.IFailOverStrategy;
import org.eclipse.net4j.signal.failover.NOOPFailOverStrategy;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IElementProcessor;
import org.eclipse.net4j.util.container.IManagedContainer;

public class FailOverStrategyInjector
implements IElementProcessor {
    private static final String INVALID_URI_MESSAGE = Messages.getString("InvalidURIException.0");
    private static final String SCHEME_SEPARATOR = "://";

    public Object process(IManagedContainer container, String productGroup, String factoryType, String description, Object element) {
        if (element instanceof CDONet4jSessionImpl) {
            CDONet4jSessionImpl session = (CDONet4jSessionImpl)element;
            IFailOverStrategy failOverStrategy = this.getFailOverStrategy(container, description);
            session.getConfiguration().setFailOverStrategy(failOverStrategy);
        }
        return element;
    }

    protected IFailOverStrategy getFailOverStrategy(IManagedContainer container, String description) {
        IConnector connector = this.getConnector(container, description);
        return new NOOPFailOverStrategy(connector);
    }

    protected IConnector getConnector(IManagedContainer container, String description) {
        int pos = description.indexOf(SCHEME_SEPARATOR);
        if (pos == -1) {
            throw new IllegalArgumentException(MessageFormat.format(INVALID_URI_MESSAGE, description, Messages.getString("FailOverStrategyInjector.0")));
        }
        String factoryType = description.substring(0, pos);
        if (StringUtil.isEmpty((String)factoryType)) {
            throw new IllegalArgumentException(MessageFormat.format(INVALID_URI_MESSAGE, description, Messages.getString("FailOverStrategyInjector.1")));
        }
        String connectorDescription = description.substring(pos + SCHEME_SEPARATOR.length());
        if (StringUtil.isEmpty((String)connectorDescription)) {
            throw new IllegalArgumentException(MessageFormat.format(INVALID_URI_MESSAGE, description, Messages.getString("FailOverStrategyInjector.2")));
        }
        pos = connectorDescription.indexOf(63);
        if (pos != -1) {
            connectorDescription = connectorDescription.substring(0, pos);
        }
        return (IConnector)container.getElement("org.eclipse.net4j.connectors", factoryType, connectorDescription);
    }
}

