/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.spi.cdo.InternalCDOObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeViewRequest
extends CDOClientRequest<boolean[]> {
    private int viewID;
    private CDOBranchPoint branchPoint;
    private List<InternalCDOObject> invalidObjects;

    public ChangeViewRequest(CDOClientProtocol protocol, int viewID, CDOBranchPoint branchPoint, List<InternalCDOObject> invalidObjects) {
        super(protocol, (short)4);
        this.viewID = viewID;
        this.branchPoint = branchPoint;
        this.invalidObjects = invalidObjects;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeInt(this.viewID);
        out.writeCDOBranchPoint(this.branchPoint);
        out.writeInt(this.invalidObjects.size());
        for (InternalCDOObject object : this.invalidObjects) {
            out.writeCDOID(object.cdoID());
        }
    }

    @Override
    protected boolean[] confirming(CDODataInput in) throws IOException {
        int size = in.readInt();
        boolean[] existanceFlags = new boolean[size];
        int i = 0;
        while (i < size) {
            boolean existanceFlag;
            existanceFlags[i] = existanceFlag = in.readBoolean();
            ++i;
        }
        return existanceFlags;
    }
}

