/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.internal.common.protocol.CDODataInputImpl;
import org.eclipse.emf.cdo.internal.common.protocol.CDODataOutputImpl;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.net4j.CDOSession;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.internal.cdo.revision.CDOListWithElementProxiesImpl;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.signal.RequestWithMonitoring;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.StringIO;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitTransactionRequest
extends RequestWithMonitoring<CDOSessionProtocol.CommitTransactionResult> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, CommitTransactionRequest.class);
    private CDOIDProvider idProvider;
    private int transactionID;
    private String comment;
    private boolean releaseLocks;
    private CDOCommitData commitData;

    public CommitTransactionRequest(CDOClientProtocol protocol, int transactionID, String comment, boolean releaseLocks, CDOIDProvider idProvider, CDOCommitData commitData) {
        this(protocol, 11, transactionID, comment, releaseLocks, idProvider, commitData);
    }

    public CommitTransactionRequest(CDOClientProtocol protocol, short signalID, int transactionID, String comment, boolean releaseLocks, CDOIDProvider idProvider, CDOCommitData commitData) {
        super((SignalProtocol)protocol, signalID);
        this.transactionID = transactionID;
        this.comment = comment;
        this.releaseLocks = releaseLocks;
        this.idProvider = idProvider;
        this.commitData = commitData;
    }

    public CDOClientProtocol getProtocol() {
        return (CDOClientProtocol)super.getProtocol();
    }

    protected InternalCDOSession getSession() {
        return (InternalCDOSession)this.getProtocol().getSession();
    }

    protected CDOIDProvider getIDProvider() {
        return this.idProvider;
    }

    protected final void requesting(ExtendedDataOutputStream out, OMMonitor monitor) throws Exception {
        this.requesting((CDODataOutput)new CDODataOutputImpl((ExtendedDataOutput)out){

            public CDOPackageRegistry getPackageRegistry() {
                return CommitTransactionRequest.this.getSession().getPackageRegistry();
            }

            public CDOIDProvider getIDProvider() {
                return CommitTransactionRequest.this.getIDProvider();
            }

            protected StringIO getPackageURICompressor() {
                return CommitTransactionRequest.this.getProtocol().getPackageURICompressor();
            }
        }, monitor);
    }

    protected void requesting(CDODataOutput out, OMMonitor monitor) throws IOException {
        this.requestingTransactionInfo(out);
        this.requestingCommit(out);
    }

    protected void requestingTransactionInfo(CDODataOutput out) throws IOException {
        out.writeInt(this.transactionID);
    }

    protected void requestingCommit(CDODataOutput out) throws IOException {
        List newPackageUnits = this.commitData.getNewPackageUnits();
        List newObjects = this.commitData.getNewObjects();
        List changedObjects = this.commitData.getChangedObjects();
        List detachedObjects = this.commitData.getDetachedObjects();
        out.writeBoolean(this.releaseLocks);
        out.writeString(this.comment);
        out.writeInt(newPackageUnits.size());
        out.writeInt(newObjects.size());
        out.writeInt(changedObjects.size());
        out.writeInt(detachedObjects.size());
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} new package units", new Object[]{newPackageUnits.size()});
        }
        for (CDOPackageUnit newPackageUnit : newPackageUnits) {
            out.writeCDOPackageUnit(newPackageUnit, true);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} new objects", new Object[]{newObjects.size()});
        }
        for (CDOIDAndVersion newObject : newObjects) {
            out.writeCDORevision((CDORevision)newObject, -1);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} dirty objects", new Object[]{changedObjects.size()});
        }
        for (CDORevisionKey changedObject : changedObjects) {
            out.writeCDORevisionDelta((CDORevisionDelta)changedObject);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} detached objects", new Object[]{detachedObjects.size()});
        }
        CDOTransaction transaction = null;
        boolean ensuringReferentialIntegrity = this.getSession().getRepositoryInfo().isEnsuringReferentialIntegrity();
        if (ensuringReferentialIntegrity) {
            transaction = (CDOTransaction)this.getSession().getView(this.transactionID);
        }
        for (CDOIDAndVersion detachedObject : detachedObjects) {
            CDOID id = detachedObject.getID();
            out.writeCDOID(id);
            if (!ensuringReferentialIntegrity) continue;
            CDOObject object = transaction.getObject(id);
            EClass eClass = object.eClass();
            out.writeCDOClassifierRef((EClassifier)eClass);
        }
    }

    protected final CDOSessionProtocol.CommitTransactionResult confirming(ExtendedDataInputStream in, OMMonitor monitor) throws Exception {
        return this.confirming((CDODataInput)new CDODataInputImpl((ExtendedDataInput)in){

            protected StringIO getPackageURICompressor() {
                return CommitTransactionRequest.this.getProtocol().getPackageURICompressor();
            }

            protected CDOPackageRegistry getPackageRegistry() {
                return CommitTransactionRequest.this.getSession().getPackageRegistry();
            }

            protected CDOBranchManager getBranchManager() {
                return CommitTransactionRequest.this.getSession().getBranchManager();
            }

            protected CDOCommitInfoManager getCommitInfoManager() {
                return CommitTransactionRequest.this.getSession().getCommitInfoManager();
            }

            protected CDORevisionFactory getRevisionFactory() {
                return CommitTransactionRequest.this.getSession().getRevisionManager().getFactory();
            }

            protected CDOListFactory getListFactory() {
                return CDOListWithElementProxiesImpl.FACTORY;
            }
        }, monitor);
    }

    protected CDOSessionProtocol.CommitTransactionResult confirming(CDODataInput in, OMMonitor monitor) throws IOException {
        CDOSessionProtocol.CommitTransactionResult result = this.confirmingCheckError(in);
        if (result != null) {
            return result;
        }
        result = this.confirmingResult(in);
        this.confirmingMappingNewPackages(in, result);
        this.confirmingMappingNewObjects(in, result);
        return result;
    }

    protected CDOSessionProtocol.CommitTransactionResult confirmingCheckError(CDODataInput in) throws IOException {
        boolean success = in.readBoolean();
        if (!success) {
            String rollbackMessage = in.readString();
            OM.LOG.error(rollbackMessage);
            return new CDOSessionProtocol.CommitTransactionResult(this.idProvider, rollbackMessage);
        }
        return null;
    }

    protected CDOSessionProtocol.CommitTransactionResult confirmingResult(CDODataInput in) throws IOException {
        CDOBranchPoint branchPoint = in.readCDOBranchPoint();
        return new CDOSessionProtocol.CommitTransactionResult(this.idProvider, branchPoint);
    }

    protected void confirmingMappingNewPackages(CDODataInput in, CDOSessionProtocol.CommitTransactionResult result) throws IOException {
        InternalCDOPackageRegistry.MetaInstanceMapper metaInstanceMapper = this.getSession().getPackageRegistry().getMetaInstanceMapper();
        for (CDOPackageUnit newPackageUnit : this.commitData.getNewPackageUnits()) {
            CDOPackageInfo[] cDOPackageInfoArray = newPackageUnit.getPackageInfos();
            int n = cDOPackageInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOPackageInfo packageInfo = cDOPackageInfoArray[n2];
                CDOIDMetaRange oldRange = packageInfo.getMetaIDRange();
                CDOIDMetaRange newRange = in.readCDOIDMetaRange();
                ((InternalCDOPackageInfo)packageInfo).setMetaIDRange(newRange);
                int i = 0;
                while (i < oldRange.size()) {
                    CDOIDTemp oldID = (CDOIDTemp)oldRange.get(i);
                    CDOID newID = newRange.get(i);
                    result.addIDMapping((CDOID)oldID, newID);
                    this.remapMetaInstanceID(metaInstanceMapper, oldID, newID);
                    ++i;
                }
                ++n2;
            }
        }
    }

    protected void remapMetaInstanceID(InternalCDOPackageRegistry.MetaInstanceMapper metaInstanceMapper, CDOIDTemp oldID, CDOID newID) {
        metaInstanceMapper.remapMetaInstanceID((CDOID)oldID, newID);
    }

    protected void confirmingMappingNewObjects(CDODataInput in, CDOSessionProtocol.CommitTransactionResult result) throws IOException {
        CDOID id;
        while (!CDOIDUtil.isNull((CDOID)(id = in.readCDOID()))) {
            if (id instanceof CDOIDTemp) {
                CDOIDTemp oldID = (CDOIDTemp)id;
                CDOID newID = in.readCDOID();
                result.addIDMapping((CDOID)oldID, newID);
                continue;
            }
            throw new ClassCastException("Not a temporary ID: " + id);
        }
    }

    protected int getMonitorProgressSeconds() {
        CDOSession session = (CDOSession)this.getSession();
        return session.options().getProgressInterval();
    }

    protected int getMonitorTimeoutSeconds() {
        CDOSession session = (CDOSession)this.getSession();
        return session.options().getCommitTimeout();
    }
}

