/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSession;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSessionManager;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetRemoteSessionsRequest
extends CDOClientRequest<List<CDORemoteSession>> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, GetRemoteSessionsRequest.class);
    private boolean subscribe;

    public GetRemoteSessionsRequest(CDOClientProtocol protocol, boolean subscribe) {
        super(protocol, (short)27);
        this.subscribe = subscribe;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing subscribe: {0}", new Object[]{this.subscribe});
        }
        out.writeBoolean(this.subscribe);
    }

    @Override
    protected List<CDORemoteSession> confirming(CDODataInput in) throws IOException {
        int sessionID;
        ArrayList<CDORemoteSession> result = new ArrayList<CDORemoteSession>();
        while ((sessionID = in.readInt()) != -1) {
            String userID = in.readString();
            boolean subscribed = in.readBoolean();
            InternalCDORemoteSessionManager manager = this.getSession().getRemoteSessionManager();
            InternalCDORemoteSession remoteSession = manager.createRemoteSession(sessionID, userID, subscribed);
            result.add((CDORemoteSession)remoteSession);
        }
        return result;
    }
}

