/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.spi.common.commit.CDORevisionAvailabilityInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadMergeDataRequest
extends CDOClientRequest<Set<CDOID>> {
    private CDORevisionAvailabilityInfo ancestorInfo;
    private CDORevisionAvailabilityInfo targetInfo;
    private CDORevisionAvailabilityInfo sourceInfo;

    public LoadMergeDataRequest(CDOClientProtocol protocol, CDORevisionAvailabilityInfo ancestorInfo, CDORevisionAvailabilityInfo targetInfo, CDORevisionAvailabilityInfo sourceInfo) {
        super(protocol, (short)44);
        this.ancestorInfo = ancestorInfo;
        this.targetInfo = targetInfo;
        this.sourceInfo = sourceInfo;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        this.writeRevisionAvailabilityInfo(out, this.ancestorInfo);
        this.writeRevisionAvailabilityInfo(out, this.targetInfo);
        this.writeRevisionAvailabilityInfo(out, this.sourceInfo);
    }

    private void writeRevisionAvailabilityInfo(CDODataOutput out, CDORevisionAvailabilityInfo info) throws IOException {
        out.writeCDOBranchPoint(info.getBranchPoint());
        Set availableRevisions = info.getAvailableRevisions().keySet();
        out.writeInt(availableRevisions.size());
        for (CDOID id : availableRevisions) {
            out.writeCDOID(id);
        }
    }

    @Override
    protected Set<CDOID> confirming(CDODataInput in) throws IOException {
        HashSet<CDOID> result = new HashSet<CDOID>();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            CDOID id = in.readCDOID();
            result.add(id);
            ++i;
        }
        this.readRevisionAvailabilityInfo(in, this.ancestorInfo, result);
        this.readRevisionAvailabilityInfo(in, this.targetInfo, result);
        this.readRevisionAvailabilityInfo(in, this.sourceInfo, result);
        return result;
    }

    private void readRevisionAvailabilityInfo(CDODataInput in, CDORevisionAvailabilityInfo info, Set<CDOID> result) throws IOException {
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            CDORevision revision;
            if (in.readBoolean()) {
                revision = in.readCDORevision();
            } else {
                CDORevisionKey key = in.readCDORevisionKey();
                revision = this.getRevision(key, this.ancestorInfo);
                if (revision == null) {
                    revision = this.getRevision(key, this.targetInfo);
                }
            }
            info.addRevision((CDORevisionKey)revision);
            ++i;
        }
        Set entrySet = info.getAvailableRevisions().entrySet();
        Iterator it = entrySet.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (result.contains(entry.getKey())) continue;
            it.remove();
        }
    }

    private CDORevision getRevision(CDORevisionKey key, CDORevisionAvailabilityInfo info) {
        CDORevision revision = info.getRevision(key.getID());
        if (revision instanceof CDORevision && key.equals(revision)) {
            return revision;
        }
        return null;
    }
}

