/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.util.CDOFetchRule;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.RevisionInfo;
import org.eclipse.emf.cdo.view.CDOFetchRuleManager;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadRevisionsRequest
extends CDOClientRequest<List<InternalCDORevision>> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, LoadRevisionsRequest.class);
    private List<RevisionInfo> infos;
    private CDOBranchPoint branchPoint;
    private int referenceChunk;
    private int prefetchDepth;

    public LoadRevisionsRequest(CDOClientProtocol protocol, List<RevisionInfo> infos, CDOBranchPoint branchPoint, int referenceChunk, int prefetchDepth) {
        super(protocol, (short)7);
        this.infos = infos;
        this.branchPoint = branchPoint;
        this.referenceChunk = referenceChunk;
        this.prefetchDepth = prefetchDepth;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing branchPoint: {0}", new Object[]{this.branchPoint});
        }
        out.writeCDOBranchPoint(this.branchPoint);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing referenceChunk: {0}", new Object[]{this.referenceChunk});
        }
        out.writeInt(this.referenceChunk);
        int size = this.infos.size();
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} infos", new Object[]{size});
        }
        if (this.prefetchDepth == 0) {
            out.writeInt(size);
        } else {
            out.writeInt(-size);
            if (TRACER.isEnabled()) {
                TRACER.format("Writing prefetchDepth: {0}", new Object[]{this.prefetchDepth});
            }
            out.writeInt(this.prefetchDepth);
        }
        ArrayList<CDOID> ids = new ArrayList<CDOID>(size);
        for (RevisionInfo info : this.infos) {
            if (TRACER.isEnabled()) {
                TRACER.format("Writing info: {0}", new Object[]{info});
            }
            info.write(out);
            ids.add(info.getID());
        }
        CDOFetchRuleManager ruleManager = this.getSession().getFetchRuleManager();
        List fetchRules = ruleManager.getFetchRules(ids);
        if (fetchRules == null || fetchRules.size() <= 0) {
            out.writeInt(0);
        } else {
            int fetchSize = fetchRules.size();
            CDOID contextID = ruleManager.getContext();
            out.writeInt(fetchSize);
            out.writeInt(ruleManager.getCollectionLoadingPolicy().getInitialChunkSize());
            out.writeCDOID(contextID);
            for (CDOFetchRule fetchRule : fetchRules) {
                fetchRule.write(out);
            }
        }
    }

    @Override
    protected List<InternalCDORevision> confirming(CDODataInput in) throws IOException {
        int size = this.infos.size();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading {0} revisions", new Object[]{size});
        }
        for (RevisionInfo info : this.infos) {
            info.readResult(in);
        }
        ArrayList<InternalCDORevision> additionalRevisions = null;
        int additionalSize = in.readInt();
        if (additionalSize != 0) {
            if (TRACER.isEnabled()) {
                TRACER.format("Reading {0} additional revisions", new Object[]{additionalSize});
            }
            additionalRevisions = new ArrayList<InternalCDORevision>(additionalSize);
            int i = 0;
            while (i < additionalSize) {
                InternalCDORevision revision = (InternalCDORevision)in.readCDORevision();
                additionalRevisions.add(revision);
                ++i;
            }
        }
        return additionalRevisions;
    }

    public String toString() {
        return MessageFormat.format("LoadRevisionsRequest(infos={0}, branchPoint={1}, referenceChunk={2}, prefetchDepth={3})", this.infos, this.branchPoint, this.referenceChunk, this.prefetchDepth);
    }
}

