/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.HashSet;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOTimeRequest;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSessionRequest
extends CDOTimeRequest<CDOSessionProtocol.OpenSessionResult> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, OpenSessionRequest.class);
    private String repositoryName;
    private boolean passiveUpdateEnabled;
    private CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode;
    private CDOSessionProtocol.OpenSessionResult result;

    public OpenSessionRequest(CDOClientProtocol protocol, String repositoryName, boolean passiveUpdateEnabled, CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode) {
        super(protocol, (short)1);
        this.repositoryName = repositoryName;
        this.passiveUpdateEnabled = passiveUpdateEnabled;
        this.passiveUpdateMode = passiveUpdateMode;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        super.requesting(out);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing repositoryName: {0}", new Object[]{this.repositoryName});
        }
        out.writeString(this.repositoryName);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing passiveUpdateEnabled: {0}", new Object[]{this.passiveUpdateEnabled});
        }
        out.writeBoolean(this.passiveUpdateEnabled);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing passiveUpdateMode: {0}", new Object[]{this.passiveUpdateMode});
        }
        out.writeEnum((Enum)this.passiveUpdateMode);
    }

    @Override
    protected CDOSessionProtocol.OpenSessionResult confirming(CDODataInput in) throws IOException {
        int sessionID = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Read sessionID: {0}", new Object[]{sessionID});
        }
        String userID = in.readString();
        if (TRACER.isEnabled()) {
            TRACER.format("Read userID: {0}", new Object[]{userID});
        }
        String repositoryUUID = in.readString();
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositoryUUID: {0}", new Object[]{repositoryUUID});
        }
        CDOCommonRepository.Type repositoryType = (CDOCommonRepository.Type)in.readEnum(CDOCommonRepository.Type.class);
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositoryType: {0}", new Object[]{repositoryType});
        }
        CDOCommonRepository.State repositoryState = (CDOCommonRepository.State)in.readEnum(CDOCommonRepository.State.class);
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositoryState: {0}", new Object[]{repositoryState});
        }
        String storeType = in.readString();
        if (TRACER.isEnabled()) {
            TRACER.format("Read storeType: {0}", new Object[]{storeType});
        }
        HashSet<CDOID.ObjectType> objectIDTypes = new HashSet<CDOID.ObjectType>();
        int types = in.readInt();
        int i = 0;
        while (i < types) {
            CDOID.ObjectType objectIDType = (CDOID.ObjectType)in.readEnum(CDOID.ObjectType.class);
            if (TRACER.isEnabled()) {
                TRACER.format("Read objectIDType: {0}", new Object[]{objectIDType});
            }
            objectIDTypes.add(objectIDType);
            ++i;
        }
        long repositoryCreationTime = in.readLong();
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositoryCreationTime: {0}", new Object[]{CDOCommonUtil.formatTimeStamp((long)repositoryCreationTime)});
        }
        long lastUpdateTime = in.readLong();
        if (TRACER.isEnabled()) {
            TRACER.format("Read lastUpdateTime: {0}", new Object[]{CDOCommonUtil.formatTimeStamp((long)lastUpdateTime)});
        }
        CDOID rootResourceID = in.readCDOID();
        if (TRACER.isEnabled()) {
            TRACER.format("Read rootResourceID: {0}", new Object[]{rootResourceID});
        }
        boolean repositorySupportingAudits = in.readBoolean();
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositorySupportingAudits: {0}", new Object[]{repositorySupportingAudits});
        }
        boolean repositorySupportingBranches = in.readBoolean();
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositorySupportingBranches: {0}", new Object[]{repositorySupportingBranches});
        }
        boolean repositoryEnsuringReferentialIntegrity = in.readBoolean();
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositoryEnsuringReferentialIntegrity: {0}", new Object[]{repositoryEnsuringReferentialIntegrity});
        }
        this.result = new CDOSessionProtocol.OpenSessionResult(sessionID, userID, repositoryUUID, repositoryType, repositoryState, storeType, objectIDTypes, repositoryCreationTime, lastUpdateTime, rootResourceID, repositorySupportingAudits, repositorySupportingBranches);
        this.result.setRepositoryEnsuringReferentialIntegrity(repositoryEnsuringReferentialIntegrity);
        CDOPackageUnit[] packageUnits = in.readCDOPackageUnits(null);
        int i2 = 0;
        while (i2 < packageUnits.length) {
            this.result.getPackageUnits().add((InternalCDOPackageUnit)packageUnits[i2]);
            ++i2;
        }
        super.confirming(in);
        this.result.setRepositoryTimeResult(this.getRepositoryTimeResult());
        return this.result;
    }
}

