/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.db;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.concurrent.Worker;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.ProductCreationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDODBBrowser
extends Worker {
    private static final String REQUEST_PREFIX = "GET ";
    private static final String REQUEST_SUFFIX = " HTTP/1.1";
    private ThreadLocal<Map<String, String>> params = new InheritableThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return new HashMap<String, String>();
        }
    };
    private int port = 7777;
    private ServerSocket serverSocket;
    private Map<String, InternalRepository> repositories;

    public CDODBBrowser(Map<String, InternalRepository> repositories) {
        this.repositories = repositories;
        this.setDaemon(true);
    }

    public Map<String, InternalRepository> getRepositories() {
        return this.repositories;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    protected void work(Worker.WorkContext context) throws Exception {
        Socket socket = null;
        try {
            socket = this.serverSocket.accept();
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
            PrintStream pout = new PrintStream(out);
            this.printHeader(pout);
            String line = in.readLine();
            if (line != null) {
                if (line.startsWith(REQUEST_PREFIX) && line.endsWith(REQUEST_SUFFIX)) {
                    String request;
                    String resource = request = line.substring(REQUEST_PREFIX.length(), line.length() - REQUEST_SUFFIX.length()).trim();
                    String params = "";
                    int pos = request.indexOf(63);
                    if (pos != -1) {
                        resource = request.substring(0, pos);
                        params = request.substring(pos + 1);
                    }
                    this.initParams(params);
                    if ("/".equals(resource)) {
                        this.showMenu(pout);
                    } else if ("/data".equals(resource)) {
                        this.showData(pout);
                    }
                }
                ((OutputStream)out).flush();
                return;
            }
        }
        catch (Exception ex) {
            if (this.isActive()) {
                ex.printStackTrace();
            }
        }
        finally {
            this.params.remove();
            if (socket != null) {
                socket.close();
            }
        }
    }

    protected void initParams(String params) {
        Map<String, String> map = this.params.get();
        String[] stringArray = params.split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            if (param.length() != 0) {
                String[] keyValue = param.split("=");
                map.put(keyValue[0], keyValue[1]);
            }
            ++n2;
        }
    }

    protected void clearParams() {
        Map<String, String> map = this.params.get();
        map.clear();
    }

    protected void removeParam(String key) {
        Map<String, String> map = this.params.get();
        map.remove(key);
    }

    protected String getParam(String key) {
        Map<String, String> map = this.params.get();
        return map.get(key);
    }

    protected String href(String label, String resource, String ... params) {
        HashMap<String, String> map = new HashMap<String, String>(this.params.get());
        int i = 0;
        while (i < params.length) {
            map.put(params[i++], params[i++]);
        }
        ArrayList list = new ArrayList(map.keySet());
        Collections.sort(list);
        StringBuilder builder = new StringBuilder();
        for (String key : list) {
            String value = (String)map.get(key);
            if (value == null) continue;
            if (builder.length() != 0) {
                builder.append("&");
            }
            builder.append(key);
            builder.append("=");
            builder.append(value);
        }
        return "<a href=\"/" + this.escape(resource) + "?" + this.escape(builder.toString()) + "\">" + this.escape(label) + "</a>";
    }

    protected String escape(String raw) {
        if (raw == null) {
            return "null";
        }
        return raw.replace("<", "&lt;");
    }

    protected void printHeader(PrintStream pout) {
        pout.print("HTTP/1.1 200 OK\r\n");
        pout.print("Content-Type: text/html\r\n");
        pout.print("Date: " + new Date() + "\r\n");
        pout.print("Server: DBBrowser 3.0\r\n");
        pout.print("\r\n");
    }

    protected void showMenu(PrintStream pout) {
        this.clearParams();
        pout.print("<h1>DBBrowser 3.0</h1>\r\n");
        Set<String> names = this.repositories.keySet();
        if (names.size() == 1) {
            String repo = names.iterator().next();
            pout.print("<h3>" + this.href("Show Data", "data", "repo", repo) + "</h3>");
        } else {
            pout.print("<h3><a href=\"/data\">Show Data</a></h3>");
        }
    }

    protected void showData(PrintStream pout) {
        InternalStore store;
        String repo = this.getParam("repo");
        String table = this.getParam("table");
        ArrayList<String> repoNames = new ArrayList<String>(this.repositories.keySet());
        Collections.sort(repoNames);
        pout.print("<h1>");
        for (String repoName : repoNames) {
            if (repoName.equals(repo)) {
                pout.print("<b>" + this.escape(repoName) + "</b>&nbsp;");
                continue;
            }
            pout.print(String.valueOf(this.href(repoName, "data", "repo", repoName)) + "&nbsp;");
        }
        pout.print("</h1>");
        InternalRepository repository = this.repositories.get(repo);
        if (repository != null && (store = repository.getStore()) instanceof IDBConnectionProvider) {
            IDBConnectionProvider connectionProvider = (IDBConnectionProvider)store;
            Connection connection = null;
            try {
                try {
                    connection = connectionProvider.getConnection();
                    pout.print("<p>\r\n");
                    pout.print("<table border=\"0\">\r\n");
                    pout.print("<tr>\r\n");
                    pout.print("<td valign=\"top\">\r\n");
                    this.showTables(pout, connection, repo);
                    pout.print("</td>\r\n");
                    if (table != null) {
                        pout.print("<td valign=\"top\">\r\n");
                        this.showTable(pout, connection);
                        pout.print("</td>\r\n");
                    }
                    pout.print("</tr>\r\n");
                    pout.print("</table>\r\n");
                }
                catch (DBException ex) {
                    ex.printStackTrace();
                    DBUtil.close((Connection)connection);
                }
            }
            finally {
                DBUtil.close((Connection)connection);
            }
        }
    }

    protected void showTables(PrintStream pout, Connection connection, String repo) {
        String table = this.getParam("table");
        List allTableNames = DBUtil.getAllTableNames((Connection)connection, (String)repo);
        for (String tableName : allTableNames) {
            String label = this.escape(tableName);
            if (tableName.equals(table)) {
                pout.print("<b>" + label + "</b><br>\r\n");
                continue;
            }
            pout.print(String.valueOf(this.href(label, "data", "table", tableName, "order", null, "direction", null)) + "<br>\r\n");
        }
    }

    protected void showTable(PrintStream pout, Connection connection) {
        String table = this.getParam("table");
        try {
            String order = this.getParam("order");
            this.executeQuery(pout, connection, "SELECT * FROM \"" + table + "\"" + (order == null ? "" : " ORDER BY " + order + " " + this.getParam("direction")));
        }
        catch (Exception ex) {
            this.removeParam("order");
            this.removeParam("direction");
            this.executeQuery(pout, connection, "SELECT * FROM " + table);
        }
    }

    protected void executeQuery(PrintStream pout, Connection connection, String sql) {
        block8: {
            String order = this.getParam("order");
            String direction = this.getParam("direction");
            Statement stmt = null;
            ResultSet resultSet = null;
            try {
                try {
                    stmt = connection.createStatement();
                    resultSet = stmt.executeQuery(sql);
                    ResultSetMetaData metaData = resultSet.getMetaData();
                    int columns = metaData.getColumnCount();
                    pout.print("<table border=\"1\" cellpadding=\"2\">\r\n");
                    pout.print("<tr>\r\n");
                    pout.print("<td>&nbsp;</td>\r\n");
                    int i = 0;
                    while (i < columns) {
                        String column = metaData.getColumnLabel(1 + i);
                        String dir = column.equals(order) && "ASC".equals(direction) ? "DESC" : "ASC";
                        pout.print("<td><b>" + this.href(column, "data", "order", column, "direction", dir) + "</b></td>\r\n");
                        ++i;
                    }
                    pout.print("</tr>\r\n");
                    int row = 0;
                    while (resultSet.next()) {
                        pout.print("<tr>\r\n");
                        pout.print("<td><b>" + ++row + "</b></td>\r\n");
                        int i2 = 0;
                        while (i2 < columns) {
                            pout.print("<td>" + this.escape(resultSet.getString(1 + i2)) + "</td>\r\n");
                            ++i2;
                        }
                        pout.print("</tr>\r\n");
                    }
                    pout.print("</table>\r\n");
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    DBUtil.close(resultSet);
                    DBUtil.close((Statement)stmt);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
        }
    }

    protected String getThreadName() {
        return "DBBrowser";
    }

    protected void doActivate() throws Exception {
        try {
            this.serverSocket = new ServerSocket(this.port);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not open socket on port " + this.port, ex);
        }
        super.doActivate();
    }

    protected void doDeactivate() throws Exception {
        this.serverSocket.close();
        super.doDeactivate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContainerBased
    extends CDODBBrowser {
        private IContainer<?> container;
        private IListener containerListener = new ContainerEventAdapter<Object>(){

            protected void onAdded(IContainer<Object> container, Object element) {
                ContainerBased.this.addElement(element);
            }

            protected void onRemoved(IContainer<Object> container, Object element) {
                ContainerBased.this.removeElement(element);
            }
        };

        public ContainerBased(IContainer<?> container) {
            super(new HashMap<String, InternalRepository>());
            this.container = container;
        }

        public ContainerBased() {
            this((IContainer<?>)IPluginContainer.INSTANCE);
        }

        public IContainer<?> getContainer() {
            return this.container;
        }

        @Override
        protected void doActivate() throws Exception {
            super.doActivate();
            Object[] objectArray = this.container.getElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.addElement(element);
                ++n2;
            }
            this.container.addListener(this.containerListener);
        }

        @Override
        protected void doDeactivate() throws Exception {
            this.container.removeListener(this.containerListener);
            super.doDeactivate();
        }

        private void addElement(Object element) {
            if (element instanceof InternalRepository) {
                InternalRepository repository = (InternalRepository)element;
                this.getRepositories().put(repository.getName(), repository);
            }
        }

        private void removeElement(Object element) {
            if (element instanceof InternalRepository) {
                InternalRepository repository = (InternalRepository)element;
                this.getRepositories().remove(repository.getName());
            }
        }

        public static class Factory
        extends org.eclipse.net4j.util.factory.Factory {
            public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.db.browsers";
            public static final String TYPE = "default";

            public Factory() {
                super(PRODUCT_GROUP, TYPE);
            }

            public ContainerBased create(String description) throws ProductCreationException {
                ContainerBased browser = new ContainerBased();
                try {
                    if (!StringUtil.isEmpty((String)description)) {
                        browser.setPort(Integer.valueOf(description));
                    }
                }
                catch (Exception ex) {
                    OM.LOG.warn((Throwable)ex);
                }
                return browser;
            }
        }
    }
}

