/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.db;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IExternalReferenceManager;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.SmartPreparedStatementCache;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalAuditMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalBranchingMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalNonAuditMappingStrategy;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.WrappedException;

public final class CDODBUtil {
    public static final int DEFAULT_STATEMENT_CACHE_CAPACITY = 200;
    public static final String EXT_POINT_MAPPING_STRATEGIES = "mappingStrategies";

    private CDODBUtil() {
    }

    public static IDBStore createStore(IMappingStrategy mappingStrategy, IDBAdapter dbAdapter, IDBConnectionProvider dbConnectionProvider) {
        DBStore store = new DBStore();
        store.setMappingStrategy(mappingStrategy);
        store.setDBAdapter(dbAdapter);
        store.setDbConnectionProvider(dbConnectionProvider);
        mappingStrategy.setStore(store);
        return store;
    }

    public static IMappingStrategy createHorizontalMappingStrategy(boolean auditing) {
        if (auditing) {
            return new HorizontalAuditMappingStrategy();
        }
        return new HorizontalNonAuditMappingStrategy();
    }

    public static IMappingStrategy createHorizontalMappingStrategy(boolean auditing, boolean branching) {
        if (branching) {
            if (auditing) {
                return new HorizontalBranchingMappingStrategy();
            }
            throw new IllegalArgumentException("Misconfiguration: Branching requires Auditing!");
        }
        return CDODBUtil.createHorizontalMappingStrategy(auditing);
    }

    public static IMappingStrategy createMappingStrategy(String type) {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.emf.cdo.server.db", EXT_POINT_MAPPING_STRATEGIES);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String typeAttr;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("mappingStrategy".equals(element.getName()) && ObjectUtil.equals((Object)(typeAttr = element.getAttribute("type")), (Object)type)) {
                try {
                    return (IMappingStrategy)element.createExecutableExtension("class");
                }
                catch (CoreException ex) {
                    throw WrappedException.wrap((Exception)((Object)ex));
                }
            }
            ++n2;
        }
        return null;
    }

    public static long convertCDOIDToLong(IExternalReferenceManager manager, IDBStoreAccessor accessor, CDOID id, long commitTime) {
        if (id.getType() == CDOID.Type.EXTERNAL_OBJECT) {
            return manager.mapExternalReference(accessor, (CDOIDExternal)id, commitTime);
        }
        return CDOIDUtil.getLong((CDOID)id);
    }

    public static CDOID convertLongToCDOID(IExternalReferenceManager manager, IDBStoreAccessor accessor, long id) {
        if (id < DBStore.NULL) {
            return manager.unmapExternalReference(accessor, id);
        }
        return CDOIDUtil.createLong((long)id);
    }

    public static int sqlUpdate(PreparedStatement stmt, boolean exactlyOne) throws SQLException {
        DBUtil.trace((String)stmt.toString());
        int result = stmt.executeUpdate();
        if (exactlyOne && result != 1) {
            throw new IllegalStateException(String.valueOf(stmt.toString()) + " returned Update count " + result + " (expected: 1)");
        }
        if (result == -3) {
            throw new IllegalStateException(String.valueOf(stmt.toString()) + " returned EXECUTE_FAILED");
        }
        return result;
    }

    public static IPreparedStatementCache createStatementCache() {
        return CDODBUtil.createStatementCache(200);
    }

    public static IPreparedStatementCache createStatementCache(int capacity) {
        return new SmartPreparedStatementCache(capacity);
    }
}

