/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.cache.CDORevisionCacheAdder;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IMetaDataManager;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingAuditSupport;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.CDODBSchema;
import org.eclipse.emf.cdo.server.internal.db.DBRevisionHandler;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.DBStoreChunkReader;
import org.eclipse.emf.cdo.server.internal.db.SQLQueryHandler;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.AbstractMappingStrategy;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.LongIDStoreAccessor;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBStoreAccessor
extends LongIDStoreAccessor
implements IDBStoreAccessor {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DBStoreAccessor.class);
    private Connection connection;
    private ConnectionKeepAliveTask connectionKeepAliveTask;
    private IPreparedStatementCache statementCache;
    private Set<CDOID> newObjects = new HashSet<CDOID>();

    public DBStoreAccessor(DBStore store, ISession session) throws DBException {
        super((Store)store, session);
    }

    public DBStoreAccessor(DBStore store, ITransaction transaction) throws DBException {
        super((Store)store, transaction);
    }

    @Override
    public DBStore getStore() {
        return (DBStore)super.getStore();
    }

    @Override
    public IPreparedStatementCache getStatementCache() {
        return this.statementCache;
    }

    public DBStoreChunkReader createChunkReader(InternalCDORevision revision, EStructuralFeature feature) {
        return new DBStoreChunkReader(this, (CDORevision)revision, feature);
    }

    @Deprecated
    public CloseableIterator<CDOID> readObjectIDs() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Selecting object IDs");
        }
        return this.getStore().getMappingStrategy().readObjectIDs(this);
    }

    public CDOClassifierRef readObjectType(CDOID id) {
        if (TRACER.isEnabled()) {
            TRACER.format("Selecting object type: {0}", new Object[]{id});
        }
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        return mappingStrategy.readObjectType(this, id);
    }

    protected EClass getObjectType(CDOID id) {
        InternalRepository repository = this.getStore().getRepository();
        if (repository.getRootResourceID().equals(id)) {
            return EresourcePackage.Literals.CDO_RESOURCE;
        }
        EClass result = repository.getRevisionManager().getObjectType(id);
        if (result != null) {
            return result;
        }
        CDOClassifierRef type = this.readObjectType(id);
        if (type != null) {
            CDOPackageRegistry packageRegistry = repository.getPackageRegistry();
            return (EClass)type.resolve((EPackage.Registry)packageRegistry);
        }
        throw new IllegalStateException("No type found for " + id);
    }

    @Override
    public boolean isNewObject(CDOID id) {
        return this.newObjects.contains(id);
    }

    public InternalCDORevision readRevision(CDOID id, CDOBranchPoint branchPoint, int listChunk, CDORevisionCacheAdder cache) {
        if (TRACER.isEnabled()) {
            TRACER.format("Selecting revision {0} from {1}", new Object[]{id, branchPoint});
        }
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        EClass eClass = this.getObjectType(id);
        InternalCDORevision revision = this.getStore().createRevision(eClass, id);
        revision.setBranchPoint(branchPoint);
        IClassMapping mapping = mappingStrategy.getClassMapping(eClass);
        if (mapping.readRevision(this, revision, listChunk)) {
            int version = revision.getVersion();
            if (version < 0) {
                return new DetachedCDORevision(eClass, id, revision.getBranch(), -version, revision.getTimeStamp(), revision.getRevised());
            }
            return revision;
        }
        return null;
    }

    public InternalCDORevision readRevisionByVersion(CDOID id, CDOBranchVersion branchVersion, int listChunk, CDORevisionCacheAdder cache) {
        DBStore store = this.getStore();
        EClass eClass = this.getObjectType(id);
        IMappingStrategy mappingStrategy = store.getMappingStrategy();
        IClassMapping mapping = mappingStrategy.getClassMapping(eClass);
        InternalCDORevision revision = store.createRevision(eClass, id);
        revision.setVersion(branchVersion.getVersion());
        revision.setBranchPoint(branchVersion.getBranch().getHead());
        boolean success = false;
        if (mappingStrategy.hasAuditSupport()) {
            if (TRACER.isEnabled()) {
                TRACER.format("Selecting revision {0} from {1}", new Object[]{id, branchVersion});
            }
            if ((success = ((IClassMappingAuditSupport)((Object)mapping)).readRevisionByVersion(this, revision, listChunk)) && revision.getVersion() < 0) {
                revision = new DetachedCDORevision(eClass, id, revision.getBranch(), -revision.getVersion(), revision.getTimeStamp(), revision.getRevised());
            }
        } else {
            if (TRACER.isEnabled()) {
                TRACER.format("Selecting current base revision: {0}", new Object[]{id});
            }
            if ((success = mapping.readRevision(this, revision, listChunk)) && revision.getVersion() != branchVersion.getVersion()) {
                throw new IllegalStateException("Can only retrieve current version " + revision.getVersion() + " for " + id + " - version requested was " + branchVersion);
            }
        }
        return success ? revision : null;
    }

    public void queryResources(IStoreAccessor.QueryResourcesContext context) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        mappingStrategy.queryResources(this, context);
    }

    public void queryXRefs(IStoreAccessor.QueryXRefsContext context) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        mappingStrategy.queryXRefs(this, context);
    }

    public IQueryHandler getQueryHandler(CDOQueryInfo info) {
        if ("sql".equals(info.getQueryLanguage())) {
            return new SQLQueryHandler(this);
        }
        return null;
    }

    protected void applyIDMappings(InternalCommitContext context, OMMonitor monitor) {
        super.applyIDMappings(context, monitor);
        InternalCDORevision[] internalCDORevisionArray = context.getNewObjects();
        int n = internalCDORevisionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevision revision = internalCDORevisionArray[n2];
            CDOID id = revision.getID();
            this.newObjects.add(id);
            ++n2;
        }
    }

    protected void writeCommitInfo(CDOBranch branch, long timeStamp, String userID, String comment, OMMonitor monitor) {
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = this.statementCache.getPreparedStatement(CDODBSchema.SQL_CREATE_COMMIT_INFO, IPreparedStatementCache.ReuseProbability.HIGH);
                pstmt.setLong(1, timeStamp);
                pstmt.setInt(2, branch.getID());
                pstmt.setString(3, userID);
                pstmt.setString(4, comment);
                CDODBUtil.sqlUpdate(pstmt, true);
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            this.statementCache.releasePreparedStatement(pstmt);
            throw throwable;
        }
        this.statementCache.releasePreparedStatement(pstmt);
    }

    protected void writeRevisionDeltas(InternalCDORevisionDelta[] revisionDeltas, CDOBranch branch, long created, OMMonitor monitor) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        if (!mappingStrategy.hasDeltaSupport()) {
            throw new UnsupportedOperationException("Mapping strategy does not support revision deltas");
        }
        monitor.begin((double)revisionDeltas.length);
        try {
            InternalCDORevisionDelta[] internalCDORevisionDeltaArray = revisionDeltas;
            int n = revisionDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevisionDelta delta = internalCDORevisionDeltaArray[n2];
                this.writeRevisionDelta(delta, created, monitor.fork());
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void writeRevisionDelta(InternalCDORevisionDelta delta, long created, OMMonitor monitor) {
        EClass eClass = this.getObjectType(delta.getID());
        IClassMappingDeltaSupport mapping = (IClassMappingDeltaSupport)((Object)this.getStore().getMappingStrategy().getClassMapping(eClass));
        mapping.writeRevisionDelta(this, delta, created, monitor);
    }

    protected void writeRevisions(InternalCDORevision[] revisions, CDOBranch branch, OMMonitor monitor) {
        try {
            monitor.begin((double)revisions.length);
            InternalCDORevision[] internalCDORevisionArray = revisions;
            int n = revisions.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevision revision = internalCDORevisionArray[n2];
                this.writeRevision(revision, monitor.fork());
                ++n2;
            }
        }
        finally {
            this.newObjects.clear();
            monitor.done();
        }
    }

    protected void writeRevision(InternalCDORevision revision, OMMonitor monitor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing revision: {0}", new Object[]{revision});
        }
        EClass eClass = revision.getEClass();
        IClassMapping mapping = this.getStore().getMappingStrategy().getClassMapping(eClass);
        mapping.writeRevision(this, revision, monitor);
    }

    protected void detachObjects(CDOID[] detachedObjects, CDOBranch branch, long timeStamp, OMMonitor monitor) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        monitor.begin((double)detachedObjects.length);
        try {
            InternalCDORevisionManager revisionManager = this.getStore().getRepository().getRevisionManager();
            CDOID[] cDOIDArray = detachedObjects;
            int n = detachedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                int version;
                CDOID id = cDOIDArray[n2];
                InternalCDORevision revision = revisionManager.getRevision(id, branch.getHead(), -1, 0, true);
                int n3 = version = ObjectUtil.equals((Object)branch, (Object)revision.getBranch()) ? revision.getVersion() : 1;
                if (TRACER.isEnabled()) {
                    TRACER.format("Detaching object: {0}", new Object[]{id});
                }
                EClass eClass = this.getObjectType(id);
                IClassMapping mapping = mappingStrategy.getClassMapping(eClass);
                mapping.detachObject(this, id, version, branch, timeStamp, monitor.fork());
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    protected final void doCommit(OMMonitor monitor) {
        if (TRACER.isEnabled()) {
            TRACER.format("--- DB COMMIT ---", new Object[0]);
        }
        OMMonitor.Async async = null;
        monitor.begin();
        try {
            try {
                try {
                    async = monitor.forkAsync();
                    this.getConnection().commit();
                }
                finally {
                    if (async != null) {
                        async.stop();
                    }
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected final void rollback(IStoreAccessor.CommitContext commitContext) {
        if (TRACER.isEnabled()) {
            TRACER.format("--- DB ROLLBACK ---", new Object[0]);
        }
        try {
            this.getConnection().rollback();
            IMappingStrategy strategy = this.getStore().getMappingStrategy();
            ((AbstractMappingStrategy)strategy).removeMapping(this.getConnection(), commitContext.getNewPackageUnits());
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    protected void doActivate() throws Exception {
        this.connection = this.getStore().getConnection();
        this.connectionKeepAliveTask = new ConnectionKeepAliveTask();
        this.getStore().getConnectionKeepAliveTimer().schedule((TimerTask)this.connectionKeepAliveTask, 14400000L, 14400000L);
        this.statementCache = CDODBUtil.createStatementCache();
        this.statementCache.setConnection(this.connection);
        LifecycleUtil.activate((Object)this.statementCache);
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.statementCache);
        this.connectionKeepAliveTask.cancel();
        DBUtil.close((Connection)this.connection);
        this.connection = null;
    }

    protected void doPassivate() throws Exception {
        this.connection.rollback();
    }

    protected void doUnpassivate() throws Exception {
    }

    public EPackage[] loadPackageUnit(InternalCDOPackageUnit packageUnit) {
        return this.getStore().getMetaDataManager().loadPackageUnit(this.getConnection(), packageUnit);
    }

    public Collection<InternalCDOPackageUnit> readPackageUnits() {
        return this.getStore().getMetaDataManager().readPackageUnits(this.getConnection());
    }

    public void writePackageUnits(InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        monitor.begin(2.0);
        try {
            DBStore store = this.getStore();
            Connection connection = this.getConnection();
            IMetaDataManager metaDataManager = store.getMetaDataManager();
            metaDataManager.writePackageUnits(connection, packageUnits, monitor.fork());
            IMappingStrategy mappingStrategy = store.getMappingStrategy();
            mappingStrategy.createMapping(connection, packageUnits, monitor.fork());
        }
        finally {
            monitor.done();
        }
    }

    public int createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        this.checkBranchingSupport();
        if (branchID == Integer.MAX_VALUE) {
            branchID = this.getStore().getNextBranchID();
        } else if (branchID == Integer.MIN_VALUE) {
            branchID = this.getStore().getNextLocalBranchID();
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = this.statementCache.getPreparedStatement(CDODBSchema.SQL_CREATE_BRANCH, IPreparedStatementCache.ReuseProbability.LOW);
            pstmt.setInt(1, branchID);
            pstmt.setString(2, branchInfo.getName());
            pstmt.setInt(3, branchInfo.getBaseBranchID());
            pstmt.setLong(4, branchInfo.getBaseTimeStamp());
            CDODBUtil.sqlUpdate(pstmt, true);
            this.getConnection().commit();
            int n = branchID;
            return n;
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        finally {
            this.statementCache.releasePreparedStatement(pstmt);
        }
    }

    public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo;
        this.checkBranchingSupport();
        PreparedStatement pstmt = null;
        ResultSet resultSet = null;
        try {
            pstmt = this.statementCache.getPreparedStatement(CDODBSchema.SQL_LOAD_BRANCH, IPreparedStatementCache.ReuseProbability.HIGH);
            pstmt.setInt(1, branchID);
            resultSet = pstmt.executeQuery();
            if (!resultSet.next()) {
                throw new DBException("Branch with ID " + branchID + " does not exist");
            }
            String name = resultSet.getString(1);
            int baseBranchID = resultSet.getInt(2);
            long baseTimeStamp = resultSet.getLong(3);
            branchInfo = new InternalCDOBranchManager.BranchLoader.BranchInfo(name, baseBranchID, baseTimeStamp);
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                this.statementCache.releasePreparedStatement(pstmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        this.statementCache.releasePreparedStatement(pstmt);
        return branchInfo;
    }

    public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int baseID) {
        InternalCDOBranchManager.BranchLoader.SubBranchInfo[] subBranchInfoArray;
        this.checkBranchingSupport();
        PreparedStatement pstmt = null;
        ResultSet resultSet = null;
        try {
            pstmt = this.statementCache.getPreparedStatement(CDODBSchema.SQL_LOAD_SUB_BRANCHES, IPreparedStatementCache.ReuseProbability.HIGH);
            pstmt.setInt(1, baseID);
            resultSet = pstmt.executeQuery();
            ArrayList<InternalCDOBranchManager.BranchLoader.SubBranchInfo> result = new ArrayList<InternalCDOBranchManager.BranchLoader.SubBranchInfo>();
            while (resultSet.next()) {
                int id = resultSet.getInt(1);
                String name = resultSet.getString(2);
                long baseTimeStamp = resultSet.getLong(3);
                result.add(new InternalCDOBranchManager.BranchLoader.SubBranchInfo(id, name, baseTimeStamp));
            }
            subBranchInfoArray = result.toArray(new InternalCDOBranchManager.BranchLoader.SubBranchInfo[result.size()]);
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                this.statementCache.releasePreparedStatement(pstmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        this.statementCache.releasePreparedStatement(pstmt);
        return subBranchInfoArray;
    }

    private void checkBranchingSupport() {
        if (!this.getStore().getMappingStrategy().hasBranchingSupport()) {
            throw new UnsupportedOperationException("Mapping strategy does not support branching");
        }
    }

    public int loadBranches(int startID, int endID, CDOBranchHandler handler) {
        int n;
        int count = 0;
        PreparedStatement pstmt = null;
        ResultSet resultSet = null;
        InternalRepository repository = this.getSession().getManager().getRepository();
        InternalCDOBranchManager branchManager = repository.getBranchManager();
        try {
            pstmt = this.statementCache.getPreparedStatement(CDODBSchema.SQL_LOAD_BRANCHES, IPreparedStatementCache.ReuseProbability.HIGH);
            pstmt.setInt(1, startID);
            pstmt.setInt(2, endID > 0 ? endID : Integer.MAX_VALUE);
            resultSet = pstmt.executeQuery();
            while (resultSet.next()) {
                int branchID = resultSet.getInt(1);
                String name = resultSet.getString(2);
                int baseBranchID = resultSet.getInt(3);
                long baseTimeStamp = resultSet.getLong(4);
                InternalCDOBranch branch = branchManager.getBranch(branchID, new InternalCDOBranchManager.BranchLoader.BranchInfo(name, baseBranchID, baseTimeStamp));
                handler.handleBranch((CDOBranch)branch);
                ++count;
            }
            n = count;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                this.statementCache.releasePreparedStatement(pstmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        this.statementCache.releasePreparedStatement(pstmt);
        return n;
    }

    public void loadCommitInfos(CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(CDODBSchema.COMMIT_INFOS_TIMESTAMP);
        builder.append(", ");
        builder.append(CDODBSchema.COMMIT_INFOS_USER);
        builder.append(", ");
        builder.append(CDODBSchema.COMMIT_INFOS_COMMENT);
        if (branch == null) {
            builder.append(", ");
            builder.append(CDODBSchema.COMMIT_INFOS_BRANCH);
        }
        builder.append(" FROM ");
        builder.append(CDODBSchema.COMMIT_INFOS);
        boolean where = false;
        if (branch != null) {
            builder.append(where ? " AND " : " WHERE ");
            builder.append(CDODBSchema.COMMIT_INFOS_BRANCH);
            builder.append("=");
            builder.append(branch.getID());
            where = true;
        }
        if (startTime != 0L) {
            builder.append(where ? " AND " : " WHERE ");
            builder.append(CDODBSchema.COMMIT_INFOS_TIMESTAMP);
            builder.append(">=");
            builder.append(startTime);
            where = true;
        }
        if (endTime != 0L) {
            builder.append(where ? " AND " : " WHERE ");
            builder.append(CDODBSchema.COMMIT_INFOS_TIMESTAMP);
            builder.append("<=");
            builder.append(endTime);
            where = true;
        }
        builder.append(" ORDER BY ");
        builder.append(CDODBSchema.COMMIT_INFOS_TIMESTAMP);
        String sql = builder.toString();
        PreparedStatement pstmt = null;
        ResultSet resultSet = null;
        InternalSession session = this.getSession();
        InternalSessionManager manager = session.getManager();
        InternalRepository repository = manager.getRepository();
        InternalCDOBranchManager branchManager = repository.getBranchManager();
        InternalCDOCommitInfoManager commitInfoManager = repository.getCommitInfoManager();
        try {
            try {
                pstmt = this.statementCache.getPreparedStatement(sql, IPreparedStatementCache.ReuseProbability.MEDIUM);
                resultSet = pstmt.executeQuery();
                while (resultSet.next()) {
                    long timeStamp = resultSet.getLong(1);
                    String userID = resultSet.getString(2);
                    String comment = resultSet.getString(3);
                    CDOBranch infoBranch = branch;
                    if (infoBranch == null) {
                        int id = resultSet.getInt(4);
                        infoBranch = branchManager.getBranch(id);
                    }
                    CDOCommitInfo commitInfo = commitInfoManager.createCommitInfo(infoBranch, timeStamp, userID, comment, null);
                    handler.handleCommitInfo(commitInfo);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            this.statementCache.releasePreparedStatement(pstmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        this.statementCache.releasePreparedStatement(pstmt);
    }

    public Set<CDOID> readChangeSet(CDOChangeSetSegment ... segments) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        return mappingStrategy.readChangeSet(this, segments);
    }

    public void handleRevisions(EClass eClass, CDOBranch branch, long timeStamp, CDORevisionHandler handler) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        mappingStrategy.handleRevisions(this, eClass, branch, timeStamp, new DBRevisionHandler(handler));
    }

    public void rawExport(CDODataOutput out, int fromBranchID, int toBranchID, long fromCommitTime, long toCommitTime) throws IOException {
        Connection connection = this.getConnection();
        DBStore store = this.getStore();
        String where = " WHERE " + CDODBSchema.BRANCHES_ID + " BETWEEN " + fromBranchID + " AND " + toBranchID;
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)CDODBSchema.BRANCHES, null, (String)where);
        where = " WHERE " + CDODBSchema.COMMIT_INFOS_TIMESTAMP + " BETWEEN " + fromCommitTime + " AND " + toCommitTime;
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)CDODBSchema.COMMIT_INFOS, null, (String)where);
        where = " WHERE " + CDODBSchema.EXTERNAL_TIMESTAMP + " BETWEEN " + fromCommitTime + " AND " + toCommitTime;
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)CDODBSchema.EXTERNAL_REFS, null, (String)where);
        IMetaDataManager metaDataManager = store.getMetaDataManager();
        metaDataManager.rawExport(connection, out, fromCommitTime, toCommitTime);
        IMappingStrategy mappingStrategy = store.getMappingStrategy();
        mappingStrategy.rawExport(this, out, fromBranchID, toBranchID, fromCommitTime, toCommitTime);
    }

    public void rawImport(CDODataInput in, int fromBranchID, int toBranchID, long fromCommitTime, long toCommitTime) throws IOException {
        DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)this.connection, (IDBTable)CDODBSchema.BRANCHES);
        DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)this.connection, (IDBTable)CDODBSchema.COMMIT_INFOS);
        DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)this.connection, (IDBTable)CDODBSchema.EXTERNAL_REFS);
        this.rawImportPackageUnits(in, fromCommitTime, toCommitTime);
        this.getStore().getMappingStrategy().rawImport(this, in);
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    protected void rawImportPackageUnits(CDODataInput in, long fromCommitTime, long toCommitTime) throws IOException {
        DBStore store = this.getStore();
        IMetaDataManager metaDataManager = store.getMetaDataManager();
        Collection<InternalCDOPackageUnit> packageUnits = metaDataManager.rawImport(this.getConnection(), in, fromCommitTime, toCommitTime);
        InternalRepository repository = store.getRepository();
        InternalCDOPackageRegistry packageRegistry = repository.getPackageRegistry(false);
        for (InternalCDOPackageUnit packageUnit : packageUnits) {
            packageRegistry.putPackageUnit(packageUnit);
        }
        IMappingStrategy mappingStrategy = store.getMappingStrategy();
        mappingStrategy.createMapping(this.connection, packageUnits.toArray(new InternalCDOPackageUnit[packageUnits.size()]), (OMMonitor)new Monitor());
    }

    private class ConnectionKeepAliveTask
    extends TimerTask {
        public static final long EXECUTION_PERIOD = 14400000L;

        private ConnectionKeepAliveTask() {
        }

        public void run() {
            block6: {
                Statement stmt = null;
                try {
                    try {
                        if (TRACER.isEnabled()) {
                            TRACER.trace("DB connection keep-alive task activated");
                        }
                        stmt = DBStoreAccessor.this.connection.createStatement();
                        stmt.executeQuery("SELECT 1 FROM " + CDODBSchema.PROPERTIES);
                    }
                    catch (Exception ex) {
                        OM.LOG.error("DB connection keep-alive failed", (Throwable)ex);
                        DBUtil.close((Statement)stmt);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    DBUtil.close(stmt);
                    throw throwable;
                }
                DBUtil.close((Statement)stmt);
            }
        }
    }
}

