/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IExternalReferenceManager;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.internal.db.CDODBSchema;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class ExternalReferenceManager
extends Lifecycle
implements IExternalReferenceManager.Internal {
    private IDBStore store;
    private AtomicLong lastMappedID = new AtomicLong(0L);
    @ReflectUtil.ExcludeFromDump
    private transient String sqlSelectByLongID;
    @ReflectUtil.ExcludeFromDump
    private transient String sqlSelectByURI;
    @ReflectUtil.ExcludeFromDump
    private transient String sqlInsert;

    public IDBStore getStore() {
        return this.store;
    }

    public void setStore(IDBStore store) {
        this.store = store;
    }

    public long mapExternalReference(IDBStoreAccessor accessor, CDOIDExternal id, long commitTime) {
        String uri = id.getURI();
        long result = this.lookupByID(accessor, uri);
        if (result < DBStore.NULL) {
            return result;
        }
        return this.insertNew(accessor, uri, commitTime);
    }

    public CDOIDExternal unmapExternalReference(IDBStoreAccessor accessor, long mappedId) {
        CDOIDExternal cDOIDExternal;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = accessor.getStatementCache().getPreparedStatement(this.sqlSelectByLongID, IPreparedStatementCache.ReuseProbability.HIGH);
            stmt.setLong(1, mappedId);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                OM.LOG.error("External ID " + mappedId + " not found. Database inconsistent!");
                throw new IllegalStateException("External ID " + mappedId + " not found. Database inconsistent!");
            }
            String uri = rs.getString(1);
            cDOIDExternal = CDOIDUtil.createExternal((String)uri);
        }
        catch (SQLException e) {
            try {
                throw new DBException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs);
                accessor.getStatementCache().releasePreparedStatement(stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)rs);
        accessor.getStatementCache().releasePreparedStatement(stmt);
        return cDOIDExternal;
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.store, "Store is not set");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        IDBStoreAccessor reader = this.getStore().getReader(null);
        Connection connection = reader.getConnection();
        Statement statement = null;
        try {
            try {
                String sql = "SELECT MIN(" + CDODBSchema.EXTERNAL_ID + ") FROM " + CDODBSchema.EXTERNAL_REFS;
                statement = connection.createStatement();
                ResultSet result = statement.executeQuery(sql);
                if (result.next()) {
                    this.lastMappedID.set(result.getLong(1));
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(statement);
            LifecycleUtil.deactivate((Object)reader);
            throw throwable;
        }
        DBUtil.close((Statement)statement);
        LifecycleUtil.deactivate((Object)reader);
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(CDODBSchema.EXTERNAL_REFS);
        builder.append("(");
        builder.append(CDODBSchema.EXTERNAL_ID);
        builder.append(",");
        builder.append(CDODBSchema.EXTERNAL_URI);
        builder.append(",");
        builder.append(CDODBSchema.EXTERNAL_TIMESTAMP);
        builder.append(") VALUES (?, ?, ?)");
        this.sqlInsert = builder.toString();
        builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(CDODBSchema.EXTERNAL_ID);
        builder.append(" FROM ");
        builder.append(CDODBSchema.EXTERNAL_REFS);
        builder.append(" WHERE ");
        builder.append(CDODBSchema.EXTERNAL_URI);
        builder.append("=?");
        this.sqlSelectByURI = builder.toString();
        builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(CDODBSchema.EXTERNAL_URI);
        builder.append(" FROM ");
        builder.append(CDODBSchema.EXTERNAL_REFS);
        builder.append(" WHERE ");
        builder.append(CDODBSchema.EXTERNAL_ID);
        builder.append("=?");
        this.sqlSelectByLongID = builder.toString();
    }

    private long insertNew(IDBStoreAccessor accessor, String uri, long commitTime) {
        long newMappedID = this.lastMappedID.decrementAndGet();
        PreparedStatement stmt = null;
        try {
            stmt = accessor.getStatementCache().getPreparedStatement(this.sqlInsert, IPreparedStatementCache.ReuseProbability.MEDIUM);
            stmt.setLong(1, newMappedID);
            stmt.setString(2, uri);
            stmt.setLong(3, commitTime);
            CDODBUtil.sqlUpdate(stmt, true);
            long l = newMappedID;
            accessor.getStatementCache().releasePreparedStatement(stmt);
            return l;
        }
        catch (SQLException e) {
            try {
                throw new DBException((Throwable)e);
            }
            catch (Throwable throwable) {
                accessor.getStatementCache().releasePreparedStatement(stmt);
                throw throwable;
            }
        }
    }

    private long lookupByID(IDBStoreAccessor accessor, String uri) {
        ResultSet rs;
        PreparedStatement stmt;
        block4: {
            long l;
            stmt = null;
            rs = null;
            try {
                stmt = accessor.getStatementCache().getPreparedStatement(this.sqlSelectByURI, IPreparedStatementCache.ReuseProbability.HIGH);
                stmt.setString(1, uri);
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                l = rs.getLong(1);
            }
            catch (SQLException e) {
                try {
                    throw new DBException((Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtil.close(rs);
                    accessor.getStatementCache().releasePreparedStatement(stmt);
                    throw throwable;
                }
            }
            DBUtil.close((ResultSet)rs);
            accessor.getStatementCache().releasePreparedStatement(stmt);
            return l;
        }
        DBUtil.close((ResultSet)rs);
        accessor.getStatementCache().releasePreparedStatement(stmt);
        return 0L;
    }
}

