/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDMeta;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IMetaDataManager;
import org.eclipse.emf.cdo.server.internal.db.CDODBSchema;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBRowHandler;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataManager
extends Lifecycle
implements IMetaDataManager {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, MetaDataManager.class);
    private static final boolean ZIP_PACKAGE_BYTES = true;
    private IDBStore store;

    public MetaDataManager(IDBStore store) {
        this.store = store;
    }

    @Override
    public long getMetaID(EModelElement modelElement) {
        CDOID cdoid = this.getPackageRegistry().getMetaInstanceMapper().lookupMetaInstanceID((InternalEObject)modelElement);
        return CDOIDUtil.getLong((CDOID)cdoid);
    }

    @Override
    public EModelElement getMetaInstance(long id) {
        CDOIDMeta cdoid = CDOIDUtil.createMeta((long)id);
        InternalEObject metaInstance = this.getPackageRegistry().getMetaInstanceMapper().lookupMetaInstance((CDOID)cdoid);
        return (EModelElement)metaInstance;
    }

    @Override
    public final EPackage[] loadPackageUnit(Connection connection, InternalCDOPackageUnit packageUnit) {
        String where = String.valueOf(CDODBSchema.PACKAGE_UNITS_ID.getName()) + "='" + packageUnit.getID() + "'";
        Object[] values = DBUtil.select((Connection)connection, (String)where, (IDBField[])new IDBField[]{CDODBSchema.PACKAGE_UNITS_PACKAGE_DATA});
        byte[] bytes = (byte[])values[0];
        EPackage ePackage = this.createEPackage(packageUnit, bytes);
        return EMFUtil.getAllPackages((EPackage)ePackage);
    }

    @Override
    public Collection<InternalCDOPackageUnit> readPackageUnits(Connection connection) {
        return this.readPackageUnits(connection, 0L, 0L);
    }

    @Override
    public final void writePackageUnits(Connection connection, InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        try {
            monitor.begin(2.0);
            this.fillSystemTables(connection, packageUnits, monitor.fork());
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void rawExport(Connection connection, CDODataOutput out, long fromCommitTime, long toCommitTime) throws IOException {
        String where = " WHERE p_u." + CDODBSchema.PACKAGE_UNITS_ID + "<>'" + "http://www.eclipse.org/emf/2002/Ecore" + "' AND p_u." + CDODBSchema.PACKAGE_UNITS_ID + "<>'" + "http://www.eclipse.org/emf/CDO/Eresource/2.0.0" + "' AND p_u." + CDODBSchema.PACKAGE_UNITS_TIME_STAMP + " BETWEEN " + fromCommitTime + " AND " + toCommitTime;
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)CDODBSchema.PACKAGE_UNITS, (String)"p_u", (String)where);
        String join = ", " + CDODBSchema.PACKAGE_UNITS + " p_u" + where + " AND p_i." + CDODBSchema.PACKAGE_INFOS_UNIT + "=p_u." + CDODBSchema.PACKAGE_UNITS_ID;
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)CDODBSchema.PACKAGE_INFOS, (String)"p_i", (String)join);
    }

    @Override
    public Collection<InternalCDOPackageUnit> rawImport(Connection connection, CDODataInput in, long fromCommitTime, long toCommitTime) throws IOException {
        DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)CDODBSchema.PACKAGE_UNITS);
        DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)CDODBSchema.PACKAGE_INFOS);
        return this.readPackageUnits(connection, fromCommitTime, toCommitTime);
    }

    protected IDBStore getStore() {
        return this.store;
    }

    protected void doBeforeActivate() throws Exception {
        this.checkState(this.store != null, "Store is not set");
    }

    protected InternalCDOPackageInfo createPackageInfo() {
        return (InternalCDOPackageInfo)CDOModelUtil.createPackageInfo();
    }

    protected InternalCDOPackageUnit createPackageUnit() {
        return (InternalCDOPackageUnit)CDOModelUtil.createPackageUnit();
    }

    private InternalCDOPackageRegistry getPackageRegistry() {
        return (InternalCDOPackageRegistry)this.store.getRepository().getPackageRegistry();
    }

    private EPackage createEPackage(InternalCDOPackageUnit packageUnit, byte[] bytes) {
        ResourceSet resourceSet = EMFUtil.newEcoreResourceSet((EPackage.Registry)this.getPackageRegistry());
        return EMFUtil.createEPackage((String)packageUnit.getID(), (byte[])bytes, (boolean)true, (ResourceSet)resourceSet, (boolean)false);
    }

    private byte[] getEPackageBytes(InternalCDOPackageUnit packageUnit) {
        EPackage ePackage = packageUnit.getTopLevelPackageInfo().getEPackage();
        CDOPackageRegistry packageRegistry = this.getStore().getRepository().getPackageRegistry();
        return EMFUtil.getEPackageBytes((EPackage)ePackage, (boolean)true, (EPackage.Registry)packageRegistry);
    }

    private void fillSystemTables(Connection connection, InternalCDOPackageUnit packageUnit, OMMonitor monitor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing package unit: {0}", new Object[]{packageUnit});
        }
        InternalCDOPackageInfo[] packageInfos = packageUnit.getPackageInfos();
        OMMonitor.Async async = null;
        monitor.begin((double)(1 + packageInfos.length));
        try {
            String sql = "INSERT INTO " + CDODBSchema.PACKAGE_UNITS + " VALUES (?, ?, ?, ?)";
            DBUtil.trace((String)sql);
            PreparedStatement pstmt = null;
            try {
                try {
                    async = monitor.forkAsync();
                    pstmt = connection.prepareStatement(sql);
                    pstmt.setString(1, packageUnit.getID());
                    pstmt.setInt(2, packageUnit.getOriginalType().ordinal());
                    pstmt.setLong(3, packageUnit.getTimeStamp());
                    pstmt.setBytes(4, this.getEPackageBytes(packageUnit));
                    if (pstmt.execute()) {
                        throw new DBException("No result set expected");
                    }
                    if (pstmt.getUpdateCount() == 0) {
                        throw new DBException("No row inserted into table " + CDODBSchema.PACKAGE_UNITS);
                    }
                }
                catch (SQLException ex) {
                    throw new DBException((Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(pstmt);
                if (async != null) {
                    async.stop();
                }
                throw throwable;
            }
            DBUtil.close((Statement)pstmt);
            if (async != null) {
                async.stop();
            }
            InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageInfos;
            int n = packageInfos.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
                this.fillSystemTables(connection, packageInfo, monitor);
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void fillSystemTables(Connection connection, InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        try {
            monitor.begin((double)packageUnits.length);
            InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageUnits;
            int n = packageUnits.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
                this.fillSystemTables(connection, packageUnit, monitor.fork());
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void fillSystemTables(Connection connection, InternalCDOPackageInfo packageInfo, OMMonitor monitor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing package info: {0}", new Object[]{packageInfo});
        }
        String packageURI = packageInfo.getPackageURI();
        String parentURI = packageInfo.getParentURI();
        String unitID = packageInfo.getPackageUnit().getID();
        CDOIDMetaRange metaIDRange = packageInfo.getMetaIDRange();
        long metaLB = metaIDRange == null ? 0L : ((CDOIDMeta)metaIDRange.getLowerBound()).getLongValue();
        long metaUB = metaIDRange == null ? 0L : ((CDOIDMeta)metaIDRange.getUpperBound()).getLongValue();
        String sql = "INSERT INTO " + CDODBSchema.PACKAGE_INFOS + " VALUES (?, ?, ?, ?, ?)";
        DBUtil.trace((String)sql);
        PreparedStatement pstmt = null;
        OMMonitor.Async async = monitor.forkAsync();
        try {
            try {
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, packageURI);
                pstmt.setString(2, parentURI);
                pstmt.setString(3, unitID);
                pstmt.setLong(4, metaLB);
                pstmt.setLong(5, metaUB);
                if (pstmt.execute()) {
                    throw new DBException("No result set expected");
                }
                if (pstmt.getUpdateCount() == 0) {
                    throw new DBException("No row inserted into table " + CDODBSchema.PACKAGE_INFOS);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(pstmt);
            if (async != null) {
                async.stop();
            }
            throw throwable;
        }
        DBUtil.close((Statement)pstmt);
        if (async != null) {
            async.stop();
        }
    }

    private Collection<InternalCDOPackageUnit> readPackageUnits(Connection connection, long fromCommitTime, long toCommitTime) {
        final HashMap packageUnits = new HashMap();
        IDBRowHandler unitRowHandler = new IDBRowHandler(){

            public boolean handle(int row, Object ... values) {
                InternalCDOPackageUnit packageUnit = MetaDataManager.this.createPackageUnit();
                packageUnit.setOriginalType(CDOPackageUnit.Type.values()[(Integer)values[1]]);
                packageUnit.setTimeStamp(((Long)values[2]).longValue());
                packageUnits.put((String)values[0], packageUnit);
                return true;
            }
        };
        String where = null;
        if (fromCommitTime != 0L) {
            where = CDODBSchema.PACKAGE_UNITS_ID + "<>'" + "http://www.eclipse.org/emf/2002/Ecore" + "' AND " + CDODBSchema.PACKAGE_UNITS_ID + "<>'" + "http://www.eclipse.org/emf/CDO/Eresource/2.0.0" + "' AND " + CDODBSchema.PACKAGE_UNITS_TIME_STAMP + " BETWEEN " + fromCommitTime + " AND " + toCommitTime;
        }
        DBUtil.select((Connection)connection, (IDBRowHandler)unitRowHandler, where, (IDBField[])new IDBField[]{CDODBSchema.PACKAGE_UNITS_ID, CDODBSchema.PACKAGE_UNITS_ORIGINAL_TYPE, CDODBSchema.PACKAGE_UNITS_TIME_STAMP});
        final HashMap packageInfos = new HashMap();
        IDBRowHandler infoRowHandler = new IDBRowHandler(){

            public boolean handle(int row, Object ... values) {
                long metaLB = (Long)values[3];
                long metaUB = (Long)values[4];
                CDOIDMetaRange metaIDRange = metaLB == 0L ? null : CDOIDUtil.createMetaRange((CDOID)CDOIDUtil.createMeta((long)metaLB), (int)((int)(metaUB - metaLB) + 1));
                InternalCDOPackageInfo packageInfo = MetaDataManager.this.createPackageInfo();
                packageInfo.setPackageURI((String)values[1]);
                packageInfo.setParentURI((String)values[2]);
                packageInfo.setMetaIDRange(metaIDRange);
                String unit = (String)values[0];
                ArrayList<InternalCDOPackageInfo> list = (ArrayList<InternalCDOPackageInfo>)packageInfos.get(unit);
                if (list == null) {
                    list = new ArrayList<InternalCDOPackageInfo>();
                    packageInfos.put(unit, list);
                }
                list.add(packageInfo);
                return true;
            }
        };
        DBUtil.select((Connection)connection, (IDBRowHandler)infoRowHandler, (IDBField[])new IDBField[]{CDODBSchema.PACKAGE_INFOS_UNIT, CDODBSchema.PACKAGE_INFOS_URI, CDODBSchema.PACKAGE_INFOS_PARENT, CDODBSchema.PACKAGE_INFOS_META_LB, CDODBSchema.PACKAGE_INFOS_META_UB});
        for (Map.Entry entry : packageUnits.entrySet()) {
            String id = (String)entry.getKey();
            InternalCDOPackageUnit packageUnit = (InternalCDOPackageUnit)entry.getValue();
            List list = (List)packageInfos.get(id);
            InternalCDOPackageInfo[] array = list.toArray(new InternalCDOPackageInfo[list.size()]);
            packageUnit.setPackageInfos(array);
        }
        return packageUnits.values();
    }
}

