/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.server.IQueryContext;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.internal.db.DBStoreAccessor;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLQueryHandler
implements IQueryHandler {
    public static final String QUERY_LANGUAGE = "sql";
    public static final String FIRST_RESULT = "firstResult";
    public static final String CDO_OBJECT_QUERY = "cdoObjectQuery";
    public static final String QUERY_STATEMENT = "queryStatement";
    private DBStoreAccessor storeAccessor;

    public SQLQueryHandler(DBStoreAccessor storeAccessor) {
        this.storeAccessor = storeAccessor;
    }

    public DBStoreAccessor getStoreAccessor() {
        return this.storeAccessor;
    }

    public void executeQuery(CDOQueryInfo info, IQueryContext context) {
        ResultSet resultSet;
        PreparedStatement statement;
        block22: {
            String language = info.getQueryLanguage();
            if (!QUERY_LANGUAGE.equals(language)) {
                throw new IllegalArgumentException("Unsupported query language: " + language);
            }
            Connection connection = this.storeAccessor.getConnection();
            statement = null;
            resultSet = null;
            String query = info.getQueryString();
            try {
                try {
                    int firstResult = -1;
                    boolean queryStatement = true;
                    boolean objectQuery = true;
                    HashMap<String, List<Integer>> paramMap = new HashMap<String, List<Integer>>();
                    query = this.parse(query, paramMap);
                    statement = connection.prepareStatement(query, 1004, 1007);
                    for (String key : info.getParameters().keySet()) {
                        Object o;
                        if (FIRST_RESULT.equalsIgnoreCase(key)) {
                            o = info.getParameters().get(key);
                            if (o == null) continue;
                            try {
                                firstResult = (Integer)o;
                                continue;
                            }
                            catch (ClassCastException ex) {
                                throw new IllegalArgumentException("Parameter firstResult must be an integer but it is a " + o + " class " + o.getClass().getName(), ex);
                            }
                        }
                        if (QUERY_STATEMENT.equalsIgnoreCase(key)) {
                            o = info.getParameters().get(key);
                            if (o == null) continue;
                            try {
                                queryStatement = (Boolean)o;
                                continue;
                            }
                            catch (ClassCastException ex) {
                                throw new IllegalArgumentException("Parameter queryStatement must be an boolean but it is a " + o + " class " + o.getClass().getName(), ex);
                            }
                        }
                        if (CDO_OBJECT_QUERY.equalsIgnoreCase(key)) {
                            o = info.getParameters().get(key);
                            if (o == null) continue;
                            try {
                                objectQuery = (Boolean)o;
                                continue;
                            }
                            catch (ClassCastException ex) {
                                throw new IllegalArgumentException("Parameter cdoObjectQuery must be a boolean but it is a " + o + " class " + o.getClass().getName(), ex);
                            }
                        }
                        if (!paramMap.containsKey(key) || paramMap.get(key) == null) {
                            throw new IllegalArgumentException("No parameter value found for named parameter " + key);
                        }
                        Integer[] indexes = paramMap.get(key).toArray(new Integer[0]);
                        int i = 0;
                        while (i < indexes.length) {
                            Object parameter = info.getParameters().get(key);
                            statement.setObject(indexes[i], parameter);
                            ++i;
                        }
                    }
                    if (queryStatement) {
                        resultSet = statement.executeQuery();
                        if (firstResult > -1) {
                            resultSet.absolute(firstResult);
                        }
                        int maxResults = info.getMaxResults();
                        int counter = 0;
                        while (resultSet.next()) {
                            if (maxResults == -1 || counter++ < maxResults) {
                                Object result;
                                if (objectQuery) {
                                    result = CDOIDUtil.createLong((long)resultSet.getLong(1));
                                    context.addResult(result);
                                    continue;
                                }
                                result = resultSet.getObject(1);
                                context.addResult(result);
                                continue;
                            }
                            break block22;
                        }
                        break block22;
                    }
                    int result = statement.executeUpdate();
                    context.addResult((Object)result);
                }
                catch (SQLException ex) {
                    throw new DBException("Problem while executing SQL query: " + query, (Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)statement);
    }

    private String parse(String query, Map<String, List<Integer>> paramMap) {
        int length = query.length();
        StringBuffer parsedQuery = new StringBuffer(length);
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        int index = 1;
        int i = 0;
        while (i < length) {
            int c = query.charAt(i);
            if (inSingleQuote) {
                if (c == 39) {
                    inSingleQuote = false;
                }
            } else if (inDoubleQuote) {
                if (c == 34) {
                    inDoubleQuote = false;
                }
            } else if (c == 39) {
                inSingleQuote = true;
            } else if (c == 34) {
                inDoubleQuote = true;
            } else if (c == 58 && i + 1 < length && Character.isJavaIdentifierStart(query.charAt(i + 1))) {
                int j = i + 2;
                while (j < length && Character.isJavaIdentifierPart(query.charAt(j))) {
                    ++j;
                }
                String name = query.substring(i + 1, j);
                c = 63;
                i += name.length();
                List<Integer> indexList = paramMap.get(name);
                if (indexList == null) {
                    indexList = new ArrayList<Integer>();
                    paramMap.put(name, indexList);
                }
                indexList.add(new Integer(index));
                ++index;
            }
            parsedQuery.append((char)c);
            ++i;
        }
        return parsedQuery.toString();
    }
}

