/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.internal.db.AbstractPreparedStatementCache;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.util.ImplementationError;

public class SmartPreparedStatementCache
extends AbstractPreparedStatementCache {
    private Cache cache;
    private HashMap<PreparedStatement, CachedPreparedStatement> checkedOut = new HashMap();

    public SmartPreparedStatementCache(int capacity) {
        this.cache = new Cache(capacity);
    }

    public PreparedStatement getPreparedStatement(String sql, IPreparedStatementCache.ReuseProbability reuseProbability) {
        CachedPreparedStatement cachedStatement = this.cache.remove(sql);
        if (cachedStatement == null) {
            cachedStatement = this.createCachedPreparedStatement(sql, reuseProbability);
        }
        PreparedStatement result = cachedStatement.getPreparedStatement();
        this.checkedOut.put(result, cachedStatement);
        return result;
    }

    public void releasePreparedStatement(PreparedStatement ps) {
        if (ps != null) {
            CachedPreparedStatement cachedStatement = this.checkedOut.remove(ps);
            this.cache.put(cachedStatement);
        }
    }

    protected void doBeforeDeactivate() throws Exception {
        if (!this.checkedOut.isEmpty()) {
            OM.LOG.warn("Statement leak detected");
        }
    }

    private CachedPreparedStatement createCachedPreparedStatement(String sql, IPreparedStatementCache.ReuseProbability reuseProbability) {
        try {
            Connection connection = this.getConnection();
            PreparedStatement stmt = connection.prepareStatement(sql);
            return new CachedPreparedStatement(sql, reuseProbability, stmt);
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    private static final class Cache {
        private CacheList[] lists;
        private HashMap<String, CachedPreparedStatement> lookup;
        private int capacity;

        public Cache(int capacity) {
            this.capacity = capacity;
            this.lookup = new HashMap(capacity);
            this.lists = new CacheList[IPreparedStatementCache.ReuseProbability.values().length];
            IPreparedStatementCache.ReuseProbability[] reuseProbabilityArray = IPreparedStatementCache.ReuseProbability.values();
            int n = reuseProbabilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPreparedStatementCache.ReuseProbability prob = reuseProbabilityArray[n2];
                this.lists[prob.ordinal()] = new CacheList();
                ++n2;
            }
        }

        public void put(CachedPreparedStatement cachedStatement) {
            cachedStatement.touch();
            this.lists[cachedStatement.getProbability().ordinal()].add(cachedStatement);
            if (this.lookup.put(cachedStatement.getSQL(), cachedStatement) != null) {
                throw new ImplementationError(String.valueOf(cachedStatement.getSQL()) + " already in cache");
            }
            if (this.lookup.size() > this.capacity) {
                this.evictOne();
            }
        }

        private void evictOne() {
            long maxAge = -1L;
            int ordinal = -1;
            IPreparedStatementCache.ReuseProbability[] reuseProbabilityArray = IPreparedStatementCache.ReuseProbability.values();
            int n = reuseProbabilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                long age;
                IPreparedStatementCache.ReuseProbability prob = reuseProbabilityArray[n2];
                if (!this.lists[prob.ordinal()].isEmpty() && maxAge < (age = this.lists[prob.ordinal()].tail().getAge())) {
                    maxAge = age;
                    ordinal = prob.ordinal();
                }
                ++n2;
            }
            this.remove(this.lists[ordinal].tail().getSQL());
        }

        public CachedPreparedStatement remove(String sql) {
            CachedPreparedStatement result = this.lookup.remove(sql);
            if (result == null) {
                return null;
            }
            this.lists[result.getProbability().ordinal()].remove(result);
            return result;
        }

        private class CacheList {
            private CachedPreparedStatement first;
            private CachedPreparedStatement last;

            public void add(CachedPreparedStatement s) {
                if (this.first == null) {
                    this.first = s;
                    this.last = s;
                    s.previous = null;
                    s.next = null;
                } else {
                    this.first.previous = s;
                    s.next = this.first;
                    this.first = s;
                }
            }

            public void remove(CachedPreparedStatement s) {
                if (s == this.first) {
                    this.first = s.next;
                }
                if (s.next != null) {
                    s.next.previous = s.previous;
                }
                if (s == this.last) {
                    this.last = s.previous;
                }
                if (s.previous != null) {
                    s.previous.next = s.next;
                }
                s.previous = null;
                s.next = null;
            }

            public CachedPreparedStatement tail() {
                return this.last;
            }

            public boolean isEmpty() {
                return this.first == null;
            }
        }
    }

    private static final class CachedPreparedStatement {
        private long timeStamp;
        private String sql;
        private IPreparedStatementCache.ReuseProbability probability;
        private PreparedStatement statement;
        private CachedPreparedStatement previous;
        private CachedPreparedStatement next;

        public CachedPreparedStatement(String sql, IPreparedStatementCache.ReuseProbability prob, PreparedStatement stmt) {
            this.sql = sql;
            this.probability = prob;
            this.statement = stmt;
            this.timeStamp = System.currentTimeMillis();
        }

        public PreparedStatement getPreparedStatement() {
            return this.statement;
        }

        public long getAge() {
            long currentTime = System.currentTimeMillis();
            return (currentTime - this.timeStamp) * (long)this.probability.ordinal();
        }

        public void touch() {
            this.timeStamp = System.currentTimeMillis();
        }

        public String getSQL() {
            return this.sql;
        }

        public IPreparedStatementCache.ReuseProbability getProbability() {
            return this.probability;
        }
    }
}

