/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IMetaDataManager;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.CDODBSchema;
import org.eclipse.emf.cdo.server.internal.db.DBAnnotation;
import org.eclipse.emf.cdo.server.internal.db.ObjectIDIterator;
import org.eclipse.emf.cdo.server.internal.db.mapping.TypeMappingFactory;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMappingStrategy
extends Lifecycle
implements IMappingStrategy {
    protected static final String NAME_SEPARATOR = "_";
    protected static final String TYPE_PREFIX_FEATURE = "F";
    protected static final String TYPE_PREFIX_CLASS = "C";
    protected static final String TYPE_PREFIX_PACKAGE = "P";
    protected static final String CDO_SET_PREFIX = "cdo_set_";
    protected static final String FEATEURE_TABLE_SUFFIX = "_list";
    private IDBStore store;
    private Map<String, String> properties;
    private ConcurrentMap<EClass, IClassMapping> classMappings = new ConcurrentHashMap<EClass, IClassMapping>();
    private boolean allClassMappingsCreated;

    public synchronized Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    @Override
    public synchronized void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    private int getMaxTableNameLength() {
        String value = this.getProperties().get("maxTableNameLength");
        return value == null ? this.store.getDBAdapter().getMaxTableNameLength() : Integer.valueOf(value).intValue();
    }

    private int getMaxFieldNameLength() {
        String value = this.getProperties().get("maxFieldNameLength");
        return value == null ? this.store.getDBAdapter().getMaxFieldNameLength() : Integer.valueOf(value).intValue();
    }

    private boolean isQualifiedNames() {
        String value = this.getProperties().get("qualifiedNames");
        return value == null ? false : Boolean.valueOf(value);
    }

    private boolean isForceNamesWithID() {
        String value = this.getProperties().get("forceNamesWithID");
        return value == null ? false : Boolean.valueOf(value);
    }

    private String getTableNamePrefix() {
        String value = this.getProperties().get("tableNamePrefix");
        return StringUtil.safe((String)value);
    }

    @Override
    public final IDBStore getStore() {
        return this.store;
    }

    @Override
    public final void setStore(IDBStore dbStore) {
        this.checkInactive();
        this.store = dbStore;
    }

    protected final IMetaDataManager getMetaDataManager() {
        return this.getStore().getMetaDataManager();
    }

    @Override
    public void handleRevisions(IDBStoreAccessor accessor, EClass eClass, CDOBranch branch, long timeStamp, CDORevisionHandler handler) {
        if (eClass == null) {
            for (IClassMapping mapping : this.getClassMappings().values()) {
                mapping.handleRevisions(accessor, branch, timeStamp, handler);
            }
        } else {
            IClassMapping classMapping = this.getClassMapping(eClass);
            classMapping.handleRevisions(accessor, branch, timeStamp, handler);
        }
    }

    @Override
    public Set<CDOID> readChangeSet(IDBStoreAccessor accessor, CDOChangeSetSegment[] segments) {
        HashSet<CDOID> result = new HashSet<CDOID>();
        for (IClassMapping mapping : this.getClassMappings().values()) {
            Set<CDOID> ids = mapping.readChangeSet(accessor, segments);
            result.addAll(ids);
        }
        return result;
    }

    @Override
    public CloseableIterator<CDOID> readObjectIDs(IDBStoreAccessor accessor) {
        Collection<EClass> classes = this.getClassesWithObjectInfo();
        final Iterator<EClass> classIt = classes.iterator();
        return new ObjectIDIterator(this, accessor){
            private PreparedStatement currentStatement;

            protected ResultSet getNextResultSet() {
                if (classIt.hasNext()) {
                    EClass eClass = (EClass)classIt.next();
                    IClassMapping mapping = AbstractMappingStrategy.this.getClassMapping(eClass);
                    this.currentStatement = mapping.createObjectIDStatement(this.getAccessor());
                    ResultSet rset = null;
                    try {
                        rset = this.currentStatement.executeQuery();
                        return rset;
                    }
                    catch (Exception ex) {
                        DBUtil.close((ResultSet)rset);
                        this.releaseCurrentStatement();
                        throw new DBException((Throwable)ex);
                    }
                }
                return null;
            }

            protected void closeCurrentResultSet() {
                super.closeCurrentResultSet();
                this.releaseCurrentStatement();
            }

            private void releaseCurrentStatement() {
                IPreparedStatementCache statementCache = this.getAccessor().getStatementCache();
                statementCache.releasePreparedStatement(this.currentStatement);
                this.currentStatement = null;
            }
        };
    }

    protected abstract Collection<EClass> getClassesWithObjectInfo();

    @Override
    public String getTableName(ENamedElement element) {
        String prefix;
        String name = null;
        String typePrefix = null;
        if (element instanceof EClass) {
            typePrefix = TYPE_PREFIX_CLASS;
            name = DBAnnotation.TABLE_NAME.getValue((EModelElement)element);
            if (name == null) {
                name = this.isQualifiedNames() ? EMFUtil.getQualifiedName((EClassifier)((EClass)element), (String)NAME_SEPARATOR) : element.getName();
            }
        } else if (element instanceof EPackage) {
            typePrefix = TYPE_PREFIX_PACKAGE;
            name = DBAnnotation.TABLE_NAME.getValue((EModelElement)element);
            if (name == null) {
                name = this.isQualifiedNames() ? EMFUtil.getQualifiedName((EPackage)((EPackage)element), (String)NAME_SEPARATOR) : element.getName();
            }
        } else {
            throw new ImplementationError("Unknown element: " + element);
        }
        if ((prefix = this.getTableNamePrefix()).length() != 0 && !prefix.endsWith(NAME_SEPARATOR)) {
            prefix = String.valueOf(prefix) + NAME_SEPARATOR;
        }
        return this.getName(String.valueOf(prefix) + name, String.valueOf(typePrefix) + this.getMetaDataManager().getMetaID((EModelElement)element), this.getMaxTableNameLength());
    }

    @Override
    public String getTableName(EClass eClass, EStructuralFeature feature) {
        String name = DBAnnotation.TABLE_NAME.getValue((EModelElement)eClass);
        if (name == null) {
            name = this.isQualifiedNames() ? EMFUtil.getQualifiedName((EClassifier)eClass, (String)NAME_SEPARATOR) : eClass.getName();
        }
        name = String.valueOf(name) + NAME_SEPARATOR;
        name = String.valueOf(name) + feature.getName();
        name = String.valueOf(name) + FEATEURE_TABLE_SUFFIX;
        String prefix = this.getTableNamePrefix();
        if (prefix.length() != 0 && !prefix.endsWith(NAME_SEPARATOR)) {
            prefix = String.valueOf(prefix) + NAME_SEPARATOR;
        }
        return this.getName(String.valueOf(prefix) + name, TYPE_PREFIX_FEATURE + this.getMetaDataManager().getMetaID((EModelElement)feature), this.getMaxTableNameLength());
    }

    @Override
    public String getFieldName(EStructuralFeature feature) {
        String name = DBAnnotation.COLUMN_NAME.getValue((EModelElement)feature);
        if (name == null) {
            name = this.getName(feature.getName(), TYPE_PREFIX_FEATURE + this.getMetaDataManager().getMetaID((EModelElement)feature), this.getMaxFieldNameLength());
        }
        return name;
    }

    public String getUnsettableFieldName(EStructuralFeature feature) {
        String name = DBAnnotation.COLUMN_NAME.getValue((EModelElement)feature);
        if (name != null) {
            return CDO_SET_PREFIX + name;
        }
        return this.getName(CDO_SET_PREFIX + feature.getName(), TYPE_PREFIX_FEATURE + this.getMetaDataManager().getMetaID((EModelElement)feature), this.getMaxFieldNameLength());
    }

    private String getName(String name, String suffix, int maxLength) {
        boolean forceNamesWithID = this.isForceNamesWithID();
        if (this.store.getDBAdapter().isReservedWord(name)) {
            forceNamesWithID = true;
        }
        if (name.length() > maxLength || forceNamesWithID) {
            suffix = NAME_SEPARATOR + suffix.replace('-', 'S');
            int length = Math.min(name.length(), maxLength - suffix.length());
            name = String.valueOf(name.substring(0, length)) + suffix;
        }
        return name;
    }

    @Override
    public void createMapping(Connection connection, InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        OMMonitor.Async async = null;
        monitor.begin();
        try {
            async = monitor.forkAsync();
            try {
                this.mapPackageUnits(packageUnits, connection, false);
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public void removeMapping(Connection connection, InternalCDOPackageUnit[] packageUnits) {
        this.mapPackageUnits(packageUnits, connection, true);
    }

    private void mapPackageUnits(InternalCDOPackageUnit[] packageUnits, Connection connection, boolean unmap) {
        if (packageUnits != null && packageUnits.length != 0) {
            InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageUnits;
            int n = packageUnits.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
                this.mapPackageInfos(packageUnit.getPackageInfos(), connection, unmap);
                ++n2;
            }
        }
    }

    private void mapPackageInfos(InternalCDOPackageInfo[] packageInfos, Connection connection, boolean unmap) {
        InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageInfos;
        int n = packageInfos.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
            EPackage ePackage = packageInfo.getEPackage();
            if (!CDOModelUtil.isCorePackage((EPackage)ePackage)) {
                this.mapClasses(EMFUtil.getPersistentClasses((EPackage)ePackage), connection, unmap);
            }
            ++n2;
        }
    }

    private void mapClasses(EClass[] eClasses, Connection connection, boolean unmap) {
        EClass[] eClassArray = eClasses;
        int n = eClasses.length;
        int n2 = 0;
        while (n2 < n) {
            EClass eClass = eClassArray[n2];
            if (!eClass.isInterface() && !eClass.isAbstract()) {
                Object mapping;
                if (!unmap) {
                    mapping = DBAnnotation.TABLE_MAPPING.getValue((EModelElement)eClass);
                    if (mapping == null || !((String)mapping).equalsIgnoreCase("NONE")) {
                        IClassMapping classMapping = this.createClassMapping(eClass);
                        this.getStore().getDBAdapter().createTables(classMapping.getDBTables(), connection);
                    }
                } else {
                    mapping = this.removeClassMapping(eClass);
                    this.getStore().getDBAdapter().dropTables(mapping.getDBTables(), connection);
                }
            }
            ++n2;
        }
    }

    private IClassMapping createClassMapping(EClass eClass) {
        IClassMapping mapping = this.doCreateClassMapping(eClass);
        if (mapping != null) {
            this.classMappings.put(eClass, mapping);
        }
        return mapping;
    }

    private IClassMapping removeClassMapping(EClass eClass) {
        IClassMapping mapping = (IClassMapping)this.classMappings.get(eClass);
        if (mapping != null) {
            IDBSchema schema = this.getStore().getDBSchema();
            for (IDBTable table : mapping.getDBTables()) {
                ((CDODBSchema)schema).removeTable(table.getName());
            }
            this.classMappings.remove(eClass);
        }
        return mapping;
    }

    protected abstract IClassMapping doCreateClassMapping(EClass var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IClassMapping getClassMapping(EClass eClass) {
        IClassMapping result = (IClassMapping)this.classMappings.get(eClass);
        if (result == null) {
            ConcurrentMap<EClass, IClassMapping> concurrentMap = this.classMappings;
            synchronized (concurrentMap) {
                result = (IClassMapping)this.classMappings.get(eClass);
                if (result == null) {
                    result = this.createClassMapping(eClass);
                }
            }
        }
        return result;
    }

    public final Map<EClass, IClassMapping> getClassMappings() {
        return this.getClassMappings(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<EClass, IClassMapping> getClassMappings(boolean createOnDemand) {
        if (createOnDemand) {
            ConcurrentMap<EClass, IClassMapping> concurrentMap = this.classMappings;
            synchronized (concurrentMap) {
                if (!this.allClassMappingsCreated) {
                    this.createAllClassMappings();
                    this.allClassMappingsCreated = true;
                }
            }
        }
        return this.classMappings;
    }

    private void createAllClassMappings() {
        InternalRepository repository = (InternalRepository)this.getStore().getRepository();
        InternalCDOPackageRegistry packageRegistry = repository.getPackageRegistry(false);
        InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageRegistry.getPackageInfos();
        int n = internalCDOPackageInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
            if (!packageInfo.isSystemPackage()) {
                for (EClassifier eClassifier : packageInfo.getEPackage().getEClassifiers()) {
                    EClass eClass;
                    if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract() || eClass.isInterface()) continue;
                    this.getClassMapping(eClass);
                }
            }
            ++n2;
        }
    }

    @Override
    public ITypeMapping createValueMapping(EStructuralFeature feature) {
        return TypeMappingFactory.createTypeMapping(this, feature);
    }

    @Override
    public final IListMapping createListMapping(EClass containingClass, EStructuralFeature feature) {
        this.checkArg(feature.isMany(), "Only many-valued features allowed");
        IListMapping mapping = this.doCreateListMapping(containingClass, feature);
        return mapping;
    }

    public final IListMapping createFeatureMapMapping(EClass containingClass, EStructuralFeature feature) {
        this.checkArg(FeatureMapUtil.isFeatureMap((EStructuralFeature)feature), "Only FeatureMaps allowed");
        IListMapping mapping = this.doCreateFeatureMapMapping(containingClass, feature);
        return mapping;
    }

    public abstract IListMapping doCreateListMapping(EClass var1, EStructuralFeature var2);

    public abstract IListMapping doCreateFeatureMapMapping(EClass var1, EStructuralFeature var2);
}

