/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IExternalReferenceManager;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.DBAnnotation;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.messages.Messages;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class TypeMapping
implements ITypeMapping {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, TypeMapping.class);
    private IMappingStrategy mappingStrategy;
    private EStructuralFeature feature;
    private IDBField field;
    private DBType dbType;

    protected TypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature, DBType type) {
        this.mappingStrategy = mappingStrategy;
        this.feature = feature;
        this.dbType = type;
    }

    public final IMappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    public final EStructuralFeature getFeature() {
        return this.feature;
    }

    public final void setValueFromRevision(PreparedStatement stmt, int index, InternalCDORevision revision) throws SQLException {
        this.setValue(stmt, index, this.getRevisionValue(revision));
    }

    public void setDefaultValue(PreparedStatement stmt, int index) throws SQLException {
        this.setValue(stmt, index, this.getDefaultValue());
    }

    public final void setValue(PreparedStatement stmt, int index, Object value) throws SQLException {
        if (value == CDORevisionData.NIL) {
            if (TRACER.isEnabled()) {
                TRACER.format("TypeMapping for {0}: converting Revision.NIL to DB-null", new Object[]{this.feature.getName()});
            }
            stmt.setNull(index, this.getSQLType());
        } else if (value == null) {
            if (this.feature.isMany() || this.getDefaultValue() == null) {
                if (TRACER.isEnabled()) {
                    TRACER.format("TypeMapping for {0}: writing Revision.null as DB.null", new Object[]{this.feature.getName()});
                }
                stmt.setNull(index, this.getSQLType());
            } else {
                if (TRACER.isEnabled()) {
                    TRACER.format("TypeMapping for {0}: converting Revision.null to default value", new Object[]{this.feature.getName()});
                }
                this.setDefaultValue(stmt, index);
            }
        } else {
            this.doSetValue(stmt, index, value);
        }
    }

    public final void createDBField(IDBTable table) {
        this.createDBField(table, this.mappingStrategy.getFieldName(this.feature));
    }

    public final void createDBField(IDBTable table, String fieldName) {
        DBType fieldType = this.getDBType();
        int fieldLength = this.getDBLength(fieldType);
        this.field = table.addField(fieldName, fieldType, fieldLength);
    }

    public final void setDBField(IDBTable table, String fieldName) {
        this.field = table.getField(fieldName);
    }

    public final IDBField getField() {
        return this.field;
    }

    public final void readValueToRevision(ResultSet resultSet, InternalCDORevision revision) throws SQLException {
        Object value = this.readValue(resultSet);
        revision.setValue(this.getFeature(), value);
    }

    public final Object readValue(ResultSet resultSet) throws SQLException {
        Object value = this.getResultSetValue(resultSet);
        if (resultSet.wasNull()) {
            if (this.feature.isMany()) {
                if (TRACER.isEnabled()) {
                    TRACER.format("TypeMapping for {0}: read db.null - setting Revision.null", new Object[]{this.feature.getName()});
                }
                value = null;
            } else if (this.getDefaultValue() == null) {
                if (TRACER.isEnabled()) {
                    TRACER.format("TypeMapping for {0}: read db.null - setting Revision.null, because of default", new Object[]{this.feature.getName()});
                }
                value = null;
            } else {
                if (TRACER.isEnabled()) {
                    TRACER.format("TypeMapping for {0}: read db.null - setting Revision.NIL", new Object[]{this.feature.getName()});
                }
                value = CDORevisionData.NIL;
            }
        }
        return value;
    }

    protected Object getDefaultValue() {
        return this.feature.getDefaultValue();
    }

    protected final Object getRevisionValue(InternalCDORevision revision) {
        return revision.getValue(this.getFeature());
    }

    protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
        stmt.setObject(index, value, this.getSQLType());
    }

    protected int getSQLType() {
        return this.getDBType().getCode();
    }

    public DBType getDBType() {
        return this.dbType;
    }

    protected int getDBLength(DBType type) {
        String value = DBAnnotation.COLUMN_LENGTH.getValue((EModelElement)this.feature);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                OM.LOG.error("Illegal columnLength annotation of feature " + this.feature.getName());
            }
        }
        return type == DBType.VARCHAR ? 32672 : -1;
    }

    protected abstract Object getResultSetValue(ResultSet var1) throws SQLException;

    public static class TMBigDecimal
    extends TypeMapping {
        public TMBigDecimal(IMappingStrategy strategy, EStructuralFeature feature, DBType type) {
            super(strategy, feature, type);
        }

        protected Object getResultSetValue(ResultSet resultSet) throws SQLException {
            String val = resultSet.getString(this.getField().getName());
            if (resultSet.wasNull()) {
                return this.getFeature().isUnsettable() ? CDORevisionData.NIL : null;
            }
            return new BigDecimal(val);
        }

        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            stmt.setString(index, ((BigDecimal)value).toPlainString());
        }
    }

    public static class TMBigInteger
    extends TypeMapping {
        public TMBigInteger(IMappingStrategy strategy, EStructuralFeature feature, DBType type) {
            super(strategy, feature, type);
        }

        protected Object getResultSetValue(ResultSet resultSet) throws SQLException {
            String val = resultSet.getString(this.getField().getName());
            if (resultSet.wasNull()) {
                return this.getFeature().isUnsettable() ? CDORevisionData.NIL : null;
            }
            return new BigInteger(val);
        }

        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            stmt.setString(index, ((BigInteger)value).toString());
        }
    }

    public static class TMBoolean
    extends TypeMapping {
        public TMBoolean(IMappingStrategy strategy, EStructuralFeature feature, DBType type) {
            super(strategy, feature, type);
        }

        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getBoolean(this.getField().getName());
        }
    }

    public static class TMByte
    extends TypeMapping {
        public TMByte(IMappingStrategy strategy, EStructuralFeature feature, DBType type) {
            super(strategy, feature, type);
        }

        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getByte(this.getField().getName());
        }
    }

    public static class TMBytes
    extends TypeMapping {
        public TMBytes(IMappingStrategy strategy, EStructuralFeature feature, DBType type) {
            super(strategy, feature, type);
        }

        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getBytes(this.getField().getName());
        }
    }

    public static class TMCharacter
    extends TypeMapping {
        public TMCharacter(IMappingStrategy strategy, EStructuralFeature feature, DBType type) {
            super(strategy, feature, type);
        }

        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            String str = resultSet.getString(this.getField().getName());
            if (resultSet.wasNull()) {
                return this.getFeature().isUnsettable() ? CDORevisionData.NIL : null;
            }
            return Character.valueOf(str.charAt(0));
        }

        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            stmt.setString(index, ((Character)value).toString());
        }
    }

    public static class TMCustom
    extends TypeMapping {
        public TMCustom(IMappingStrategy mappingStrategy, EStructuralFeature feature, DBType type) {
            super(mappingStrategy, feature, type);
        }

        protected Object getResultSetValue(ResultSet resultSet) throws SQLException {
            String val = resultSet.getString(this.getField().getName());
            if (resultSet.wasNull()) {
                return this.getFeature().isUnsettable() ? CDORevisionData.NIL : null;
            }
            return val;
        }

        public void setDefaultValue(PreparedStatement stmt, int index) throws SQLException {
            this.setValue(stmt, index, this.getFeature().getDefaultValueLiteral());
        }
    }

    public static class TMDate2Date
    extends TypeMapping {
        public TMDate2Date(IMappingStrategy strategy, EStructuralFeature feature, DBType type) {
            super(strategy, feature, type);
        }

        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getDate(this.getField().getName(), Calendar.getInstance());
        }

        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            stmt.setDate(index, new Date(((java.util.Date)value).getTime()), Calendar.getInstance());
        }
    }

    public static class TMDate2Time
    extends TypeMapping {
        public TMDate2Time(IMappingStrategy strategy, EStructuralFeature feature, DBType type) {
            super(strategy, feature, type);
        }

        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getTime(this.getField().getName(), Calendar.getInstance());
        }

        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            stmt.setTime(index, new Time(((java.util.Date)value).getTime()), Calendar.getInstance());
        }
    }

    public static class TMDate2Timestamp
    extends TypeMapping {
        public TMDate2Timestamp(IMappingStrategy strategy, EStructuralFeature feature, DBType type) {
            super(strategy, feature, type);
        }

        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getTimestamp(this.getField().getName());
        }

        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            stmt.setTimestamp(index, new Timestamp(((java.util.Date)value).getTime()));
        }
    }

    public static class TMDouble
    extends TypeMapping {
        public TMDouble(IMappingStrategy strategy, EStructuralFeature feature, DBType type) {
            super(strategy, feature, type);
        }

        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getDouble(this.getField().getName());
        }
    }

    public static class TMEnum
    extends TypeMapping {
        public TMEnum(IMappingStrategy strategy, EStructuralFeature feature, DBType type) {
            super(strategy, feature, type);
        }

        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getInt(this.getField().getName());
        }

        protected Object getDefaultValue() {
            EEnum eenum = (EEnum)this.getFeature().getEType();
            String defaultValueLiteral = this.getFeature().getDefaultValueLiteral();
            if (defaultValueLiteral != null) {
                EEnumLiteral literal = eenum.getEEnumLiteralByLiteral(defaultValueLiteral);
                if (literal == null) {
                    OM.LOG.warn(MessageFormat.format(Messages.getString("DBStore.13"), this.getFeature().getDefaultValueLiteral(), this.getFeature()));
                    literal = (EEnumLiteral)eenum.getDefaultValue();
                }
                return literal.getValue();
            }
            Enumerator enumerator = (Enumerator)eenum.getDefaultValue();
            return enumerator.getValue();
        }
    }

    public static class TMFloat
    extends TypeMapping {
        public TMFloat(IMappingStrategy strategy, EStructuralFeature feature, DBType type) {
            super(strategy, feature, type);
        }

        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return Float.valueOf(resultSet.getFloat(this.getField().getName()));
        }
    }

    public static class TMInteger
    extends TypeMapping {
        public TMInteger(IMappingStrategy strategy, EStructuralFeature feature, DBType type) {
            super(strategy, feature, type);
        }

        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getInt(this.getField().getName());
        }
    }

    public static class TMLong
    extends TypeMapping {
        public TMLong(IMappingStrategy strategy, EStructuralFeature feature, DBType type) {
            super(strategy, feature, type);
        }

        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getLong(this.getField().getName());
        }
    }

    public static class TMObject
    extends TypeMapping {
        public TMObject(IMappingStrategy strategy, EStructuralFeature feature, DBType type) {
            super(strategy, feature, type);
        }

        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            long id = resultSet.getLong(this.getField().getName());
            if (resultSet.wasNull()) {
                return this.getFeature().isUnsettable() ? CDORevisionData.NIL : null;
            }
            IExternalReferenceManager externalRefs = this.getMappingStrategy().getStore().getExternalReferenceManager();
            return CDODBUtil.convertLongToCDOID(externalRefs, this.getAccessor(), id);
        }

        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            IDBStore store = this.getMappingStrategy().getStore();
            IExternalReferenceManager externalReferenceManager = store.getExternalReferenceManager();
            IStoreAccessor.CommitContext commitContext = StoreThreadLocal.getCommitContext();
            long commitTime = commitContext.getBranchPoint().getTimeStamp();
            long id = CDODBUtil.convertCDOIDToLong(externalReferenceManager, this.getAccessor(), (CDOID)value, commitTime);
            super.doSetValue(stmt, index, id);
        }

        private IDBStoreAccessor getAccessor() {
            IStoreAccessor accessor = StoreThreadLocal.getAccessor();
            if (accessor == null) {
                throw new IllegalStateException("Can only be called from within a valid IDBStoreAccessor context");
            }
            return (IDBStoreAccessor)accessor;
        }
    }

    public static class TMShort
    extends TypeMapping {
        public TMShort(IMappingStrategy strategy, EStructuralFeature feature, DBType type) {
            super(strategy, feature, type);
        }

        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getShort(this.getField().getName());
        }
    }

    public static class TMString
    extends TypeMapping {
        public TMString(IMappingStrategy strategy, EStructuralFeature feature, DBType type) {
            super(strategy, feature, type);
        }

        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getString(this.getField().getName());
        }
    }
}

